/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.EditAttTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.EditLabelPanel;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.bsh.BshCalculator;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.geotools.feature.type.Types;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.feature.type.AttributeDescriptor;

public class RotateLabelTool
extends NClickTool {
    private RotateLabelTool() {
        super(2);
        this.allowSnapping();
        this.setColor(Color.BLUE);
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        if (this.getCoordinates().isEmpty()) {
            GeneralPath path = new GeneralPath();
            this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
            return path;
        }
        Point2D firstPoint = this.getPanel().getViewport().toViewPoint(this.getCoordinates().get(0));
        Point2D tentativePoint = this.getPanel().getViewport().toViewPoint(this.getTentativeCoordinate());
        double dblOri = ConstSupport.getOrientation((Point2D)firstPoint, (Point2D)tentativePoint, (int)2);
        Point2D textPoint = ConstSupport.getPolarPoint2D((Point2D)firstPoint, (double)50.0, (double)(dblOri += 1.5707963267948966));
        GeneralPath path = new GeneralPath();
        path.moveTo((float)textPoint.getX(), (float)textPoint.getY());
        path.lineTo((float)firstPoint.getX(), (float)firstPoint.getY());
        path.lineTo((int)tentativePoint.getX(), (int)tentativePoint.getY());
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        return path;
    }

    @Override
    public Cursor createCursor() {
        return RotateLabelTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_rotate_label.svg").getImage());
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return new RotateLabelTool();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"label_rotate.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.label.RotateLabelTool.name");
    }

    @Override
    protected void gestureFinished() throws Exception {
        int intSelCount = this.getPanel().getSelectionManager().getFeatureSelection().getSelectedItems().size();
        if (intSelCount < 1) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.label.RotateLabelTool.no-selection"));
            return;
        }
        List<Coordinate> lstCoord = this.getCoordinates();
        Coordinate coord1 = lstCoord.get(0);
        Coordinate coord2 = lstCoord.get(1);
        double dblOri = ConstSupport.getOrientation((Coordinate)coord1, (Coordinate)coord2, (int)0);
        dblOri += 90.0;
        Collection<Layer> colLy = this.getPanel().getSelectionManager().getLayersWithSelectedItems();
        Iterator<Layer> iLy = colLy.iterator();
        ArrayList<EditAttTransaction> lstTrans = new ArrayList<EditAttTransaction>();
        while (iLy.hasNext()) {
            Layer ly = iLy.next();
            String strOriAtt = ly.getFMD().getTextOriAtt();
            String strOriTrans = ly.getFMD().getOriTrans();
            if (strOriAtt == null || strOriAtt.length() <= 0 || ly.getFeatureType().indexOf(strOriAtt) <= -1) continue;
            EditAttTransaction trans = this.createTransaction(ly);
            if (strOriTrans == null || strOriTrans.trim().length() == 0) {
                Object objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strOriAtt), (Object)new Double(dblOri));
                trans.addAttribute(strOriAtt, objOri);
            } else {
                BshCalculator calc = ly.getFMD().getOriTransCalc();
                calc.setValue(dblOri);
                Object objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strOriAtt), (Object)new Double(calc.getDouble()));
                trans.addAttribute(strOriAtt, objOri);
            }
            lstTrans.add(trans);
        }
        EditAttTransaction.commit(lstTrans);
    }

    private EditAttTransaction createTransaction(Layer layer) {
        return EditAttTransaction.createTransactionOnSelection(WorkbenchContext.getInstance().getLayerViewPanel(), WorkbenchContext.getInstance().getLayerViewPanel().getContext(), this.getName(), layer);
    }

    public static EnableCheck createEnableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String strCheck = EditingPanel.instanceOf().getInternalFrameActiveCheck().check(component);
                if (strCheck != null) {
                    return strCheck;
                }
                Collection<Layer> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
                if (colSelLy.size() != 1) {
                    return "Only items on one layer should be selected.";
                }
                for (Layer ly2test : EditingPanel.instanceOf().getEditableLayers()) {
                    if (!colSelLy.contains(ly2test) || ly2test.getFMD().getTextOriAtt() == null || ly2test.getFMD().getTextOriAtt().length() <= 0) continue;
                    return null;
                }
                return "The layer must have a label orientation.";
            }
        };
    }

    @Override
    public JPanel getAssistentPanel() {
        return EditLabelPanel.instanceOf();
    }
}

