/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.EditAttTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.EditLabelPanel;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.type.Types;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;

public class PlaceLabelTool
extends NClickTool {
    private PlaceLabelTool() {
        super(2);
        this.allowSnapping();
        this.setColor(Color.BLUE);
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        if (this.getCoordinates().isEmpty()) {
            GeneralPath path = new GeneralPath();
            this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
            return path;
        }
        Point2D firstPoint = this.getPanel().getViewport().toViewPoint(this.getCoordinates().get(0));
        Point2D tentativePoint = this.getPanel().getViewport().toViewPoint(this.getTentativeCoordinate());
        double dblOri = ConstSupport.getOrientation((Point2D)firstPoint, (Point2D)tentativePoint, (int)2);
        Point2D arrowPoint1 = ConstSupport.getPolarPoint2D((Point2D)tentativePoint, (double)12.0, (double)(dblOri += 0.5235987755982988));
        Point2D arrowPoint2 = ConstSupport.getPolarPoint2D((Point2D)tentativePoint, (double)12.0, (double)(dblOri -= 1.0471975511965976));
        GeneralPath path = new GeneralPath();
        path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
        path.lineTo((int)tentativePoint.getX(), (int)tentativePoint.getY());
        path.lineTo((float)arrowPoint1.getX(), (float)arrowPoint1.getY());
        path.moveTo((float)tentativePoint.getX(), (float)tentativePoint.getY());
        path.lineTo((float)arrowPoint2.getX(), (float)arrowPoint2.getY());
        return path;
    }

    @Override
    public Cursor createCursor() {
        return PlaceLabelTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_place.svg").getImage());
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return new PlaceLabelTool();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"label_move.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.label.PlaceLabelTool.name");
    }

    @Override
    protected void gestureFinished() throws Exception {
        int intSelCount = this.getPanel().getSelectionManager().getFeatureSelection().getSelectedItems().size();
        if (intSelCount < 1) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.label.PlaceLabelTool.no-selection"));
            return;
        }
        List<Coordinate> lstCoord = this.getCoordinates();
        Coordinate coord1 = lstCoord.get(0);
        Coordinate coord2 = lstCoord.get(1);
        double dx = coord2.x - coord1.x;
        double dy = coord2.y - coord1.y;
        Collection<Layer> colLy = this.getPanel().getSelectionManager().getLayersWithSelectedItems();
        Iterator<Layer> iLy = colLy.iterator();
        ArrayList<EditAttTransaction> lstTrans = new ArrayList<EditAttTransaction>();
        while (iLy.hasNext()) {
            Layer ly = iLy.next();
            String strDXAtt = ly.getFMD().getTextDXAtt();
            String strDYAtt = ly.getFMD().getTextDYAtt();
            if (strDXAtt == null || strDXAtt.length() <= 0 || strDYAtt == null || strDYAtt.length() <= 0 || ly.getFeatureType().indexOf(strDXAtt) <= -1 || ly.getFeatureType().indexOf(strDYAtt) <= -1) continue;
            EditAttTransaction trans = this.createTransaction(ly);
            double dxFeat = 0.0;
            double dyFeat = 0.0;
            double textOriFeat = 0.0;
            double dxTrans = dx;
            double dyTrans = dy;
            String strTextOriAtt = ly.getFMD().getTextOriAtt();
            boolean useTextTransInOri = false;
            if (ly.getFMD().isTextTransInOri() && StringUtils.isNotBlank((CharSequence)strTextOriAtt) && ly.getFeatureType().indexOf(strTextOriAtt) > -1) {
                useTextTransInOri = true;
            }
            for (SimpleFeature feat : this.getPanel().getSelectionManager().getFeaturesWithSelectedItems(ly)) {
                Object objTextOri;
                Object objDY;
                Object objDX = feat.getAttribute(strDXAtt);
                if (objDX != null) {
                    if (objDX instanceof Number) {
                        dxFeat = ((Number)objDX).doubleValue();
                    } else {
                        try {
                            dxFeat = Double.parseDouble(objDX.toString());
                        }
                        catch (Exception e) {
                            dxFeat = 0.0;
                        }
                    }
                }
                if ((objDY = feat.getAttribute(strDYAtt)) != null) {
                    if (objDY instanceof Number) {
                        dyFeat = ((Number)objDY).doubleValue();
                    } else {
                        try {
                            dyFeat = Double.parseDouble(objDY.toString());
                        }
                        catch (Exception e) {
                            dyFeat = 0.0;
                        }
                    }
                }
                if (useTextTransInOri && (objTextOri = feat.getAttribute(strTextOriAtt)) != null) {
                    if (objTextOri instanceof Number) {
                        textOriFeat = ((Number)objTextOri).doubleValue();
                    } else {
                        try {
                            textOriFeat = Double.parseDouble(objTextOri.toString());
                        }
                        catch (Exception e) {
                            textOriFeat = 0.0;
                        }
                    }
                    double cosAngle = Math.cos(Math.toRadians(textOriFeat));
                    double sinAngle = Math.sin(Math.toRadians(textOriFeat));
                    dxTrans = dx * cosAngle + dy * sinAngle;
                    dyTrans = dy * cosAngle - dx * sinAngle;
                }
                objDX = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strDXAtt), (Object)new Double(dxFeat + dxTrans));
                trans.addAttribute(strDXAtt, objDX);
                objDY = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strDYAtt), (Object)new Double(dyFeat + dyTrans));
                trans.addAttribute(strDYAtt, objDY);
                lstTrans.add(trans);
            }
        }
        EditAttTransaction.commit(lstTrans);
    }

    private EditAttTransaction createTransaction(Layer layer) {
        return EditAttTransaction.createTransactionOnSelection(WorkbenchContext.getInstance().getLayerViewPanel(), WorkbenchContext.getInstance().getLayerViewPanel().getContext(), this.getName(), layer);
    }

    public static EnableCheck createEnableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String strCheck = EditingPanel.instanceOf().getInternalFrameActiveCheck().check(component);
                if (strCheck != null) {
                    return strCheck;
                }
                Collection<Layer> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
                if (colSelLy.size() != 1) {
                    return "Only items on one layer should be selected.";
                }
                for (Layer ly2test : EditingPanel.instanceOf().getEditableLayers()) {
                    if (!colSelLy.contains(ly2test) || !ly2test.getFMD().getUseText() || ly2test.getFMD().getTextDXAtt() == null || ly2test.getFMD().getTextDXAtt().length() <= 0 || ly2test.getFMD().getTextDYAtt() == null || ly2test.getFMD().getTextDYAtt().length() <= 0) continue;
                    return null;
                }
                return "The layer must have a label dx and dy.";
            }
        };
    }

    @Override
    public JPanel getAssistentPanel() {
        return EditLabelPanel.instanceOf();
    }
}

