/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.geom.InteriorPointFinder;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.GetLabelPropertiesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.geotools.feature.type.Types;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class LabelForSelectionPlugIn
extends AbstractPlugIn {
    private static final InteriorPointFinder iPointFinder = new InteriorPointFinder();
    private static final GeometryFactory gfac = new GeometryFactory();
    private static EnableCheck enableCheck = null;

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.label.LabelForObjectPlugIn.name");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"label_object.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer lyText = EditingPanel.instanceOf().getCurrentLayer();
        String strTxtAtt = lyText.getFMD().getTextAtt();
        ArrayList<UndoableCommand> lstCommand = new ArrayList<UndoableCommand>();
        for (Layer ly : context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems()) {
            Iterator<SimpleFeature> iFeat = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(ly).iterator();
            ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
            while (iFeat.hasNext()) {
                SimpleFeature feat = iFeat.next();
                Geometry geom = (Geometry)feat.getDefaultGeometry();
                if (geom == null || geom.isEmpty()) continue;
                Coordinate coordTxt = this.getTextPosition(geom);
                LayerStyleCollection sCol = ly.getValidLayerStyleCollection();
                String strLabel = "";
                strLabel = ly instanceof RedlineLayer ? GetLabelPropertiesPlugIn.retrieveTextByGeom(geom) : GetLabelPropertiesPlugIn.retrieveTextByLSC(sCol, feat, "");
                SimpleFeature feature = FeatureUtil.createFeature((SimpleFeatureType)lyText.getFeatureType(), (Geometry)gfac.createPoint(coordTxt));
                if (strTxtAtt != null && strTxtAtt.length() > 0 && lyText.getFeatureType().indexOf(strTxtAtt) > -1) {
                    Object objText = Types.parse((AttributeDescriptor)lyText.getFeatureType().getDescriptor(strTxtAtt), (Object)strLabel);
                    feature.setAttribute(strTxtAtt, objText);
                }
                lstFeatures.add(feature);
            }
            lstCommand.add(this.createAddCommand(lyText, lstFeatures));
        }
        LabelForSelectionPlugIn.execute(lstCommand, (LayerManagerProxy)context);
        SaveLayerFeatureChangesPlugIn.commitLayer(lyText, true, false, false);
        return true;
    }

    private UndoableCommand createAddCommand(final Layer ly, final Collection colFeatures) throws Exception {
        UndoableCommand command = new UndoableCommand(this, "AddDeleteFromRedline"){

            @Override
            public void execute() {
                ly.editFeature(colFeatures, 1);
            }

            @Override
            public void unexecute() {
                ly.editFeature(colFeatures, 3);
            }
        };
        return command;
    }

    private Coordinate getTextPosition(Geometry geom) {
        if (geom == null || geom.isEmpty()) {
            return null;
        }
        if (geom instanceof Point) {
            return geom.getCoordinates()[0];
        }
        if (geom instanceof LineString) {
            LineString line = (LineString)geom;
            LineSegment lseg = TextRenderer.longestSegment((Geometry)line);
            return CoordUtil.average(lseg.p0, lseg.p1);
        }
        if (geom instanceof Polygon) {
            Polygon poly = (Polygon)geom;
            return iPointFinder.findPoint((Geometry)poly);
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollection gcol = (GeometryCollection)geom;
            return this.getTextPosition(gcol.getGeometryN(0));
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                LayerViewPanel lvp;
                if (EditingPanel.instanceOf().getCurrentLayer() == null) {
                    return "No editable layer";
                }
                if (!EditingPanel.instanceOf().getCurrentLayer().getFMD().getUseText()) {
                    return "Labeling disabled.";
                }
                if (enableCheck == null) {
                    enableCheck = EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{Point.class});
                }
                if ((lvp = WorkbenchContext.getInstance().getLayerViewPanel()) != null) {
                    int intSelSize = lvp.getSelectionManager().getSelectedItems().size();
                    if (intSelSize < 1) {
                        return "No feature selected.";
                    }
                } else {
                    return "No open project found.";
                }
                return enableCheck.check(component);
            }
        };
    }
}

