/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.EditLabelPanel;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.reduction.ProjectionReduction;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Objects;
import javax.swing.ImageIcon;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLabelPropertiesPlugIn
extends AbstractPlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetLabelPropertiesPlugIn.class);
    private static final DecimalFormat df = new DecimalFormat();
    private static final DecimalFormat dfArea;

    GetLabelPropertiesPlugIn() {
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.label.GetLabelPropertiesPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"label_get_attributes.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SelectionManager selectionManager = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager();
        Collection<Layer> colSelLy = selectionManager.getLayersWithSelectedItems();
        if (colSelLy.size() == 1) {
            Layer ly = colSelLy.iterator().next();
            Collection<SimpleFeature> colSel = selectionManager.getFeaturesWithSelectedItems();
            if (colSel.size() == 1) {
                SimpleFeature feat = colSel.iterator().next();
                FeaturestoreMetadata fmd = ly.getFMD();
                if (fmd.getUseText() && fmd.getTextAtt() != null && fmd.getTextAtt().length() > 0) {
                    this.retrieveLabelFromFMD(ly, feat);
                } else {
                    LayerStyleCollection scol = (LayerStyleCollection)ly.getValidStyleCollection();
                    EditLabelPanel.instanceOf().setText(GetLabelPropertiesPlugIn.retrieveTextByLSC(scol, feat, ""));
                }
            }
        }
        return true;
    }

    private void retrieveLabelFromFMD(Layer ly, SimpleFeature feat) {
        Object objOri;
        String strText = ly.getFMD().getTextAtt();
        String strTextOri = ly.getFMD().getTextOriAtt();
        String strTextValue = "";
        if (strText != null && strText.length() > 0 && feat.getFeatureType().indexOf(strText) > -1) {
            strTextValue = Objects.toString(FeatureUtil.getAttribute((SimpleFeature)feat, (String)strText), "");
        }
        EditLabelPanel.instanceOf().setText(strTextValue);
        double dblOri = 0.0;
        if (strTextOri != null && strTextOri.length() > 0 && feat.getFeatureType().indexOf(strTextOri) > -1 && (objOri = FeatureUtil.getAttribute((SimpleFeature)feat, (String)strTextOri)) != null) {
            if (objOri instanceof Number) {
                dblOri = ((Number)objOri).doubleValue();
            } else {
                try {
                    dblOri = Double.parseDouble(objOri.toString());
                }
                catch (Exception e) {
                    log.debug("Could not parse orientation", (Throwable)e);
                    dblOri = 0.0;
                }
            }
        }
        EditLabelPanel.instanceOf().setOri(dblOri);
    }

    @Override
    public EnableCheck createEnableCheck() {
        return component -> {
            String strCheck = EditingPanel.instanceOf().getInternalFrameActiveCheck().check(component);
            if (strCheck != null) {
                return strCheck;
            }
            int intSelSize = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getSelectedItems().size();
            if (intSelSize != 1) {
                return "Exactly one item should be selected.";
            }
            return null;
        };
    }

    public static final String retrieveTextByGeom(Geometry geom) {
        if (geom == null || geom.isEmpty()) {
            return "";
        }
        String strUnitShort = WorkbenchContext.getTask().getDrawingUnit().getUnitAbbreviation();
        ProjectionReduction projectionReduction = ProjectionReduction.getInstance();
        if (geom instanceof Point) {
            return " (" + df.format(geom.getCoordinates()[0].x) + strUnitShort + " / " + df.format(geom.getCoordinates()[0].y) + strUnitShort + ") ";
        }
        if (geom instanceof LineString) {
            return I18N.get("common.length") + ": " + df.format(projectionReduction.calculateRealWorldLength(geom)) + strUnitShort;
        }
        if (geom instanceof Polygon) {
            return I18N.get("common.area") + ": " + dfArea.format(projectionReduction.calculateRealWorldArea(geom)) + strUnitShort + "\u00b2";
        }
        if (geom.getArea() > 0.0) {
            return I18N.get("common.area") + ": " + dfArea.format(projectionReduction.calculateRealWorldArea(geom)) + strUnitShort + "\u00b2";
        }
        if (geom.getLength() > 0.0) {
            return I18N.get("common.length") + ": " + df.format(projectionReduction.calculateRealWorldLength(geom)) + strUnitShort;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < geom.getCoordinates().length; ++i) {
            if (i > 0) {
                builder.append("\n");
            }
            builder.append("(").append(df.format(geom.getCoordinates()[0].x)).append(strUnitShort).append(" / ").append(df.format(geom.getCoordinates()[0].y)).append(strUnitShort).append(" ) ");
            if (i <= 50) continue;
            builder.append("\n...");
            break;
        }
        return builder.toString();
    }

    public static final String retrieveTextByLSC(LayerStyleCollection scol, SimpleFeature feat, String defaultText) {
        if (scol == null) {
            return defaultText;
        }
        if (scol.getLayer() instanceof AbstractCadLayer) {
            String strText = (String)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.TEXT.getName());
            if (strText == null || strText.isEmpty()) {
                return defaultText;
            }
            return strText;
        }
        if (scol.getLayer().getClass().equals(Layer.class)) {
            String strText = defaultText;
            BasicStyleModel bStyle = scol.getBasicStyle();
            if (bStyle == null) {
                return defaultText;
            }
            if (scol.getBasicStyle().isRenderingText()) {
                strText = (String)StringUtils.defaultIfBlank((CharSequence)RenderUtil.getRenderer(scol.getBasicStyle().getTextStyle()).getTextForFeature(feat), (CharSequence)"");
            } else if (scol.getBasicStyle().isShowTooltips()) {
                strText = (String)StringUtils.defaultIfBlank((CharSequence)RenderUtil.getRenderer(scol.getBasicStyle().getTooltipStyle()).getTextForFeature(feat), (CharSequence)"");
            }
            return strText;
        }
        return defaultText;
    }

    static {
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(3);
        df.setMinimumFractionDigits(3);
        dfArea = new DecimalFormat();
        dfArea.setGroupingUsed(false);
        dfArea.setMaximumFractionDigits(2);
        dfArea.setMinimumFractionDigits(2);
    }
}

