/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckable;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.DrawLabelTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.GetLabelPropertiesPlugIn;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.LabelForSelectionPlugIn;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.PlaceLabelTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.SetLabelPropertiesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPanel;
import de.riwagis.util.gui.GUISupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditLabelPanel
extends JPanel
implements EnableCheckable {
    private static final Logger LOG = LoggerFactory.getLogger(EditLabelPanel.class);
    private static final String KEY_SET_ROTATION = EditLabelPanel.class.getName() + "-KEY_SET_ROTATION";
    private static final String KEY_SET_ROTATION_POINT = EditLabelPanel.class.getName() + "-KEY_SET_ROTATION_POINT";
    private final ToolboxPanel pnlToolbox = new ToolboxPanel();
    private final DecimalFormat df = new DecimalFormat();
    private static EditLabelPanel editLabelPanel = null;
    private CursorTool ctDrawLabel = null;
    private static final EnableCheck chkLyUseLabel = new EnableCheck(){

        @Override
        public String check(JComponent component) {
            if (EditingPanel.instanceOf().getCurrentLayer() == null || EditingPanel.instanceOf().getCurrentLayer().getFMD() == null || EditingPanel.instanceOf().getCurrentLayer() instanceof DimLayer) {
                return "No editable layer";
            }
            if (!EditingPanel.instanceOf().getCurrentLayer().getFMD().getUseText()) {
                return "Labeling disabled.";
            }
            return null;
        }
    };
    public static final EnableCheck chkLyUseLabelOrientation = new EnableCheck(){

        @Override
        public String check(JComponent component) {
            if (EditingPanel.instanceOf().getCurrentLayer() == null || EditingPanel.instanceOf().getCurrentLayer().getFMD() == null || EditingPanel.instanceOf().getCurrentLayer() instanceof DimLayer) {
                return "No editable layer";
            }
            if (!EditingPanel.instanceOf().getCurrentLayer().getFMD().getUseText()) {
                return "Labeling disabled.";
            }
            if (EditingPanel.instanceOf().getCurrentLayer().getFMD().getTextOriAtt() == null || EditingPanel.instanceOf().getCurrentLayer().getFMD().getTextOriAtt().isEmpty()) {
                return "No label orientation";
            }
            return null;
        }
    };
    private JCheckBox cbSetRotation;
    private JCheckBox cbSetRotationPoint;
    private JScrollPane jScrollPane1;
    private JLabel lblOri;
    private JLabel lblText;
    private JPanel pnlTools;
    private JTextArea txaText;
    private JFormattedTextField txtOri;

    private EditLabelPanel() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    public static EditLabelPanel instanceOf() {
        if (editLabelPanel == null) {
            editLabelPanel = new EditLabelPanel();
        }
        return editLabelPanel;
    }

    public void i18n() {
        this.lblOri.setText(I18N.get("ui.cursortool.editing.label.EditingLabelPanel.ori"));
        this.lblText.setText(I18N.get("ui.cursortool.editing.label.EditingLabelPanel.text"));
        this.cbSetRotation.setText(I18N.get("ui.cursortool.editing.label.EditingLabelPanel.set-rotation"));
        this.cbSetRotationPoint.setText(I18N.get("ui.cursortool.editing.label.EditingLabelPanel.set-rotation-point"));
        GUISupport.addCopyInsertPopup((JTextComponent)this.txaText);
        GUISupport.addCopyInsertPopup((JTextComponent)this.txtOri);
    }

    public void init() {
        this.pnlTools.add((Component)this.pnlToolbox, "Center");
        this.ctDrawLabel = DrawLabelTool.create(this.pnlToolbox.getContext());
        this.pnlToolbox.add(this.ctDrawLabel, DrawLabelTool.createEnableCheck());
        this.pnlToolbox.add(PlaceLabelTool.create(this.pnlToolbox.getContext()), PlaceLabelTool.createEnableCheck());
        this.pnlToolbox.getToolBar().addSeparator();
        GetLabelPropertiesPlugIn glpPlugIn = new GetLabelPropertiesPlugIn();
        this.pnlToolbox.addPlugIn(glpPlugIn, glpPlugIn.createEnableCheck(), glpPlugIn.getIcon());
        SetLabelPropertiesPlugIn slpPlugIn = new SetLabelPropertiesPlugIn();
        this.pnlToolbox.addPlugIn(slpPlugIn, slpPlugIn.createEnableCheck(), slpPlugIn.getIcon());
        this.pnlToolbox.getToolBar().addSeparator();
        LabelForSelectionPlugIn l4sPlugIn = new LabelForSelectionPlugIn();
        this.pnlToolbox.addPlugIn(l4sPlugIn, l4sPlugIn.createEnableCheck(), l4sPlugIn.getIcon());
        this.df.setGroupingUsed(false);
        this.txtOri.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtOri.setHorizontalAlignment(4);
        this.txaText.setFont(this.txtOri.getFont());
        Boolean boolSetRotation = PersistentBlackboardPlugIn.get().getBoolean(KEY_SET_ROTATION);
        if (boolSetRotation != null) {
            this.cbSetRotation.setSelected(boolSetRotation);
            this.cbSetRotationPoint.setEnabled(this.cbSetRotation.isEnabled() && boolSetRotation != false);
        }
        this.cbSetRotation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                PersistentBlackboardPlugIn.get().put(KEY_SET_ROTATION, selected);
                EditLabelPanel.this.cbSetRotationPoint.setEnabled(selected);
            }
        });
        Boolean boolSetRotationPoint = PersistentBlackboardPlugIn.get().getBoolean(KEY_SET_ROTATION_POINT);
        if (boolSetRotationPoint != null) {
            this.cbSetRotationPoint.setSelected(boolSetRotationPoint);
        }
        this.cbSetRotationPoint.addItemListener(new ItemListener(this){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                PersistentBlackboardPlugIn.get().put(KEY_SET_ROTATION_POINT, selected);
            }
        });
    }

    public void activateDrawLabelTool(LayerViewPanel lyViewPanel) {
        if (chkLyUseLabel.check(null) == null) {
            this.pnlToolbox.getToolBar().getButton(0).doClick();
        }
    }

    @Override
    public void updateEnabledState() {
        this.cbSetRotation.setEnabled(chkLyUseLabelOrientation.check(null) == null);
        this.cbSetRotationPoint.setEnabled(this.cbSetRotation.isEnabled() && this.cbSetRotation.isSelected());
        this.pnlToolbox.updateEnabledState();
    }

    public String getText() {
        return this.txaText.getText();
    }

    public void setText(String strText) {
        this.txaText.setText(strText);
    }

    public double getOri() {
        try {
            return this.df.parse(this.txtOri.getText()).doubleValue();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void setOri(double dblOri) {
        this.txtOri.setText(this.df.format(dblOri));
    }

    public boolean isSetRotationSelected() {
        return this.cbSetRotation.isEnabled() && this.cbSetRotation.isSelected();
    }

    public boolean isSetRotationPointSelected() {
        return this.cbSetRotationPoint.isEnabled() && this.cbSetRotationPoint.isSelected();
    }

    public static EnableCheck getLayerUseLabelCheck() {
        return chkLyUseLabel;
    }

    private void initComponents() {
        this.lblText = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txaText = new JTextArea();
        this.txtOri = new JFormattedTextField();
        this.lblOri = new JLabel();
        this.cbSetRotation = new JCheckBox();
        this.cbSetRotationPoint = new JCheckBox();
        this.pnlTools = new JPanel();
        this.setEnabled(false);
        this.setPreferredSize(new Dimension(180, 200));
        this.setLayout(new GridBagLayout());
        this.lblText.setText("Text:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblText, gridBagConstraints);
        this.jScrollPane1.setDoubleBuffered(true);
        this.jScrollPane1.setPreferredSize(new Dimension(140, 70));
        this.txaText.setFont(UIManager.getFont("TextField.font").deriveFont(12.0f));
        this.jScrollPane1.setViewportView(this.txaText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtOri, gridBagConstraints);
        this.lblOri.setText("Orientierung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblOri, gridBagConstraints);
        this.cbSetRotation.setText("Drehung erfassen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbSetRotation, gridBagConstraints);
        this.cbSetRotationPoint.setText("Drehpunkt automatisch setzen");
        this.cbSetRotationPoint.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 99999.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbSetRotationPoint, gridBagConstraints);
        this.pnlTools.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlTools, gridBagConstraints);
    }
}

