/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotateSelectedItemPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotateSymbolAndTextTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.EditLabelPanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.bsh.BshCalculator;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.geotools.feature.type.Types;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class DrawLabelTool
extends NClickTool {
    private static EnableCheck enableCheck = null;

    private DrawLabelTool() {
        super(1);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new DrawLabelTool(), true);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_label.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.label.DrawLabelTool.name");
    }

    @Override
    protected void gestureFinished() throws Exception {
        String strOriAtt;
        Layer layer = FeatureDrawingUtil.layer();
        SimpleFeature feature = FeatureUtil.createFeature((SimpleFeatureType)layer.getFeatureType(), (Geometry)this.getPoint());
        String strTxtAtt = layer.getFMD().getTextAtt();
        if (strTxtAtt != null && strTxtAtt.length() > 0 && layer.getFeatureType().indexOf(strTxtAtt) > -1) {
            Object objText = Types.parse((AttributeDescriptor)layer.getFeatureType().getDescriptor(strTxtAtt), (Object)EditLabelPanel.instanceOf().getText());
            feature.setAttribute(strTxtAtt, objText);
        }
        if ((strOriAtt = layer.getFMD().getTextOriAtt()) != null && strOriAtt.length() > 0 && layer.getFeatureType().indexOf(strOriAtt) > -1) {
            if (layer.getFMD().getOriTrans() == null || layer.getFMD().getOriTrans().trim().length() == 0) {
                Object objOri = Types.parse((AttributeDescriptor)layer.getFeatureType().getDescriptor(strOriAtt), (Object)new Double(new Double(EditLabelPanel.instanceOf().getOri())));
                feature.setAttribute(strOriAtt, objOri);
            } else {
                BshCalculator calc = layer.getFMD().getOriTransCalc();
                calc.setValue(EditLabelPanel.instanceOf().getOri());
                Object objOri = Types.parse((AttributeDescriptor)layer.getFeatureType().getDescriptor(strOriAtt), (Object)new Double(calc.getDouble()));
                feature.setAttribute(strOriAtt, objOri);
            }
        }
        if (EditLabelPanel.instanceOf().isSetRotationSelected()) {
            this.execute(FeatureDrawingUtil.createAddCommand(feature, this.isRollingBackInvalidEdits(), this.getPanel(), FeatureDrawingUtil.layer(), this.getName(), true));
            EditingPanel.instanceOf().activatePanel(RotateSelectedItemPanel.instanceOf());
            RotateSelectedItemPanel.instanceOf().activateRotateSymbolAndTextTool(this.getPanel());
            if (EditLabelPanel.instanceOf().isSetRotationPointSelected()) {
                java.awt.Point pt = this.getPanel().getLastClickedPoint();
                this.getPanel().dispatchEvent(new MouseEvent(this.getPanel(), 501, System.currentTimeMillis(), 0, pt.x, pt.y, 1, false, 1));
            }
            AbstractCursorTool.Listener listener = new AbstractCursorTool.Listener(){

                @Override
                public void gestureFinished() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.doSomething();
                        }
                    });
                }

                @Override
                public void gestureCanceled() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.doSomething();
                        }
                    });
                }

                private void doSomething() {
                    SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
                    RotateSymbolAndTextTool.getInstance().remove(this);
                    RotateSymbolAndTextTool.getInstance().setUndoable(true);
                    EditLabelPanel.instanceOf().activateDrawLabelTool(DrawLabelTool.this.getPanel());
                }
            };
            RotateSymbolAndTextTool.getInstance().add(listener);
            RotateSymbolAndTextTool.getInstance().setUndoable(false);
        } else {
            this.execute(FeatureDrawingUtil.createAddCommand(feature, this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
            SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
        }
    }

    protected Point getPoint() throws NoninvertibleTransformException {
        return new GeometryFactory().createPoint(this.getCoordinates().get(0));
    }

    public static EnableCheck createEnableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (EditingPanel.instanceOf().getCurrentLayer() == null) {
                    return "No editable layer";
                }
                if (!EditingPanel.instanceOf().getCurrentLayer().getFMD().getUseText()) {
                    return "Labeling disabled.";
                }
                if (enableCheck == null) {
                    enableCheck = EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{Point.class});
                }
                return enableCheck.check(component);
            }
        };
    }

    @Override
    public JPanel getAssistentPanel() {
        return EditLabelPanel.instanceOf();
    }
}

