/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.experttools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.InsertVertexTool;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeperateLineStringTool
extends NClickTool {
    private static final Logger LOG = LoggerFactory.getLogger(SeperateLineStringTool.class);
    private static final int PIXEL_RANGE = 20;
    private final KeyListener klstEnter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10) {
                try {
                    SeperateLineStringTool.this.finishGesture();
                }
                catch (Exception e1) {
                    WorkbenchContext.getFrame().handleThrowable(e1);
                }
            }
        }
    };
    private final InsertVertexTool.SegmentUtilities segUtils = new InsertVertexTool.SegmentUtilities();

    public SeperateLineStringTool() {
        super(1);
        this.allowSnapping();
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.experttools.SeperateLineStringTool.name");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_cut_line.svg");
    }

    @Override
    public Cursor createCursor() {
        return SeperateLineStringTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_cut.svg").getImage());
    }

    @Override
    protected Shape getShape() {
        try {
            Coordinate coordPos = this.getTentativeCoordinate();
            Layer ly = SeperateLineStringTool.getLayer(this.getPanel());
            if (ly == null) {
                return null;
            }
            Collection<SimpleFeature> feats = SeperateLineStringTool.getFeature(this.getPanel(), ly);
            Pair<SimpleFeature, LineString> result = this.findNextSegmentInRange(coordPos, ly, feats);
            if (result != null) {
                SimpleFeature feat = (SimpleFeature)result.getLeft();
                LineString line = (LineString)result.getRight();
                SplitInfo sInfo = this.getSplitInfo(line, coordPos);
                if (sInfo != null) {
                    Viewport vp = this.getPanel().getViewport();
                    Point2D pSplit = vp.toViewPoint(sInfo.getSplitPoint());
                    Point2D pEnd = vp.toViewPoint(sInfo.getEndPoint());
                    double ori = ConstSupport.getOrientation((Point2D)pSplit, (Point2D)pEnd, (int)2);
                    GeneralPath path = new GeneralPath();
                    path.moveTo(pSplit.getX(), pSplit.getY());
                    Point2D p = ConstSupport.getPolarPoint2D((Point2D)pSplit, (double)20.0, (double)(ori + 1.5707963267948966));
                    path.moveTo(p.getX(), p.getY());
                    p = ConstSupport.getPolarPoint2D((Point2D)pSplit, (double)20.0, (double)(ori - 1.5707963267948966));
                    path.lineTo(p.getX(), p.getY());
                    Point2D pPlus = ConstSupport.getPolarPoint2D((Point2D)pSplit, (double)15.0, (double)(ori - Math.PI + 0.3141592653589793));
                    path.moveTo(pPlus.getX(), pPlus.getY());
                    p = ConstSupport.getPolarPoint2D((Point2D)pPlus, (double)5.0, (double)ori);
                    path.moveTo(p.getX(), p.getY());
                    p = ConstSupport.getPolarPoint2D((Point2D)pPlus, (double)5.0, (double)(ori + Math.PI));
                    path.lineTo(p.getX(), p.getY());
                    p = ConstSupport.getPolarPoint2D((Point2D)pPlus, (double)5.0, (double)(ori + 1.5707963267948966));
                    path.moveTo(p.getX(), p.getY());
                    p = ConstSupport.getPolarPoint2D((Point2D)pPlus, (double)5.0, (double)(ori - 1.5707963267948966));
                    path.lineTo(p.getX(), p.getY());
                    return path;
                }
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("Error drawing shape in SeperateLineStringTool", (Throwable)e);
            return null;
        }
    }

    private SplitInfo getSplitInfo(LineString line, Coordinate pos) {
        Coordinate[] arrCoord = line.getCoordinates();
        double minlength = Double.MAX_VALUE;
        SplitInfo sInfo = null;
        for (int i = 1; i < arrCoord.length; ++i) {
            double lengthSecLine;
            double lengthLine;
            Coordinate section = ConstSupport.getOrthoSection((Coordinate)arrCoord[i - 1], (Coordinate)arrCoord[i], (Coordinate)pos);
            double length = ConstSupport.getLength((Coordinate)section, (Coordinate)pos);
            if (!(length < minlength) || !(Math.abs((lengthLine = ConstSupport.getLength((Coordinate)arrCoord[i - 1], (Coordinate)arrCoord[i])) - (lengthSecLine = ConstSupport.getLength((Coordinate)arrCoord[i - 1], (Coordinate)section) + ConstSupport.getLength((Coordinate)arrCoord[i], (Coordinate)section))) < 1.0E-7)) continue;
            Coordinate snappedSection = this.getSnapManager().snap(this.getPanel(), section);
            if (!snappedSection.equals((Object)section) && Math.abs(lengthLine - (lengthSecLine = ConstSupport.getLength((Coordinate)arrCoord[i - 1], (Coordinate)snappedSection) + ConstSupport.getLength((Coordinate)arrCoord[i], (Coordinate)snappedSection))) < 1.0E-7) {
                section = snappedSection;
            }
            sInfo = new SplitInfo(section, arrCoord[i - 1], arrCoord[i], i - 1);
            minlength = length;
        }
        return sInfo;
    }

    private Pair<SimpleFeature, LineString> findNextSegmentInRange(Coordinate coordPos, Layer ly, Collection<SimpleFeature> feats) {
        double modelRange = this.modelRange();
        for (SimpleFeature feat : feats) {
            List<LineString> lines = SeperateLineStringTool.getGeometry(this.getPanel(), ly, feat);
            for (LineString line : lines) {
                LineSegment segmentInRange = this.segUtils.segmentInRange((Geometry)line, coordPos, modelRange);
                if (segmentInRange == null) continue;
                return Pair.of((Object)feat, (Object)line);
            }
        }
        return null;
    }

    @Override
    protected void gestureFinished() throws Exception {
        Coordinate coordPos = this.getTentativeCoordinate();
        final Layer ly = SeperateLineStringTool.getLayer(this.getPanel());
        if (ly == null) {
            return;
        }
        Collection<SimpleFeature> feats = SeperateLineStringTool.getFeature(this.getPanel(), ly);
        Pair<SimpleFeature, LineString> result = this.findNextSegmentInRange(coordPos, ly, feats);
        if (result != null) {
            final SimpleFeature feat = (SimpleFeature)result.getLeft();
            LineString line = (LineString)result.getRight();
            SplitInfo sInfo = this.getSplitInfo(line, coordPos);
            if (sInfo != null) {
                ArrayList<Coordinate> lstEdit = new ArrayList<Coordinate>();
                ArrayList<Coordinate> lstAdd = new ArrayList<Coordinate>();
                Coordinate[] arrCoordLine = line.getCoordinates();
                if (arrCoordLine[0].equals((Object)sInfo.getSplitPoint())) {
                    return;
                }
                if (arrCoordLine[arrCoordLine.length - 1].equals((Object)sInfo.getSplitPoint())) {
                    return;
                }
                for (int i = 0; i < arrCoordLine.length; ++i) {
                    if (i < sInfo.getSplitSegment()) {
                        lstEdit.add(arrCoordLine[i]);
                        continue;
                    }
                    if (i == sInfo.getSplitSegment()) {
                        lstEdit.add(arrCoordLine[i]);
                        if (!arrCoordLine[i].equals((Object)sInfo.getSplitPoint())) {
                            lstEdit.add(sInfo.getSplitPoint());
                        }
                        if (sInfo.getSplitPoint().equals((Object)arrCoordLine[i + 1])) continue;
                        lstAdd.add(sInfo.getSplitPoint());
                        continue;
                    }
                    lstAdd.add(arrCoordLine[i]);
                }
                GeometryFactory gfac = line.getFactory();
                LineString geom2Edit = gfac.createLineString(lstEdit.toArray(new Coordinate[0]));
                LineString geom2Add = gfac.createLineString(lstAdd.toArray(new Coordinate[0]));
                final SimpleFeature editFeat = FeatureUtil.cloneFeature((SimpleFeature)feat);
                Geometry wholeFeatGeom = (Geometry)editFeat.getDefaultGeometry();
                if (wholeFeatGeom instanceof GeometryCollection) {
                    ArrayList<Object> lstNewGeom = new ArrayList<Object>();
                    for (int i = 0; i < wholeFeatGeom.getNumGeometries(); ++i) {
                        Geometry cand = wholeFeatGeom.getGeometryN(i);
                        if (cand == line) continue;
                        lstNewGeom.add(cand);
                    }
                    lstNewGeom.add(geom2Edit);
                    geom2Edit = wholeFeatGeom.getFactory().buildGeometry(lstNewGeom);
                }
                editFeat.setDefaultGeometry((Object)geom2Edit);
                Layer ly2InsertTemp = EditingPanel.instanceOf().getCurrentLayer();
                if (ly.getFMD().isInsertAllowed()) {
                    ly2InsertTemp = ly;
                }
                final Layer ly2Insert = ly2InsertTemp;
                SimpleFeatureType ft = ly2Insert.getFeatureType();
                final SimpleFeature newFeat = FeatureUtil.createFeature((SimpleFeatureType)ft);
                FeatureUtil.copyFeatureData((SimpleFeature)editFeat, (SimpleFeature)newFeat);
                newFeat.setDefaultGeometry((Object)geom2Add);
                UndoableCommand command = new UndoableCommand(this, this.getName()){

                    @Override
                    public void execute() {
                        ArrayList<SimpleFeature> lstEditFeat = new ArrayList<SimpleFeature>();
                        lstEditFeat.add(editFeat);
                        ly.editFeature(lstEditFeat, 2);
                        ArrayList<SimpleFeature> lstAddFeat = new ArrayList<SimpleFeature>();
                        lstAddFeat.add(newFeat);
                        try {
                            if (ly instanceof AbstractCadLayer && ly2Insert instanceof AbstractCadLayer) {
                                ((AbstractCadLayer)ly).setUseDefaultFeature(false);
                            }
                            ly2Insert.editFeature(lstAddFeat, 1);
                        }
                        finally {
                            if (ly instanceof AbstractCadLayer) {
                                ((AbstractCadLayer)ly).setUseDefaultFeature(true);
                            }
                        }
                    }

                    @Override
                    public void unexecute() {
                        ArrayList<SimpleFeature> lstEditFeat = new ArrayList<SimpleFeature>();
                        lstEditFeat.add(feat);
                        ly.editFeature(lstEditFeat, 2);
                        ArrayList<SimpleFeature> lstDeleteFeat = new ArrayList<SimpleFeature>();
                        lstDeleteFeat.add(newFeat);
                        ly2Insert.editFeature(lstDeleteFeat, 3);
                    }
                };
                this.execute(command);
                SaveLayerFeatureChangesPlugIn.commitLayer(ly, true, false, false);
                SaveLayerFeatureChangesPlugIn.commitLayer(ly2Insert, false, true, false);
                WorkbenchContext.getInstance().getSelectionManager().clear();
                WorkbenchContext.getInstance().getSelectionManager().getFeatureSelection().selectItems(ly, editFeat);
                return;
            }
        }
    }

    private static Layer getLayer(LayerViewPanel panel) {
        if (panel == null) {
            return null;
        }
        Collection<Layer> colLy = panel.getSelectionManager().getLayersWithSelectedItems();
        if (colLy.size() != 1) {
            return null;
        }
        Layer ly = colLy.iterator().next();
        if (ly.isEditable()) {
            if (!ly.getFMD().isGeometryAllowed(LineString.class)) {
                return null;
            }
            if (!ly.getFMD().isInsertAllowed()) {
                Layer ly2Insert = EditingPanel.instanceOf().getCurrentLayer();
                if (ly2Insert != null && ly2Insert.getFMD().isGeometryAllowed(LineString.class)) {
                    return ly;
                }
                return null;
            }
            return ly;
        }
        return null;
    }

    private static Collection<SimpleFeature> getFeature(LayerViewPanel panel, Layer ly) {
        if (ly == null || panel == null) {
            return null;
        }
        Collection<SimpleFeature> colFeat = panel.getSelectionManager().getFeaturesWithSelectedItems(ly);
        if (colFeat.isEmpty()) {
            return Collections.emptyList();
        }
        return colFeat;
    }

    private static List<LineString> getGeometry(LayerViewPanel panel, Layer ly, SimpleFeature feat) {
        if (ly == null || panel == null || feat == null) {
            return Collections.emptyList();
        }
        Collection<Geometry> colGeom = panel.getSelectionManager().getSelectedItems(ly, feat);
        if (colGeom == null || colGeom.size() != 1) {
            return Collections.emptyList();
        }
        Geometry featGeom = colGeom.iterator().next();
        if (featGeom instanceof GeometryCollection) {
            return IntStream.range(0, featGeom.getNumGeometries()).mapToObj(arg_0 -> ((Geometry)featGeom).getGeometryN(arg_0)).filter(g -> g instanceof LineString).map(LineString.class::cast).collect(Collectors.toList());
        }
        if (featGeom instanceof LineString) {
            return Arrays.asList((LineString)featGeom);
        }
        return Collections.emptyList();
    }

    public static EnableCheck createEnableCheck() {
        final EnableCheck editSelCheck = EditingPanel.instanceOf().getEditSelectionLayerEnableCheck();
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                try {
                    String strEditCheck = editSelCheck.check(component);
                    if (strEditCheck != null) {
                        return strEditCheck;
                    }
                    Layer ly = SeperateLineStringTool.getLayer(WorkbenchContext.getInstance().getLayerViewPanel());
                    if (ly == null) {
                        return "Please select at least one feature with a linestring geometry.";
                    }
                    if (!ly.getFMD().isInsertAllowed()) {
                        return "Layer must be insertable";
                    }
                    Collection<SimpleFeature> feats = SeperateLineStringTool.getFeature(WorkbenchContext.getInstance().getLayerViewPanel(), ly);
                    if (feats.isEmpty()) {
                        return "Please select at least one feature with a linestring geometry.";
                    }
                    Stream allStrings = feats.stream().flatMap(feat -> SeperateLineStringTool.getGeometry(WorkbenchContext.getInstance().getLayerViewPanel(), ly, feat).stream());
                    if (allStrings.findAny().isEmpty()) {
                        return "Please select at least one feature with a linestring geometry.";
                    }
                    return null;
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Override
    public boolean isUndoable() {
        Layer activeLayer = this.getPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next();
        Layer ly2Insert = activeLayer.getFMD().isInsertAllowed() ? activeLayer : EditingPanel.instanceOf().getCurrentLayer();
        return ly2Insert instanceof RedlineLayer;
    }

    @Override
    public KeyListener getKeyListener() {
        return this.klstEnter;
    }

    private double modelRange() {
        return 20.0 / this.getPanel().getViewport().getScale();
    }

    private static class SplitInfo {
        private Coordinate splitPoint = null;
        private Coordinate startPoint = null;
        private Coordinate endPoint = null;
        private int splitSegment = -1;

        private SplitInfo(Coordinate splitPoint, Coordinate startPoint, Coordinate endPoint, int segment) {
            this.splitPoint = splitPoint;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.splitSegment = segment;
        }

        public Coordinate getEndPoint() {
            return this.endPoint;
        }

        public Coordinate getSplitPoint() {
            return this.splitPoint;
        }

        public int getSplitSegment() {
            return this.splitSegment;
        }

        public Coordinate getStartPoint() {
            return this.startPoint;
        }
    }
}

