/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.experttools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.jts.JTSSupport;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class MergeFeaturesPlugIn
extends AbstractPlugIn {
    private String strFirstDesc = I18N.get("ui.cursortool.editing.experttools.MergeFeaturesPlugIn.select-first");
    private String strSecondDesc = I18N.get("ui.cursortool.editing.experttools.MergeFeaturesPlugIn.select-second");
    private String strThirdDesc = I18N.get("ui.cursortool.editing.experttools.MergeFeaturesPlugIn.delete-second");
    private String strContinue = I18N.get("common.continue");
    private String strCancel = I18N.get("common.cancel");
    private String strBack = I18N.get("common.back");
    private String strYes = I18N.get("common.yes");
    private String strNo = I18N.get("common.no");
    private GeometryEditor geoEdit = new GeometryEditor();
    private Layer targetLayer = null;
    private SimpleFeature targetFeature = null;
    private Map<Layer, Set<SimpleFeature>> merges = new HashMap<Layer, Set<SimpleFeature>>();
    private final ActionListener listenFirstOK = e -> {
        Collection<Layer> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        if (colSelLy.size() == 1) {
            Layer ly = colSelLy.iterator().next();
            if (!ly.isEditable()) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.experttools.MergeFeaturesPlugIn.layer-not-editable"), (String)I18N.get("common.error"));
                return;
            }
            Collection<SimpleFeature> colSel = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
            if (colSel.size() == 1) {
                this.targetLayer = ly;
                this.targetFeature = colSel.iterator().next();
                this.execute_step2_sel_merges();
                return;
            }
        }
        GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.experttools.MergeFeaturesPlugIn.select-one"), (String)I18N.get("common.error"));
    };
    private final ActionListener listenFirstCancel = e -> EditingPanel.instanceOf().activateDefaultCT();
    private final ActionListener listenSecondOK = e -> {
        SelectionManager selectionManager = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager();
        Collection<Layer> layers = selectionManager.getLayersWithSelectedItems();
        boolean hasInsertableLayers = layers.stream().reduce(false, (prev, layer) -> prev != false || this.canLayerDelete((Layer)layer), (a, b) -> a != false || b != false);
        boolean isMasterSelected = layers.stream().flatMap(l -> selectionManager.getFeaturesWithSelectedItems((Layer)l).stream()).filter(f -> this.targetFeature.equals(f)).findAny().isPresent();
        if (isMasterSelected) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.experttools.MergeFeaturesPlugIn.first-sameas-second"), (String)I18N.get("common.error"));
            return;
        }
        this.merges = layers.stream().map(l -> Pair.of((Object)l, Set.copyOf(selectionManager.getFeaturesWithSelectedItems((Layer)l)))).collect(Collectors.toMap(x -> (Layer)x.getLeft(), x -> (Set)x.getRight()));
        if (hasInsertableLayers) {
            this.execute_step3_del_yesno();
        } else {
            this.mergeFeatures(false);
            this.execute_step1_sel_master();
        }
    };
    private final ActionListener listenSecondBack = e -> this.execute_step1_sel_master();
    private final ActionListener listenThirdYes = e -> {
        this.mergeFeatures(true);
        this.execute_step1_sel_master();
    };
    private final ActionListener listenThirdNo = e -> {
        this.mergeFeatures(false);
        this.execute_step1_sel_master();
    };

    private boolean canLayerDelete(Layer layer) {
        return layer.isEditable() && layer.getFMD().isDeleteAllowed();
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.experttools.MergeFeaturesPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"geometry_union.svg");
    }

    @Override
    public boolean execute(PlugInContext _context) throws Exception {
        this.execute_step1_sel_master();
        return true;
    }

    private void execute_step1_sel_master() {
        EditingPanel.instanceOf().activateDefaultCT();
        SwingUtilities.invokeLater(() -> {
            DescriptionPanel.instanceOf().resetPanel();
            DescriptionPanel.instanceOf().setAssistentName(this.getName());
            DescriptionPanel.instanceOf().setDescription(this.strFirstDesc);
            DescriptionPanel.instanceOf().setLeftButton(this.strCancel, this.listenFirstCancel);
            DescriptionPanel.instanceOf().setRightButton(this.strContinue, this.listenFirstOK);
            EditingPanel.instanceOf().activatePanel(DescriptionPanel.instanceOf());
        });
    }

    private void execute_step2_sel_merges() {
        EditingPanel.instanceOf().activateDefaultCT();
        SwingUtilities.invokeLater(() -> {
            DescriptionPanel.instanceOf().resetPanel();
            DescriptionPanel.instanceOf().setAssistentName(this.getName());
            DescriptionPanel.instanceOf().setDescription(this.strSecondDesc);
            DescriptionPanel.instanceOf().setLeftButton(this.strBack, this.listenSecondBack);
            DescriptionPanel.instanceOf().setRightButton(this.strContinue, this.listenSecondOK);
            EditingPanel.instanceOf().activatePanel(DescriptionPanel.instanceOf());
        });
    }

    private void execute_step3_del_yesno() {
        SwingUtilities.invokeLater(() -> {
            DescriptionPanel.instanceOf().resetPanel();
            DescriptionPanel.instanceOf().setAssistentName(this.getName());
            DescriptionPanel.instanceOf().setDescription(this.strThirdDesc);
            DescriptionPanel.instanceOf().setLeftButton(this.strNo, this.listenThirdNo);
            DescriptionPanel.instanceOf().setRightButton(this.strYes, this.listenThirdYes);
            EditingPanel.instanceOf().activatePanel(DescriptionPanel.instanceOf());
        });
    }

    private void mergeFeatures(boolean deleteSource) {
        this.mergeGeometry().ifPresent(mergeTransaction -> {
            ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
            transactions.add((EditTransaction)mergeTransaction);
            if (deleteSource) {
                transactions.addAll(this.deleteSourceFeatures());
            }
            EditTransaction.commit(transactions);
            this.selectMergedFeature();
        });
    }

    private Optional<EditTransaction> mergeGeometry() {
        Geometry mergedGeometry = this.merges.values().stream().flatMap(set -> set.stream()).map(f -> ((Geometry)f.getDefaultGeometry()).copy()).reduce(((Geometry)this.targetFeature.getDefaultGeometry()).copy(), JTSSupport::mergeGeom);
        if (!mergedGeometry.isValid()) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("common.geometry-invalid"), (String)I18N.get("common.error"));
            return Optional.empty();
        }
        if (!this.targetLayer.getFMD().isGeometryAllowed(mergedGeometry.getClass())) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("common.geometry-not-allowed"), (String)I18N.get("common.error"));
            return Optional.empty();
        }
        ArrayList<SimpleFeature> lstFirstFeat = new ArrayList<SimpleFeature>();
        lstFirstFeat.add(this.targetFeature);
        EditTransaction transaction = new EditTransaction(lstFirstFeat, this.getName(), this.targetLayer, false, false, WorkbenchContext.getInstance().getLayerViewPanel());
        transaction.setGeometry(this.targetFeature, mergedGeometry);
        return Optional.of(transaction);
    }

    private List<EditTransaction> deleteSourceFeatures() {
        return this.merges.keySet().stream().filter(this::canLayerDelete).flatMap(layer -> {
            Set<SimpleFeature> features = this.merges.get(layer);
            EditTransaction deleteTransaction = this.createDeleteTransaction((Collection<SimpleFeature>)features, (Layer)layer);
            return features.stream().map(f -> Pair.of((Object)deleteTransaction, (Object)f));
        }).map(transactionAndFeature -> {
            EditTransaction transaction = (EditTransaction)transactionAndFeature.getLeft();
            SimpleFeature feature = (SimpleFeature)transactionAndFeature.getRight();
            Geometry geom2Del = transaction.getGeometry(feature);
            transaction.setGeometry(feature, this.geoEdit.remove(geom2Del, geom2Del));
            return transaction;
        }).collect(Collectors.toUnmodifiableList());
    }

    private EditTransaction createDeleteTransaction(Collection<SimpleFeature> features, Layer layer) {
        return new EditTransaction(features, this.getName(), layer, false, true, WorkbenchContext.getInstance().getLayerViewPanel());
    }

    private void selectMergedFeature() {
        SelectionManager selectionManager = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager();
        selectionManager.clear();
        selectionManager.getFeatureSelection().selectItems(this.targetLayer, this.targetFeature);
    }

    @Override
    public EnableCheck createEnableCheck() {
        return EditingPanel.instanceOf().getLayerEnableCheck();
    }
}

