/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.experttools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class CloseLinestringPlugIn
extends AbstractPlugIn {
    private static final GeometryFactory gfac = new GeometryFactory();

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.experttools.CloseLinestringPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"geometry_line_to_polygon.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer ly = EditingPanel.instanceOf().getCurrentLayer();
        ArrayList<UndoableCommand> lstCommands = new ArrayList<UndoableCommand>();
        ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
        if (ly == null) {
            throw new Exception("No editable layer selected");
        }
        if (!ly.getFMD().isInsertAllowed()) {
            throw new Exception("Layer is not insertable");
        }
        if (!ly.getFMD().isDeleteAllowed()) {
            throw new Exception("Layer is not deletable");
        }
        Collection<Layer> colSel = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        Iterator<Layer> iLy = colSel.iterator();
        boolean bolGeomIgnored = false;
        while (iLy.hasNext()) {
            Layer lySel = iLy.next();
            Iterator<SimpleFeature> iSel = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lySel).iterator();
            ArrayList<SimpleFeature> lstNewFeatures = new ArrayList<SimpleFeature>();
            ArrayList<SimpleFeature> lstOldFeatures = new ArrayList<SimpleFeature>();
            while (iSel.hasNext()) {
                SimpleFeature feat = iSel.next();
                Geometry geom = (Geometry)feat.getDefaultGeometry();
                if ((geom = this.toPolygon(geom)) == null || !geom.isValid() || geom.isEmpty()) {
                    bolGeomIgnored = true;
                    continue;
                }
                boolean bolGeomFound = true;
                if (ly.getFMD().getRestrictGeomType()) {
                    Class<?>[] arrGeomClasses;
                    bolGeomFound = false;
                    for (Class<?> arrGeomClasse : arrGeomClasses = ly.getFMD().getGeomTypes()) {
                        if (!arrGeomClasse.isInstance(geom)) continue;
                        bolGeomFound = true;
                    }
                    if (!bolGeomFound) {
                        bolGeomIgnored = true;
                    }
                }
                if (!bolGeomFound) continue;
                SimpleFeature newFeat = FeatureUtil.createFeature((SimpleFeatureType)ly.getFeatureType(), (Geometry)geom);
                if (!(ly instanceof AbstractCadLayer) && !(lySel instanceof AbstractCadLayer)) {
                    FeatureUtil.copyFeatureData((SimpleFeature)feat, (SimpleFeature)newFeat);
                    newFeat.setDefaultGeometry((Object)geom);
                }
                lstNewFeatures.add(newFeat);
                lstOldFeatures.add(feat);
                lstFeatures.add(newFeat);
            }
            lstCommands.add(this.createAddDeleteCommand(ly, lySel, lstOldFeatures, lstNewFeatures));
        }
        context.getLayerViewPanel().getSelectionManager().clear();
        context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(ly, lstFeatures);
        CloseLinestringPlugIn.execute(lstCommands, (LayerManagerProxy)context, false);
        SaveLayerFeatureChangesPlugIn.commitLayer(ly, true, false, false);
        if (bolGeomIgnored) {
            GUISupport.msgbox((Component)context.getWorkbenchFrame(), (String)I18N.get("ui.cursortool.editing.experttools.CloseLinestringPlugIn.geometries-ignored"), (String)I18N.get("common.message"));
        }
        return true;
    }

    private Geometry toPolygon(Geometry geom) throws Exception {
        if (geom instanceof LineString) {
            LineString ls = (LineString)geom;
            Coordinate[] arrCoord = ls.getCoordinates();
            ArrayList<Coordinate> lstCoord = new ArrayList<Coordinate>(Arrays.asList(arrCoord));
            lstCoord.add(new Coordinate(arrCoord[0].x, arrCoord[0].y, arrCoord[0].z));
            LinearRing lr = gfac.createLinearRing(lstCoord.toArray(new Coordinate[0]));
            return gfac.createPolygon(lr, new LinearRing[0]);
        }
        if (geom instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)geom;
            return this.toPolygon(mls.getGeometryN(0));
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollection gcol = (GeometryCollection)geom;
            return this.toPolygon(gcol.getGeometryN(0));
        }
        throw new Exception("Selected geometry cannot be convertet into a polygon.");
    }

    private UndoableCommand createAddDeleteCommand(final Layer ly, final Layer lySel, final ArrayList<SimpleFeature> lstOldFeatures, final ArrayList<SimpleFeature> lstNewFeatures) {
        if (ly instanceof RedlineLayer && lySel instanceof RedlineLayer) {
            Iterator<SimpleFeature> iFeat = lstNewFeatures.iterator();
            int counter = 0;
            while (iFeat.hasNext()) {
                SimpleFeature newFeat = iFeat.next();
                SimpleFeature feat = lstOldFeatures.get(counter);
                newFeat.setAttribute("text", feat.getAttribute("text"));
                newFeat.setAttribute("textori", feat.getAttribute("textori"));
                newFeat.setAttribute("symori", feat.getAttribute("symori"));
                newFeat.setAttribute("isdim", feat.getAttribute("isdim"));
                ++counter;
            }
        }
        UndoableCommand command = new UndoableCommand(this, "AddDeleteFromRedline"){

            @Override
            public void execute() {
                if (lySel instanceof RedlineLayer) {
                    lySel.editFeature(lstOldFeatures, 3);
                }
                ly.editFeature(lstNewFeatures, 1);
            }

            @Override
            public void unexecute() {
                if (lySel instanceof RedlineLayer) {
                    RedlineLayer rly = (RedlineLayer)lySel;
                    try {
                        rly.setUseDefaultFeature(false);
                        rly.editFeature(lstOldFeatures, 1);
                    }
                    finally {
                        rly.setUseDefaultFeature(true);
                    }
                }
                ly.editFeature(lstNewFeatures, 3);
            }
        };
        return command;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return component -> {
            String strCheck = EditingPanel.instanceOf().getAllLayerEnableCheck().check(component);
            if (strCheck != null) {
                return strCheck;
            }
            strCheck = EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{Polygon.class}).check(component);
            if (strCheck != null) {
                return strCheck;
            }
            Collection<Geometry> colSel = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getSelectedItems();
            if (colSel.size() >= 1) {
                strCheck = null;
                for (Geometry geom : colSel) {
                    if (geom != null) {
                        if (geom instanceof LineString) continue;
                        if (geom instanceof MultiLineString) {
                            mls = (MultiLineString)geom;
                            if (mls.getNumGeometries() == 1) continue;
                            strCheck = "One or more linestrings have to be selected";
                        } else if (geom instanceof GeometryCollection) {
                            mls = (GeometryCollection)geom;
                            if (mls.getNumGeometries() == 1 && (geom = mls.getGeometryN(0)) instanceof LineString) continue;
                            strCheck = "One or more linestrings have to be selected";
                        } else {
                            strCheck = "One or more linestrings have to be selected";
                        }
                    } else {
                        strCheck = "One or more linestrings have to be selected";
                    }
                    break;
                }
            } else {
                strCheck = "One or more linestrings have to be selected";
            }
            return strCheck;
        };
    }
}

