/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.dim;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class StatDimTool
extends MultiClickTool {
    private final DecimalFormat df = new DecimalFormat();
    private final int intDefaultDigits = 2;
    private static final String strDist = I18N.get("ui.cursortool.MeasureTool.dist");
    private final DecimalFormat dfLength = new DecimalFormat();
    private final String strUnit = "";
    private final KeyListener klstEnter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10) {
                try {
                    StatDimTool.this.finishGesture();
                }
                catch (Exception e1) {
                    WorkbenchContext.getFrame().handleThrowable(e1);
                }
            }
        }
    };

    protected StatDimTool() {
        this.setDigits(2);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new StatDimTool(), true);
    }

    @Override
    public Cursor createCursor() {
        return StatDimTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_dimension.svg").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"dimension_positioning.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.dim.StatDimTool.name");
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        List<Coordinate> lstCoord = this.getCoordinates();
        GeneralPath path = new GeneralPath();
        if (lstCoord.isEmpty()) {
            this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
            return path;
        }
        Point2D firstPoint = this.getPanel().getViewport().toViewPoint(lstCoord.get(0));
        path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
        for (int i = 1; i < lstCoord.size(); ++i) {
            Coordinate previousCoordinate = lstCoord.get(i - 1);
            Coordinate nextCoordinate = lstCoord.get(i);
            Coordinate coord1 = previousCoordinate;
            Coordinate coord2 = nextCoordinate;
            Point2D point = this.getPanel().getViewport().toViewPoint(coord1);
            path.lineTo((float)point.getX(), (float)point.getY());
            point = this.getPanel().getViewport().toViewPoint(coord2);
            path.lineTo((float)point.getX(), (float)point.getY());
            point = this.getPanel().getViewport().toViewPoint(nextCoordinate);
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        Coordinate previousCoordinate = lstCoord.get(lstCoord.size() - 1);
        Coordinate nextCoordinate = this.getTentativeCoordinate();
        Coordinate coord1 = previousCoordinate;
        Coordinate coord2 = nextCoordinate;
        Point2D point = this.getPanel().getViewport().toViewPoint(coord1);
        path.lineTo((float)point.getX(), (float)point.getY());
        point = this.getPanel().getViewport().toViewPoint(coord2);
        path.lineTo((float)point.getX(), (float)point.getY());
        point = this.getPanel().getViewport().toViewPoint(nextCoordinate);
        path.lineTo((float)point.getX(), (float)point.getY());
        return path;
    }

    private void setDigits(int numDigits) {
        this.df.setMaximumFractionDigits(numDigits);
        this.df.setMinimumFractionDigits(numDigits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void gestureFinished() throws Exception {
        List<Coordinate> lstCoord = this.getCoordinates();
        if (lstCoord.isEmpty()) {
            return;
        }
        WorkbenchContext.getTask().getLayerManager().setFiringEvents(false);
        ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
        Layer ly = EditingPanel.instanceOf().getCurrentLayer();
        if (ly == null) {
            return;
        }
        if (!(ly instanceof DimLayer) && !(ly instanceof AbstractCadLayer)) {
            return;
        }
        try {
            if (ly instanceof AbstractCadLayer) {
                ((AbstractCadLayer)ly).setDrawDimension(true);
            }
            ArrayList<Coordinate> lstNewCoord = new ArrayList<Coordinate>();
            lstNewCoord.add(lstCoord.get(0));
            for (int i = 1; i < lstCoord.size(); ++i) {
                Coordinate nextCoordinate;
                Coordinate previousCoordinate = lstCoord.get(i - 1);
                double dblDist = ConstSupport.getLength((Coordinate)previousCoordinate, (Coordinate)(nextCoordinate = lstCoord.get(i)));
                if (dblDist == 0.0) continue;
                lstNewCoord.add(nextCoordinate);
            }
            lstCoord = lstNewCoord;
            SimpleFeature feature = FeatureUtil.createFeature((SimpleFeatureType)ly.getFeatureType(), (Geometry)this.getMultiPoint(lstCoord));
            FeatureUtil.setAttribute((SimpleFeature)feature, (String)"MTYPE", (Object)3);
            lstFeatures.add(feature);
            this.execute(FeatureDrawingUtil.createAddCommand(feature, this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
            SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
        }
        finally {
            WorkbenchContext.getTask().getLayerManager().setFiringEvents(true);
            if (ly instanceof AbstractCadLayer) {
                ((AbstractCadLayer)ly).setDrawDimension(false);
            }
        }
        WorkbenchContext.getTask().getLayerManager().fireFeaturesChanged(lstFeatures, FeatureEventType.ADDED, ly);
    }

    protected MultiPoint getMultiPoint(Collection<Coordinate> colCoord) throws NoninvertibleTransformException {
        Coordinate[] arrCoord = colCoord.toArray(new Coordinate[colCoord.size()]);
        return new GeometryFactory().createMultiPoint(arrCoord);
    }

    @Override
    public boolean useTooltip() {
        return true;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        try {
            ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
            currentCoordinates.add(this.getTentativeCoordinate());
            return this.getTooltipHtml(currentCoordinates);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getTooltipHtml(List<Coordinate> coordinates) throws NoninvertibleTransformException {
        ArrayList<Coordinate> lstLastCoords = new ArrayList<Coordinate>();
        lstLastCoords.add(coordinates.get(coordinates.size() - 2));
        lstLastCoords.add(coordinates.get(coordinates.size() - 1));
        return this.getTooltipHtml(ConstSupport.getLength(coordinates), ConstSupport.getLength(lstLastCoords));
    }

    private String getTooltipHtml(double distance, double lastDistance) {
        return "<html>" + strDist + ": <b color='blue'>" + this.dfLength.format(distance) + " / " + this.dfLength.format(lastDistance) + "</b></html>";
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setLeftButton(I18N.get("common.back"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatDimTool.this.back();
            }
        });
        return valPanel;
    }

    @Override
    public KeyListener getKeyListener() {
        return this.klstEnter;
    }
}

