/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.dim;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.AbstractConstTool;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;

public class SingleDimTool
extends AbstractConstTool {
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private static final String strDist = I18N.get("ui.cursortool.MeasureTool.dist");
    private final DecimalFormat dfLength = new DecimalFormat();
    private final String strUnit = "";

    protected SingleDimTool() {
        super(3);
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        DrawingUnit unit = layerViewPanel.getLayerManager().getTask().getDrawingUnit();
        double dblUnitInMeter = unit.getUnitInMeter();
        double dblUnitInCentimeter = dblUnitInMeter * 100.0;
        int intDecPlaces = (int)Math.log10(dblUnitInCentimeter);
        this.dfLength.setGroupingUsed(false);
        this.dfLength.setMaximumFractionDigits(intDecPlaces);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        SingleDimTool csTool = new SingleDimTool();
        return csTool;
    }

    @Override
    public Cursor createCursor() {
        return SingleDimTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_dimension.svg").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"dimension_range.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.dim.SingleDimTool.name");
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        Coordinate coordStart;
        Coordinate coord;
        List<Coordinate> lstCoord = this.getCoordinates();
        GeneralPath path = new GeneralPath();
        int counter = lstCoord.size();
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        if (counter == 1) {
            coord = this.getTentativeCoordinate();
            coordStart = lstCoord.get(0);
            Point2D point = this.getPanel().getViewport().toViewPoint(coordStart);
            path.moveTo((float)point.getX(), (float)point.getY());
            point = this.getPanel().getViewport().toViewPoint(coord);
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        if (counter == 2) {
            coord = this.getTentativeCoordinate();
            coordStart = lstCoord.get(0);
            Coordinate coordEnd = lstCoord.get(1);
            Coordinate coordTemp = ConstSupport.getOrthoSection((Coordinate)coordStart, (Coordinate)coordEnd, (Coordinate)coord);
            double dist = ConstSupport.getLength((Coordinate)coordTemp, (Coordinate)coord);
            Coordinate coord1 = coordStart;
            Coordinate coord2 = coordEnd;
            if (dist > 0.0) {
                double t = ConstSupport.getOrientation((Coordinate)coordTemp, (Coordinate)coord, (int)2);
                coord1 = ConstSupport.getPolarCoord((Coordinate)coordStart, (double)dist, (double)t);
                coord2 = ConstSupport.getPolarCoord((Coordinate)coordEnd, (double)dist, (double)t);
            }
            Point2D point = this.getPanel().getViewport().toViewPoint(coordStart);
            path.moveTo((float)point.getX(), (float)point.getY());
            point = this.getPanel().getViewport().toViewPoint(coord1);
            path.lineTo((float)point.getX(), (float)point.getY());
            point = this.getPanel().getViewport().toViewPoint(coord2);
            path.lineTo((float)point.getX(), (float)point.getY());
            point = this.getPanel().getViewport().toViewPoint(coordEnd);
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        return path;
    }

    @Override
    public JPanel getAssistentPanel() {
        return DescriptionPanel.getBackPanel(this);
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.getCoordinates().size() < 3) {
            return;
        }
        try {
            if (FeatureDrawingUtil.layer() instanceof AbstractCadLayer) {
                ((AbstractCadLayer)FeatureDrawingUtil.layer()).setDrawDimension(true);
            }
            this.execute(FeatureDrawingUtil.createAddCommand((Geometry)this.getMultiPoint(), this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
            SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
        }
        finally {
            if (FeatureDrawingUtil.layer() instanceof AbstractCadLayer) {
                ((AbstractCadLayer)FeatureDrawingUtil.layer()).setDrawDimension(false);
            }
        }
    }

    @Override
    public boolean useTooltip() {
        return true;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        try {
            ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
            currentCoordinates.add(this.getTentativeCoordinate());
            if (currentCoordinates.size() < 2) {
                return null;
            }
            return this.getTooltipHtml(currentCoordinates);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getTooltipHtml(List<Coordinate> coordinates) throws NoninvertibleTransformException {
        ArrayList<Coordinate> lstCoords = new ArrayList<Coordinate>();
        lstCoords.add(coordinates.get(0));
        lstCoords.add(coordinates.get(1));
        double distance = ConstSupport.getLength(lstCoords);
        Task task = this.getTaskFrame().getTask();
        if (task.isProjectionReductionActive()) {
            CRSDefinition crsDef = task.getCRSDefinition();
            DrawingUnit unit = task.getDrawingUnit();
            Coordinate coordCenter = CoordUtil.average(lstCoords);
            distance = crsDef.getRealWorldDistance(distance, task.getHeightReduction(), coordCenter, unit);
        }
        return this.getTooltipHtml(distance);
    }

    private String getTooltipHtml(double distance) {
        return "<html>" + strDist + ": <b color='blue'>" + this.dfLength.format(distance) + "</b></html>";
    }

    protected MultiPoint getMultiPoint() throws NoninvertibleTransformException {
        Coordinate[] arrCoord;
        List<Coordinate> lstCoord = this.getCoordinates();
        if (lstCoord.size() != 3) {
            throw new NoninvertibleTransformException("There must be 3 coordinates");
        }
        arrCoord = new Coordinate[]{lstCoord.get(0), lstCoord.get(1), lstCoord.get(2), new Coordinate(arrCoord[0])};
        return new GeometryFactory().createMultiPoint(arrCoord);
    }
}

