/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.dim;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditAttTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.dim.DimTextEnableCheck;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.dim.EditDimTextPanel;
import com.vividsolutions.jump.workbench.ui.plugin.layer.dim.DimFeatureAtts;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.ObjectUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class SetDimTextPlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.dim.SetDimTextPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"dimension_text.svg");
    }

    private String[] splitMText(String mText) {
        String[] arrMText = (mText = ObjectUtils.toString((Object)mText)).split("\\|");
        if (arrMText.length < 2) {
            String[] arrMTextTemp = new String[2];
            System.arraycopy(arrMText, 0, arrMTextTemp, 0, arrMText.length);
            arrMText = arrMTextTemp;
        }
        return arrMText;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Collection<Layer> colSel = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        Iterator<Layer> iLy = colSel.iterator();
        ArrayList<EditAttTransaction> lstTrans = new ArrayList<EditAttTransaction>();
        while (iLy.hasNext()) {
            Layer ly = iLy.next();
            if (!(ly instanceof DimLayer) && !(ly instanceof AbstractCadLayer)) continue;
            Collection<SimpleFeature> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
            if (colSelLy.size() != 1) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.dim.SetDimTextPlugIn.only-one-feature-allowed"), (String)I18N.get("common.error"));
                return true;
            }
            SimpleFeature feat = colSelLy.iterator().next();
            Number numMType = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)DimFeatureAtts.MTYPE.getName());
            if (numMType == null) {
                numMType = 0;
            }
            if (numMType.intValue() == 3) {
                GUISupport.msgbox((Component)context.getWorkbenchFrame(), (String)I18N.get("ui.cursortool.editing.dim.no-chain-dim"), (String)I18N.get("common.error"));
                return true;
            }
            AttributeDescriptor mtextAttDesc = FeatureUtil.getAttributeDescriptor((SimpleFeatureType)ly.getFeatureType(), (String)DimFeatureAtts.MTEXT.getName());
            if (mtextAttDesc == null) {
                throw new Exception("Attribute MTEXT not found in FeatureType");
            }
            Object mText = (String)FeatureUtil.getAttribute((SimpleFeature)feat, (String)DimFeatureAtts.MTEXT.getName());
            String newText = EditDimTextPanel.instanceOf().getText();
            if (numMType.intValue() == 0) {
                mText = newText;
            } else if (numMType.intValue() == 2) {
                arrMText = this.splitMText((String)mText);
                if (EditDimTextPanel.instanceOf().isOrthoAbscissa()) {
                    arrMText[0] = newText;
                } else {
                    arrMText[1] = newText;
                }
                mText = ObjectUtils.toString((Object)arrMText[0]) + "|" + ObjectUtils.toString((Object)arrMText[1]);
            } else if (numMType.intValue() == 1) {
                arrMText = this.splitMText((String)mText);
                if (EditDimTextPanel.instanceOf().isOrthoStart()) {
                    arrMText[1] = newText;
                } else {
                    arrMText[0] = newText;
                }
                mText = ObjectUtils.toString((Object)arrMText[0]) + "|" + ObjectUtils.toString((Object)arrMText[1]);
            }
            EditAttTransaction trans = this.createTransaction(ly);
            trans.addAttribute(mtextAttDesc.getLocalName(), mText);
            lstTrans.add(trans);
        }
        EditAttTransaction.commit(lstTrans);
        return true;
    }

    private EditAttTransaction createTransaction(Layer layer) {
        return EditAttTransaction.createTransactionOnSelection(WorkbenchContext.getInstance().getLayerViewPanel(), WorkbenchContext.getInstance().getLayerViewPanel().getContext(), this.getName(), layer);
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new DimTextEnableCheck();
    }
}

