/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.dim;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditAttTransaction;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.dim.DimTextEnableCheck;
import com.vividsolutions.jump.workbench.ui.plugin.layer.dim.DimFeatureAtts;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.construction.ConstSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ResetDimPlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.dim.ResetDimPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"dimension_reset.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Collection<Layer> colSel = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        Iterator<Layer> iLy = colSel.iterator();
        ArrayList<EditTransaction> lstTrans = new ArrayList<EditTransaction>();
        ArrayList<EditAttTransaction> lstTransAtt = new ArrayList<EditAttTransaction>();
        while (iLy.hasNext()) {
            Layer lySel = iLy.next();
            if (!(lySel instanceof DimLayer) && !(lySel instanceof AbstractCadLayer)) continue;
            for (SimpleFeature feat : WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lySel)) {
                Number numMType = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)DimFeatureAtts.MTYPE.getName());
                if (numMType == null) {
                    numMType = 0;
                }
                if (numMType.intValue() == 3) continue;
                ArrayList<SimpleFeature> lstFeature = new ArrayList<SimpleFeature>();
                lstFeature.add(feat);
                Geometry geom = (Geometry)feat.getDefaultGeometry();
                if (!(geom instanceof MultiPoint)) continue;
                Coordinate[] arrCoord = geom.getCoordinates();
                EditTransaction transaction = new EditTransaction(lstFeature, this.getName(), lySel, true, false, WorkbenchContext.getInstance().getLayerViewPanel());
                transaction.setGeometry(0, (Geometry)this.getMultiPoint(arrCoord, numMType.intValue()));
                lstTrans.add(transaction);
                AttributeDescriptor mtextAttDesc = FeatureUtil.getAttributeDescriptor((SimpleFeatureType)lySel.getFeatureType(), (String)DimFeatureAtts.MTEXT.getName());
                if (mtextAttDesc == null) {
                    throw new Exception("Attribute MTEXT not found in FeatureType");
                }
                EditAttTransaction transAtt = this.createTransaction(lySel);
                if (numMType.intValue() == 2 || numMType.intValue() == 1) {
                    transAtt.addAttribute(mtextAttDesc.getLocalName(), "|");
                } else {
                    transAtt.addAttribute(mtextAttDesc.getLocalName(), "");
                }
                lstTransAtt.add(transAtt);
            }
        }
        EditTransaction.commit(lstTrans);
        EditAttTransaction.commit(lstTransAtt);
        return true;
    }

    protected MultiPoint getMultiPoint(Coordinate[] arrCoord, int mType) throws Exception {
        if (mType == 0) {
            if (arrCoord.length != 4) {
                throw new Exception("There must be 4 coordinates in MultiPoint");
            }
            Coordinate[] arrNewCoord = new Coordinate[4];
            arrNewCoord[0] = arrCoord[0];
            arrNewCoord[1] = arrCoord[1];
            arrNewCoord[2] = arrCoord[2];
            if (arrCoord[2].equals((Object)arrCoord[0]) || arrCoord[2].equals((Object)arrCoord[1])) {
                double t = ConstSupport.getOrientation((Coordinate)arrCoord[0], (Coordinate)arrCoord[1], (int)2);
                double dist = ConstSupport.getLength((Coordinate)arrCoord[0], (Coordinate)arrCoord[1]);
                arrNewCoord[2] = ConstSupport.getPolarCoord((Coordinate)arrCoord[0], (double)(dist / 2.0), (double)t);
            }
            arrNewCoord[3] = new Coordinate(arrCoord[0]);
            return new GeometryFactory().createMultiPoint(arrNewCoord);
        }
        if (mType == 2) {
            if (arrCoord.length != 5) {
                throw new Exception("There must be 5 coordinates in MultiPoint");
            }
            Coordinate[] arrNewCoord = new Coordinate[]{arrCoord[0], arrCoord[1], (Coordinate)arrCoord[1].clone(), arrCoord[3], (Coordinate)arrCoord[3].clone()};
            return new GeometryFactory().createMultiPoint(arrNewCoord);
        }
        if (mType == 1) {
            if (arrCoord.length != 6) {
                throw new Exception("There must be 6 coordinates in MultiPoint");
            }
            Coordinate[] arrNewCoord = new Coordinate[]{arrCoord[0], arrCoord[1], (Coordinate)arrCoord[0].clone(), arrCoord[3], arrCoord[4], (Coordinate)arrCoord[3].clone()};
            return new GeometryFactory().createMultiPoint(arrNewCoord);
        }
        throw new Exception("Invalid MTYPE - should never reach here.");
    }

    private EditAttTransaction createTransaction(Layer layer) {
        return EditAttTransaction.createTransactionOnSelection(WorkbenchContext.getInstance().getLayerViewPanel(), WorkbenchContext.getInstance().getLayerViewPanel().getContext(), this.getName(), layer);
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new DimTextEnableCheck();
    }
}

