/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.dim;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.dim.DimTextEnableCheck;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.dim.EditDimTextPanel;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.opengis.feature.simple.SimpleFeature;

public class PosDimTextlTool
extends NClickTool {
    private PosDimTextlTool() {
        super(1);
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new PosDimTextlTool(), false);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"dimension_edit_text.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.dim.PosDimTextTool.name");
    }

    @Override
    protected void gestureFinished() throws Exception {
        Collection<Layer> colSel = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        for (Layer lySel : colSel) {
            if (!(lySel instanceof DimLayer) && !(lySel instanceof AbstractCadLayer)) continue;
            Collection<SimpleFeature> selectedFeatures = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lySel);
            if (selectedFeatures.size() != 1) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.dim.PosDimTextTool.only-one-feature-allowed"), (String)I18N.get("common.error"));
                return;
            }
            SimpleFeature feat = selectedFeatures.iterator().next();
            Number numMType = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)"MTYPE");
            if (numMType == null) {
                numMType = 0;
            }
            if (numMType.intValue() == 3) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.dim.no-chain-dim"), (String)I18N.get("common.error"));
                return;
            }
            ArrayList<SimpleFeature> lstFeature = new ArrayList<SimpleFeature>();
            lstFeature.add(feat);
            Geometry geom = (Geometry)feat.getDefaultGeometry();
            if (geom instanceof MultiPoint) {
                Coordinate[] arrCoord = geom.getCoordinates();
                EditTransaction transaction = new EditTransaction(lstFeature, this.getName(), lySel, this.isRollingBackInvalidEdits(), false, this.getPanel());
                transaction.setGeometry(0, (Geometry)this.getMultiPointDim(arrCoord, numMType.intValue()));
                transaction.commit(new EditTransaction.SuccessAction(){

                    @Override
                    public void run() {
                        try {
                            Animations.drawExpandingRing(PosDimTextlTool.this.getPanel().getViewport().toViewPoint(PosDimTextlTool.this.getCoordinates().get(0)), false, Color.green, PosDimTextlTool.this.getPanel(), null);
                        }
                        catch (Throwable t) {
                            PosDimTextlTool.this.getPanel().getContext().warnUser(t.toString());
                        }
                    }
                });
                continue;
            }
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.getMessage("ui.cursortool.editing.dim.PosDimTextTool.invalid-dimension-feature", "Geometry has to be of type MULTIPOINT"), (String)I18N.get("common.error"));
            return;
        }
    }

    protected MultiPoint getMultiPointDim(Coordinate[] arrCoord, int mType) throws NoninvertibleTransformException {
        Coordinate coordTxt = this.getCoordinates().get(0);
        if (mType == 0) {
            if (arrCoord.length != 4) {
                throw new NoninvertibleTransformException("There must be 4 coordinates in MultiPoint");
            }
            Coordinate[] arrNewCoord = new Coordinate[]{arrCoord[0], arrCoord[1], arrCoord[2], coordTxt};
            return new GeometryFactory().createMultiPoint(arrNewCoord);
        }
        if (mType == 1) {
            if (arrCoord.length != 6) {
                throw new NoninvertibleTransformException("There must be 4 coordinates in MultiPoint");
            }
            Coordinate[] arrNewCoord = new Coordinate[6];
            arrNewCoord[0] = arrCoord[0];
            arrNewCoord[1] = arrCoord[1];
            arrNewCoord[3] = arrCoord[3];
            arrNewCoord[4] = arrCoord[4];
            if (EditDimTextPanel.instanceOf().isOrthoStart()) {
                arrNewCoord[2] = coordTxt;
                arrNewCoord[5] = arrCoord[5];
            } else {
                arrNewCoord[2] = arrCoord[2];
                arrNewCoord[5] = coordTxt;
            }
            return new GeometryFactory().createMultiPoint(arrNewCoord);
        }
        if (mType == 2) {
            if (arrCoord.length != 5) {
                throw new NoninvertibleTransformException("There must be 4 coordinates in MultiPoint");
            }
            Coordinate[] arrNewCoord = new Coordinate[5];
            arrNewCoord[0] = arrCoord[0];
            arrNewCoord[1] = arrCoord[1];
            arrNewCoord[3] = arrCoord[3];
            if (EditDimTextPanel.instanceOf().isOrthoAbscissa()) {
                arrNewCoord[2] = arrCoord[2];
                arrNewCoord[4] = coordTxt;
            } else {
                arrNewCoord[2] = coordTxt;
                arrNewCoord[4] = arrCoord[4];
            }
            return new GeometryFactory().createMultiPoint(arrNewCoord);
        }
        throw new NoninvertibleTransformException("Invalid MTYPE - should never reach here.");
    }

    public static EnableCheck createEnableCheck() {
        return new DimTextEnableCheck();
    }

    @Override
    public JPanel getAssistentPanel() {
        return EditDimTextPanel.instanceOf();
    }
}

