/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.dim;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.dim.OrthoDimAbscissaTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.dim.OrthoDimOrdinateTool;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;

public class OrthoDimPlugIn
extends AbstractPlugIn {
    private final String strDesc = "<html>Neue Ma\u00dflinie zeichnen oder vorhandene Ma\u00dflinie verwenden.</html>";
    private final String strNew = "neue Ma\u00dflinie";
    private final String strAdd = "vorhandene Ma\u00dflinie";
    private final String strContinue = I18N.get("common.continue");
    private final String strCancel = I18N.get("common.cancel");
    private final String strBack = I18N.get("common.back");
    private final GeometryFactory gfac = new GeometryFactory();
    private PlugInContext context = null;

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"dimension_orthogonal.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.dim.OrthoDimTool.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public boolean execute(PlugInContext _context) throws Exception {
        this.context = _context;
        this.execute_step1();
        return true;
    }

    private void execute_step1() {
        SimpleFeature feat;
        Object objMType;
        Collection<SimpleFeature> colFeat;
        Layer dimLy;
        SelectionManager selMngr = this.context.getLayerViewPanel().getSelectionManager();
        Collection<Layer> colLy = selMngr.getLayersWithSelectedItems();
        if (colLy != null && colLy.size() == 1 && ((dimLy = colLy.iterator().next()) instanceof DimLayer || dimLy instanceof RedlineLayer) && (colFeat = selMngr.getFeaturesWithSelectedItems(dimLy)).size() == 1 && (objMType = FeatureUtil.getAttribute((SimpleFeature)(feat = colFeat.iterator().next()), (String)"MTYPE")) != null && objMType instanceof Number && ((Number)objMType).intValue() == 1) {
            WorkbenchContext.getInstance().getLayerViewPanel().setCurrentCursorTool(new QuasimodeTool(OrthoDimAbscissaTool.create(feat)));
            return;
        }
        this.context.getLayerViewPanel().setCurrentCursorTool(new QuasimodeTool(OrthoDimOrdinateTool.create()));
    }

    @Override
    public EnableCheck createEnableCheck() {
        return EditingPanel.instanceOf().getDimLayerEnableCheck();
    }
}

