/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.dim;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.AbstractConstTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.dim.OrthoDimAbscissaTool;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class OrthoDimOrdinateTool
extends AbstractConstTool {
    private static final String TEXT_DISTANCE = I18N.get("ui.cursortool.MeasureTool.dist");
    private static final String TEXT_UNIT = "";
    private final DecimalFormat dfLength = new DecimalFormat();

    protected OrthoDimOrdinateTool() {
        super(2);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public static CursorTool create() {
        return new OrthoDimOrdinateTool();
    }

    @Override
    public Cursor createCursor() {
        return OrthoDimOrdinateTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_dimension.svg").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"dimension_orthogonal.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.dim.OrthoDimTool.name");
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        List<Coordinate> lstCoord = this.getCoordinates();
        GeneralPath path = new GeneralPath();
        int counter = lstCoord.size();
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        if (counter == 1) {
            Coordinate coord = this.getTentativeCoordinate();
            Coordinate coordStart = lstCoord.get(0);
            Point2D point = this.getPanel().getViewport().toViewPoint(coordStart);
            path.moveTo((float)point.getX(), (float)point.getY());
            point = this.getPanel().getViewport().toViewPoint(coord);
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        return path;
    }

    @Override
    public JPanel getAssistentPanel() {
        return DescriptionPanel.getBackPanel(I18N.get("ui.cursortool.editing.dim.OrthoDimTool.ordinate-info-text"), this);
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.getCoordinates().size() < 2) {
            return;
        }
        Layer ly = EditingPanel.instanceOf().getCurrentLayer();
        try {
            if (ly == null) {
                return;
            }
            if (ly instanceof AbstractCadLayer) {
                ((AbstractCadLayer)ly).setDrawDimension(true);
            }
            if (!(ly instanceof DimLayer) && !(ly instanceof AbstractCadLayer)) {
                return;
            }
            SimpleFeature feature = FeatureUtil.createFeature((SimpleFeatureType)ly.getFeatureType(), (Geometry)this.getMultiPoint());
            FeatureUtil.setAttribute((SimpleFeature)feature, (String)"MTYPE", (Object)1);
            FeatureUtil.setAttribute((SimpleFeature)feature, (String)"MTEXT", (Object)"|");
            this.execute(FeatureDrawingUtil.createAddCommand(feature, this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
            WorkbenchContext.getInstance().getLayerViewPanel().setCurrentCursorTool(new QuasimodeTool(OrthoDimAbscissaTool.create(feature)));
        }
        finally {
            if (ly instanceof AbstractCadLayer) {
                ((AbstractCadLayer)ly).setDrawDimension(false);
            }
        }
    }

    @Override
    public boolean useTooltip() {
        return true;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        try {
            ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
            currentCoordinates.add(this.getTentativeCoordinate());
            if (currentCoordinates.size() < 2) {
                return null;
            }
            return this.getTooltipHtml(currentCoordinates);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getTooltipHtml(List<Coordinate> coordinates) {
        ArrayList<Coordinate> lstCoords = new ArrayList<Coordinate>();
        lstCoords.add(coordinates.get(0));
        lstCoords.add(coordinates.get(1));
        return this.getTooltipHtml(ConstSupport.getLength(lstCoords));
    }

    private String getTooltipHtml(double distance) {
        return "<html>" + TEXT_DISTANCE + ": <b color='blue'>" + this.dfLength.format(distance) + "</b></html>";
    }

    protected MultiPoint getMultiPoint() throws NoninvertibleTransformException {
        Coordinate[] arrCoord;
        List<Coordinate> lstCoord = this.getCoordinates();
        if (lstCoord.size() != 2) {
            throw new NoninvertibleTransformException("There must be 2 coordinates");
        }
        arrCoord = new Coordinate[]{lstCoord.get(0), new Coordinate(arrCoord[0]), new Coordinate(arrCoord[0]), lstCoord.get(1), new Coordinate(arrCoord[3]), new Coordinate(arrCoord[3])};
        return new GeometryFactory().createMultiPointFromCoords(arrCoord);
    }
}

