/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.dim;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.AbstractConstTool;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class OrthoDimAbscissaTool
extends AbstractConstTool {
    private static final String ATTRIBUTE_MTYPE = "MTYPE";
    private static final String ATTRIBUTE_MTEXT_ORI = "MTEXT_ORI";
    private static final String TEXT_DISTANCE = I18N.get("ui.cursortool.MeasureTool.dist");
    private static final String TEXT_UNIT = "";
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final DecimalFormat dfLength = new DecimalFormat();
    private SimpleFeature ordinateFeature = null;
    private Layer ordinateLayer = null;
    private boolean updateOrdinate = false;
    private boolean persistRequired = true;

    protected OrthoDimAbscissaTool() {
        super(1);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public static CursorTool create(SimpleFeature ordinateFeature) {
        OrthoDimAbscissaTool csTool = new OrthoDimAbscissaTool();
        if ((!(ordinateFeature.getDefaultGeometry() instanceof MultiPoint) || ((MultiPoint)ordinateFeature.getDefaultGeometry()).getCoordinates().length != 4) && FeatureUtil.getAttribute((SimpleFeature)ordinateFeature, (String)ATTRIBUTE_MTYPE) == null || ((Number)FeatureUtil.getAttribute((SimpleFeature)ordinateFeature, (String)ATTRIBUTE_MTYPE)).intValue() != 1) {
            throw new IllegalArgumentException("Invalid ordinate feature.");
        }
        csTool.ordinateFeature = ordinateFeature;
        csTool.ordinateLayer = FeatureDrawingUtil.layer();
        return csTool;
    }

    @Override
    public Cursor createCursor() {
        return OrthoDimAbscissaTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_dimension.svg").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"dimension_orthogonal.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.dim.OrthoDimTool.name");
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        GeneralPath path = new GeneralPath();
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        Coordinate coord = this.getTentativeCoordinate();
        Coordinate[] arrCoord = this.retrieveOrdinateFeatureCoordinates();
        Coordinate coordStart = ConstSupport.getOrthoSection((Coordinate)arrCoord[0], (Coordinate)arrCoord[3], (Coordinate)coord);
        Point2D point = this.getPanel().getViewport().toViewPoint(coordStart);
        path.moveTo((float)point.getX(), (float)point.getY());
        point = this.getPanel().getViewport().toViewPoint(coord);
        path.lineTo((float)point.getX(), (float)point.getY());
        return path;
    }

    @Override
    public JPanel getAssistentPanel() {
        DescriptionPanel pnlDesc = DescriptionPanel.instanceOf();
        pnlDesc.resetPanel();
        pnlDesc.setDescription(I18N.get("ui.cursortool.editing.dim.OrthoDimTool.abscissa-info-text"));
        return pnlDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void gestureFinished() throws Exception {
        if (this.getCoordinates().isEmpty()) {
            return;
        }
        Layer ly = EditingPanel.instanceOf().getCurrentLayer();
        try {
            if (ly == null) {
                return;
            }
            if (ly instanceof AbstractCadLayer) {
                ((AbstractCadLayer)ly).setDrawDimension(true);
            }
            if (!(ly instanceof DimLayer) && !(ly instanceof AbstractCadLayer)) {
                return;
            }
            MultiPoint mpa = this.getMultiPointAbscissa();
            boolean dimOnLine = false;
            if (mpa.getCoordinates()[1].equals((Object)mpa.getCoordinates()[3])) {
                dimOnLine = true;
            }
            SimpleFeature featureAbscissa = FeatureUtil.createFeature((SimpleFeatureType)ly.getFeatureType(), (Geometry)mpa);
            FeatureUtil.setAttribute((SimpleFeature)featureAbscissa, (String)ATTRIBUTE_MTYPE, (Object)2);
            FeatureUtil.setAttribute((SimpleFeature)featureAbscissa, (String)"MTEXT", (Object)"|");
            Coordinate[] arrCoordOrdLine = this.retrieveOrdinateFeatureCoordinates();
            double tOrdLine = this.checkOrientation(ConstSupport.getOrientation((Coordinate)arrCoordOrdLine[0], (Coordinate)arrCoordOrdLine[3], (int)2));
            double tOrdDim = this.checkOrientation(ConstSupport.getOrientation((Coordinate)mpa.getCoordinates()[0], (Coordinate)mpa.getCoordinates()[1], (int)2));
            boolean negativeOrdinate = false;
            if (Math.abs(tOrdLine - tOrdDim) > 1.5707963267948966) {
                negativeOrdinate = true;
            }
            boolean positiveAbszissa = false;
            if (!dimOnLine) {
                double tAbszDim = this.checkOrientation(ConstSupport.getOrientation((Coordinate)mpa.getCoordinates()[1], (Coordinate)mpa.getCoordinates()[3], (int)2));
                double dAngle = tOrdDim - tAbszDim;
                boolean bl = positiveAbszissa = dAngle > 0.0 && dAngle < Math.PI || dAngle < -Math.PI;
            }
            if (positiveAbszissa) {
                if (negativeOrdinate) {
                    FeatureUtil.setAttribute((SimpleFeature)featureAbscissa, (String)ATTRIBUTE_MTEXT_ORI, (Object)3.0);
                } else {
                    FeatureUtil.setAttribute((SimpleFeature)featureAbscissa, (String)ATTRIBUTE_MTEXT_ORI, (Object)1.0);
                }
            } else if (negativeOrdinate) {
                FeatureUtil.setAttribute((SimpleFeature)featureAbscissa, (String)ATTRIBUTE_MTEXT_ORI, (Object)4.0);
            } else {
                FeatureUtil.setAttribute((SimpleFeature)featureAbscissa, (String)ATTRIBUTE_MTEXT_ORI, (Object)2.0);
            }
            this.execute(FeatureDrawingUtil.createAddCommand(featureAbscissa, this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
            Coordinate dimStartingPoint = mpa.getCoordinates()[1];
            double lengthDim = ConstSupport.getLength((Coordinate)arrCoordOrdLine[1], (Coordinate)arrCoordOrdLine[4]);
            double lengthCoordStart = ConstSupport.getLength((Coordinate)arrCoordOrdLine[1], (Coordinate)dimStartingPoint);
            double lengthCoordEnd = ConstSupport.getLength((Coordinate)dimStartingPoint, (Coordinate)arrCoordOrdLine[4]);
            if (lengthCoordStart > lengthDim && lengthCoordStart > lengthCoordEnd) {
                arrCoordOrdLine[4] = dimStartingPoint;
                this.updateOrdinate = true;
            } else if (lengthCoordEnd > lengthDim && lengthCoordEnd > lengthCoordStart) {
                arrCoordOrdLine[1] = dimStartingPoint;
                this.updateOrdinate = true;
            }
            if (this.updateOrdinate) {
                MultiPoint mpo = this.geometryFactory.createMultiPointFromCoords(arrCoordOrdLine);
                EditTransaction transaction = new EditTransaction(Arrays.asList(this.ordinateFeature), this.getName(), ly, true, false, this.getPanel());
                transaction.setGeometry(0, (Geometry)mpo);
                transaction.commit();
            }
        }
        finally {
            if (ly instanceof AbstractCadLayer) {
                ((AbstractCadLayer)ly).setDrawDimension(false);
            }
        }
    }

    @Override
    public boolean useTooltip() {
        return true;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
        currentCoordinates.add(this.getTentativeCoordinate());
        if (currentCoordinates.size() < 2) {
            return null;
        }
        return this.getTooltipHtml(currentCoordinates);
    }

    private String getTooltipHtml(List<Coordinate> coordinates) {
        ArrayList<Coordinate> lstCoords = new ArrayList<Coordinate>();
        lstCoords.add(coordinates.get(0));
        lstCoords.add(coordinates.get(1));
        return this.getTooltipHtml(ConstSupport.getLength(lstCoords));
    }

    private String getTooltipHtml(double distance) {
        return "<html>" + TEXT_DISTANCE + ": <b color='blue'>" + this.dfLength.format(distance) + "</b></html>";
    }

    private Coordinate[] retrieveOrdinateFeatureCoordinates() {
        return ((MultiPoint)this.ordinateFeature.getDefaultGeometry()).getCoordinates();
    }

    protected MultiPoint getMultiPointAbscissa() throws NoninvertibleTransformException {
        List<Coordinate> lstCoord = this.getCoordinates();
        if (lstCoord.size() != 1) {
            throw new NoninvertibleTransformException("There must be exactly 1 coordinate");
        }
        Coordinate[] arrCoordOrdinate = this.retrieveOrdinateFeatureCoordinates();
        Coordinate coordStart = ConstSupport.getOrthoSection((Coordinate)arrCoordOrdinate[0], (Coordinate)arrCoordOrdinate[3], (Coordinate)lstCoord.get(0));
        Coordinate[] arrCoord = new Coordinate[5];
        arrCoord[0] = new Coordinate(arrCoordOrdinate[0]);
        arrCoord[1] = coordStart;
        arrCoord[2] = new Coordinate(arrCoord[1]);
        arrCoord[3] = lstCoord.get(0);
        double lengthAbszissa = ConstSupport.getLength((Coordinate)arrCoord[1], (Coordinate)arrCoord[3]);
        if (lengthAbszissa < 1.0E-8) {
            arrCoord[3] = new Coordinate(arrCoord[1]);
        }
        arrCoord[4] = new Coordinate(arrCoord[3]);
        return new GeometryFactory().createMultiPointFromCoords(arrCoord);
    }

    private double checkOrientation(double oriInRad) {
        while (oriInRad > Math.PI * 2) {
            oriInRad -= Math.PI * 2;
        }
        while (oriInRad < 0.0) {
            oriInRad += Math.PI * 2;
        }
        return oriInRad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelGesture() {
        OrthoDimAbscissaTool orthoDimAbscissaTool = this;
        synchronized (orthoDimAbscissaTool) {
            if (this.persistRequired && this.ordinateLayer != null) {
                this.persistRequired = false;
                SaveLayerFeatureChangesPlugIn.commitLayer(this.ordinateLayer, true, this.updateOrdinate, false);
                this.updateOrdinate = false;
            }
        }
        super.cancelGesture();
    }
}

