/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.dim;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.construction.ConstSupport;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ObjectDimPlugIn
extends AbstractPlugIn {
    private double dblOffset = 0.0;
    private GetValuePanel valPanel = null;
    private final ActionListener valueChangedListener = e -> {
        try {
            this.dblOffset = (Double)GetValuePanel.instanceOf().getValue();
        }
        catch (Throwable t) {
            WorkbenchContext.getInstance().getLayerViewPanel().getContext().handleThrowable(t);
        }
    };
    private final ActionListener leftButtonListener = e -> {
        try {
            this.dimObjects();
        }
        catch (Throwable t) {
            WorkbenchContext.getInstance().getLayerViewPanel().getContext().handleThrowable(t);
        }
    };

    public ObjectDimPlugIn() {
        this.valPanel = GetValuePanel.instanceOf();
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.dim.ObjectDimPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"dimension_object.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.valPanel.resetPanel();
        this.valPanel.setDescription(I18N.get("ui.cursortool.editing.dim.ObjectDimPlugIn.description"));
        this.valPanel.setValueFormat(0);
        this.valPanel.setValueLabelListener(I18N.get("ui.cursortool.editing.dim.ChainDimTool.offset"), this.valueChangedListener);
        this.valPanel.setValue(this.dblOffset);
        this.valPanel.setLeftButton(I18N.get("ui.cursortool.editing.dim.ObjectDimPlugIn.name"), this.leftButtonListener);
        this.valPanel.setAssistentName(this.getName());
        EditingPanel.instanceOf().activatePanel(this.valPanel);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dimObjects() throws Exception {
        WorkbenchContext context = WorkbenchContext.getInstance();
        Layer ly = EditingPanel.instanceOf().getCurrentLayer();
        if (ly == null) {
            throw new Exception("No editable layer selected");
        }
        if (!ly.getFMD().isInsertAllowed()) {
            throw new Exception("Layer is not insertable");
        }
        if (!(ly instanceof DimLayer) && !(ly instanceof AbstractCadLayer)) {
            throw new Exception("Layer has to be dimension layer.");
        }
        Collection<Layer> colSel = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        Iterator<Layer> iLy = colSel.iterator();
        ArrayList<UndoableCommand> lstCommands = new ArrayList<UndoableCommand>();
        while (iLy.hasNext()) {
            Layer lySel = iLy.next();
            Collection<SimpleFeature> colFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lySel);
            ArrayList<SimpleFeature> lstDimFeatures = new ArrayList<SimpleFeature>();
            for (SimpleFeature feat : colFeatures) {
                Collection<Geometry> colGeom = context.getLayerViewPanel().getSelectionManager().getSelectedItems(lySel, feat);
                for (Geometry geom : colGeom) {
                    ArrayList<Coordinate[]> lstCoord = new ArrayList<Coordinate[]>();
                    ObjectDimPlugIn.addDimCoordinates(geom, lstCoord);
                    for (Coordinate[] lstCoord1 : lstCoord) {
                        Coordinate endCoord;
                        Coordinate startCoord = lstCoord1[0];
                        double dblDist = ConstSupport.getLength((Coordinate)startCoord, (Coordinate)(endCoord = lstCoord1[1]));
                        if (dblDist == 0.0) continue;
                        double t = ConstSupport.getOrientation((Coordinate)startCoord, (Coordinate)endCoord, (int)2);
                        Coordinate coordOffset = ConstSupport.getPolarCoord((Coordinate)startCoord, (double)(dblDist / 2.0), (double)t);
                        if (this.dblOffset != 0.0) {
                            coordOffset = ConstSupport.getPolarCoord((Coordinate)coordOffset, (double)this.dblOffset, (double)(t -= 1.5707963267948966));
                        }
                        SimpleFeature feature = FeatureUtil.createFeature((SimpleFeatureType)ly.getFeatureType(), (Geometry)this.getMultiPoint(startCoord, endCoord, coordOffset));
                        lstDimFeatures.add(feature);
                    }
                }
                lstCommands.add(this.createAddCommand(ly, lstDimFeatures));
            }
        }
        try {
            if (ly instanceof AbstractCadLayer) {
                ((AbstractCadLayer)ly).setDrawDimension(true);
            }
            ObjectDimPlugIn.execute(lstCommands, (LayerManagerProxy)context);
            SaveLayerFeatureChangesPlugIn.commitLayer(ly, true, false, false);
        }
        finally {
            if (ly instanceof AbstractCadLayer) {
                ((AbstractCadLayer)ly).setDrawDimension(false);
            }
        }
        return true;
    }

    protected MultiPoint getMultiPoint(Coordinate startCoord, Coordinate endCoord, Coordinate offsetCoord) {
        Coordinate[] arrCoord = new Coordinate[]{startCoord, endCoord, offsetCoord, new Coordinate(startCoord)};
        return new GeometryFactory().createMultiPoint(arrCoord);
    }

    private UndoableCommand createAddCommand(final Layer ly, final Collection<SimpleFeature> colFeatures) {
        UndoableCommand command = new UndoableCommand(this, "AddDeleteFromRedline"){

            @Override
            public void execute() {
                ly.editFeature(colFeatures, 1);
            }

            @Override
            public void unexecute() {
                ly.editFeature(colFeatures, 3);
            }
        };
        return command;
    }

    public static void addDimCoordinates(Geometry geom, List<Coordinate[]> lst) {
        block5: {
            block4: {
                if (geom instanceof GeometryCollection) {
                    GeometryCollection gcol = (GeometryCollection)geom;
                    int intGeom = gcol.getNumGeometries();
                    for (int i = 0; i < intGeom; ++i) {
                        ObjectDimPlugIn.addDimCoordinates(gcol.getGeometryN(i), lst);
                    }
                    return;
                }
                if (!(geom instanceof LineString)) break block4;
                Coordinate[] arrCoord = geom.getCoordinates();
                for (int i = 1; i < arrCoord.length; ++i) {
                    lst.add(new Coordinate[]{arrCoord[i - 1], arrCoord[i]});
                }
                break block5;
            }
            if (!(geom instanceof Polygon)) break block5;
            Polygon poly = (Polygon)geom;
            ObjectDimPlugIn.addDimCoordinates((Geometry)poly.getExteriorRing(), lst);
            for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                ObjectDimPlugIn.addDimCoordinates((Geometry)poly.getInteriorRingN(i), lst);
            }
        }
    }

    @Override
    public EnableCheck createEnableCheck() {
        return component -> {
            String strCheck = EditingPanel.instanceOf().getDimLayerEnableCheck().check(component);
            if (strCheck != null) {
                return strCheck;
            }
            Iterator<Layer> iSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().iterator();
            if (iSelLy.hasNext()) {
                return null;
            }
            return "At least one item has to be selected";
        };
    }
}

