/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.dim;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheckable;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NamedCursorToolAssistentPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.dim.PosDimTextlTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.dim.SetDimTextPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.dim.DimFeatureAtts;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPanel;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.opengis.feature.simple.SimpleFeature;

public class EditDimTextPanel
extends JPanel
implements EnableCheckable,
NamedCursorToolAssistentPanel {
    private final ToolboxPanel pnlToolbox = new ToolboxPanel();
    private final DecimalFormat df = new DecimalFormat();
    private static EditDimTextPanel editDimTextPanel = null;
    private CursorTool ctPosDimText = null;
    private ButtonGroup grpOrtho;
    private JLabel lblText;
    private JPanel pnlTools;
    private JRadioButton rdoAbscissa;
    private JRadioButton rdoOrdinate;
    private JTextField txtText;

    private EditDimTextPanel() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    public static EditDimTextPanel instanceOf() {
        if (editDimTextPanel == null) {
            editDimTextPanel = new EditDimTextPanel();
        }
        return editDimTextPanel;
    }

    private void i18n() {
        this.lblText.setText(I18N.get("ui.cursortool.editing.dim.EditDimTextPanel.text"));
    }

    private void init() {
        this.pnlTools.add((Component)this.pnlToolbox, "Center");
        this.ctPosDimText = PosDimTextlTool.create(this.pnlToolbox.getContext());
        this.pnlToolbox.add(this.ctPosDimText, PosDimTextlTool.createEnableCheck());
        SetDimTextPlugIn slpPlugIn = new SetDimTextPlugIn();
        this.pnlToolbox.getToolBar().addSeparator();
        this.pnlToolbox.addPlugIn(slpPlugIn, slpPlugIn.createEnableCheck(), slpPlugIn.getIcon());
        this.df.setGroupingUsed(false);
        this.rdoAbscissa.setSelected(true);
    }

    public void activatePosDimTextTool(LayerViewPanel lyViewPanel) {
        this.pnlToolbox.getToolBar().getButton(0).doClick();
    }

    private void updateControls() {
        LayerViewPanel lvp;
        boolean disableAll = false;
        boolean disableOrtho = false;
        boolean orthoAbszissa = true;
        String strCheck = EditingPanel.instanceOf().getEditSelectionDimLayerEnableCheck().check(this);
        if (strCheck != null) {
            disableAll = true;
        }
        if ((lvp = WorkbenchContext.getInstance().getLayerViewPanel()) == null) {
            return;
        }
        Collection<SimpleFeature> colSelLy = lvp.getSelectionManager().getFeaturesWithSelectedItems();
        if (colSelLy.size() != 1) {
            disableAll = true;
        } else {
            SimpleFeature f = colSelLy.iterator().next();
            Number mType = (Number)FeatureUtil.getAttribute((SimpleFeature)f, (String)DimFeatureAtts.MTYPE.getName());
            if (mType == null || mType.intValue() != 2 && mType.intValue() != 1) {
                disableOrtho = true;
            } else if (mType.intValue() == 1) {
                orthoAbszissa = false;
            }
        }
        if (disableAll) {
            this.txtText.setEnabled(false);
            this.lblText.setEnabled(false);
            this.rdoAbscissa.setVisible(false);
            this.rdoOrdinate.setVisible(false);
        } else if (disableOrtho) {
            this.txtText.setEnabled(true);
            this.lblText.setEnabled(true);
            this.rdoAbscissa.setVisible(false);
            this.rdoOrdinate.setVisible(false);
        } else {
            this.txtText.setEnabled(true);
            this.lblText.setEnabled(true);
            this.rdoAbscissa.setVisible(true);
            this.rdoOrdinate.setVisible(true);
            if (orthoAbszissa) {
                this.rdoAbscissa.setText(I18N.get("ui.cursortool.editing.dim.EditDimTextPanel.abszissa"));
                this.rdoOrdinate.setText(I18N.get("ui.cursortool.editing.dim.EditDimTextPanel.ordinate"));
            } else {
                this.rdoAbscissa.setText(I18N.get("ui.cursortool.editing.dim.EditDimTextPanel.start"));
                this.rdoOrdinate.setText(I18N.get("ui.cursortool.editing.dim.EditDimTextPanel.end"));
            }
        }
    }

    public boolean isOrthoAbscissa() {
        return this.rdoAbscissa.isSelected();
    }

    public boolean isOrthoStart() {
        return this.rdoAbscissa.isSelected();
    }

    @Override
    public void updateEnabledState() {
        this.pnlToolbox.updateEnabledState();
        this.updateControls();
    }

    public String getText() {
        return this.txtText.getText();
    }

    public void setText(String strText) {
        this.txtText.setText(strText);
    }

    private void initComponents() {
        this.grpOrtho = new ButtonGroup();
        this.lblText = new JLabel();
        this.pnlTools = new JPanel();
        this.txtText = new JTextField();
        this.rdoOrdinate = new JRadioButton();
        this.rdoAbscissa = new JRadioButton();
        this.setEnabled(false);
        this.setPreferredSize(new Dimension(180, 200));
        this.setLayout(new GridBagLayout());
        this.lblText.setText("Text:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblText, gridBagConstraints);
        this.pnlTools.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlTools, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtText, gridBagConstraints);
        this.grpOrtho.add(this.rdoOrdinate);
        this.rdoOrdinate.setText("Linienma\u00df (Ordinate)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.rdoOrdinate, gridBagConstraints);
        this.grpOrtho.add(this.rdoAbscissa);
        this.rdoAbscissa.setText("Senkrechte (Abszisse)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.rdoAbscissa, gridBagConstraints);
    }

    @Override
    public String getAssistentName() {
        return I18N.get("ui.cursortool.editing.dim.EditDimTextPlugIn.name");
    }
}

