/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.AbstractConstTool;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class ConstSectionTool
extends AbstractConstTool {
    protected ConstSectionTool() {
        super(4);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        ConstSectionTool csTool = new ConstSectionTool();
        return csTool;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_cross_bearing.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.construction.ConstSectionTool.name");
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        Point2D endPoint;
        Point2D startPoint;
        double dblOri;
        Point2D point;
        Coordinate coord;
        List<Coordinate> lstCoord = this.getCoordinates();
        GeneralPath path = new GeneralPath();
        this.drawPoints(path, lstCoord);
        int counter = 0;
        Iterator<Coordinate> iC = lstCoord.iterator();
        Point2D lastPoint = null;
        while (iC.hasNext()) {
            coord = iC.next();
            point = this.getPanel().getViewport().toViewPoint(coord);
            switch (counter) {
                case 0: {
                    lastPoint = point;
                    break;
                }
                case 1: {
                    dblOri = ConstSupport.getOrientation((Point2D)lastPoint, (Point2D)point, (int)2);
                    startPoint = ConstSupport.getPolarPoint2D((Point2D)lastPoint, (double)1000.0, (double)(dblOri - Math.PI));
                    endPoint = ConstSupport.getPolarPoint2D((Point2D)point, (double)1000.0, (double)dblOri);
                    path.moveTo((float)startPoint.getX(), (float)startPoint.getY());
                    path.lineTo((float)endPoint.getX(), (float)endPoint.getY());
                    break;
                }
                case 2: {
                    lastPoint = point;
                    break;
                }
            }
            ++counter;
        }
        if (counter == 1 || counter == 3) {
            coord = this.getTentativeCoordinate();
            point = this.getPanel().getViewport().toViewPoint(coord);
            dblOri = ConstSupport.getOrientation((Point2D)lastPoint, (Point2D)point, (int)2);
            startPoint = ConstSupport.getPolarPoint2D((Point2D)lastPoint, (double)1000.0, (double)(dblOri - Math.PI));
            endPoint = ConstSupport.getPolarPoint2D((Point2D)point, (double)1000.0, (double)dblOri);
            path.moveTo((float)startPoint.getX(), (float)startPoint.getY());
            path.lineTo((float)endPoint.getX(), (float)endPoint.getY());
        }
        if (counter == 3) {
            Coordinate coordSection = null;
            try {
                coordSection = ConstSupport.getSection((Coordinate)lstCoord.get(0), (Coordinate)lstCoord.get(1), (Coordinate)lstCoord.get(2), (Coordinate)this.getTentativeCoordinate());
            }
            catch (ArithmeticException e) {
                return path;
            }
            ArrayList<Coordinate> lstTemp = new ArrayList<Coordinate>();
            lstTemp.add(coordSection);
            this.drawPoints(path, lstTemp);
        }
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        return path;
    }

    @Override
    public JPanel getAssistentPanel() {
        return DescriptionPanel.getBackPanel(I18N.get("ui.cursortool.editing.construction.ConstSectionTool.desc"), this);
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.getCoordinates().size() < 4) {
            return;
        }
        Point pt = this.getPoint();
        if (!pt.isValid()) {
            throw new Exception("Invalid section point.");
        }
        this.execute(FeatureDrawingUtil.createAddCommand((Geometry)pt, this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
        SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
    }

    protected Point getPoint() throws NoninvertibleTransformException {
        List<Coordinate> lstCoord = this.getCoordinates();
        Coordinate coordSection = ConstSupport.getSection((Coordinate)lstCoord.get(0), (Coordinate)lstCoord.get(1), (Coordinate)lstCoord.get(2), (Coordinate)lstCoord.get(3));
        return new GeometryFactory().createPoint(coordSection);
    }
}

