/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.MultiButtonPanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.jts.JTSSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ConstPolygonAssistPlugIn
extends AbstractPlugIn {
    private String strContinue = I18N.get("common.continue");
    private String strCancel = I18N.get("common.cancel");
    private String strBack = I18N.get("common.back");
    private String strOK = I18N.get("common.ok");
    private GeometryFactory gfac = new GeometryFactory();
    private PlugInContext context = null;
    private ArrayList<Geometry> lstNoAreas = new ArrayList();
    private Geometry firstGeom = null;
    private Geometry secondGeom = null;
    private Layer ly = null;
    private SimpleFeature featureEdit = null;
    private ActionListener listenSecondOK = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer lytemp;
            Collection<Layer> colLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
            Collection<Geometry> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getSelectedItems();
            ConstPolygonAssistPlugIn.this.ly = EditingPanel.instanceOf().getCurrentLayer();
            ConstPolygonAssistPlugIn.this.featureEdit = null;
            if (colLy.size() == 1 && colSelLy.size() == 1 && (lytemp = colLy.iterator().next()).isEditable()) {
                ConstPolygonAssistPlugIn.this.ly = lytemp;
                ConstPolygonAssistPlugIn.this.featureEdit = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(ConstPolygonAssistPlugIn.this.ly).iterator().next();
            }
            ConstPolygonAssistPlugIn.this.lstNoAreas.clear();
            ArrayList<Geometry> lstAreas = new ArrayList<Geometry>();
            if (colSelLy.size() > 0) {
                Geometry[] arrGeom;
                for (Geometry geom : arrGeom = colSelLy.toArray(new Geometry[0])) {
                    Geometry[] arrGeomGeometry;
                    for (Geometry geom2 : arrGeomGeometry = JTSSupport.getGeometries((Geometry)geom)) {
                        if (geom2 instanceof Polygon) {
                            lstAreas.add(geom2);
                            continue;
                        }
                        ConstPolygonAssistPlugIn.this.lstNoAreas.add(geom2);
                    }
                }
                if (lstAreas.size() > 0) {
                    if (lstAreas.size() > 1) {
                        arrGeom = lstAreas.toArray(new Geometry[0]);
                        ConstPolygonAssistPlugIn.this.firstGeom = ConstPolygonAssistPlugIn.this.gfac.createGeometryCollection(arrGeom).buffer(0.0);
                    } else {
                        ConstPolygonAssistPlugIn.this.firstGeom = ((Geometry)lstAreas.get(0)).buffer(0.0);
                    }
                    if (ConstPolygonAssistPlugIn.this.firstGeom instanceof Polygon || ConstPolygonAssistPlugIn.this.firstGeom instanceof MultiPolygon) {
                        if (ConstPolygonAssistPlugIn.this.mode == 1) {
                            ConstPolygonAssistPlugIn.this.execute_step4(ConstPolygonAssistPlugIn.this.mode);
                        } else {
                            ConstPolygonAssistPlugIn.this.execute_step3();
                        }
                        return;
                    }
                }
            }
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.select-elements"), (String)I18N.get("common.error"));
        }
    };
    private ActionListener listenFirstCancel = e -> EditingPanel.instanceOf().activateDefaultCT();
    private final ActionListener listenThirdOK = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection<Geometry> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getSelectedItems();
            if (colSelLy.size() > 0) {
                Geometry[] arrGeom = colSelLy.toArray(new Geometry[0]);
                ConstPolygonAssistPlugIn.this.secondGeom = arrGeom.length > 1 ? ConstPolygonAssistPlugIn.this.gfac.createGeometryCollection(arrGeom).buffer(0.0) : arrGeom[0].buffer(0.0);
                if (ConstPolygonAssistPlugIn.this.secondGeom instanceof Polygon || ConstPolygonAssistPlugIn.this.secondGeom instanceof MultiPolygon) {
                    ConstPolygonAssistPlugIn.this.execute_step4(ConstPolygonAssistPlugIn.this.mode);
                    return;
                }
            }
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.select-elements"), (String)I18N.get("common.error"));
        }
    };
    private final ActionListener listenSecondBack = e -> this.execute_step1();
    private final ActionListener listenThirdBack = e -> this.execute_step2();
    private int mode = 0;
    private final ActionListener listenBut1 = e -> {
        this.mode = 1;
        this.execute_step2();
    };
    private final ActionListener listenBut2 = e -> {
        this.mode = 2;
        this.execute_step2();
    };
    private final ActionListener listenBut3 = e -> {
        this.mode = 3;
        this.execute_step2();
    };

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"geometry_intersection.svg");
    }

    @Override
    public boolean execute(PlugInContext _context) throws Exception {
        this.context = _context;
        this.execute_step1();
        return true;
    }

    private void execute_step1() {
        EditingPanel.instanceOf().activateDefaultCT();
        SwingUtilities.invokeLater(() -> {
            MultiButtonPanel.instanceOf().resetPanel();
            MultiButtonPanel.instanceOf().setAssistentName(this.getName());
            MultiButtonPanel.instanceOf().setLeftButton(this.strCancel, "", this.listenFirstCancel);
            MultiButtonPanel.instanceOf().setButton1(I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.union"), I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.union.tooltip"), this.listenBut1);
            MultiButtonPanel.instanceOf().setButton2(I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.intersection"), I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.intersection.tooltip"), this.listenBut2);
            MultiButtonPanel.instanceOf().setButton3(I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.difference"), I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.difference.tooltip"), this.listenBut3);
            EditingPanel.instanceOf().activatePanel(MultiButtonPanel.instanceOf());
        });
    }

    private void execute_step2() {
        EditingPanel.instanceOf().activateDefaultCT();
        SwingUtilities.invokeLater(() -> {
            DescriptionPanel.instanceOf().resetPanel();
            DescriptionPanel.instanceOf().setAssistentName(this.getName());
            if (this.mode == 1) {
                DescriptionPanel.instanceOf().setDescription(I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.union.select"));
                DescriptionPanel.instanceOf().setRightButton(this.strOK, this.listenSecondOK);
            } else if (this.mode == 2) {
                DescriptionPanel.instanceOf().setDescription(I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.intersection.select-first"));
                DescriptionPanel.instanceOf().setRightButton(this.strContinue, this.listenSecondOK);
            } else if (this.mode == 3) {
                DescriptionPanel.instanceOf().setDescription(I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.difference.select-first"));
                DescriptionPanel.instanceOf().setRightButton(this.strContinue, this.listenSecondOK);
            }
            DescriptionPanel.instanceOf().setLeftButton(this.strBack, this.listenSecondBack);
            EditingPanel.instanceOf().activatePanel(DescriptionPanel.instanceOf());
        });
    }

    private void execute_step3() {
        EditingPanel.instanceOf().activateDefaultCT();
        SwingUtilities.invokeLater(() -> {
            DescriptionPanel.instanceOf().resetPanel();
            DescriptionPanel.instanceOf().setAssistentName(this.getName());
            if (this.mode != 1) {
                if (this.mode == 2) {
                    DescriptionPanel.instanceOf().setDescription(I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.intersection.select-second"));
                } else if (this.mode == 3) {
                    DescriptionPanel.instanceOf().setDescription(I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.difference.select-second"));
                }
            }
            DescriptionPanel.instanceOf().setLeftButton(this.strBack, this.listenThirdBack);
            DescriptionPanel.instanceOf().setRightButton(this.strOK, this.listenThirdOK);
            EditingPanel.instanceOf().activatePanel(DescriptionPanel.instanceOf());
        });
    }

    private void execute_step4(int intType) {
        try {
            if (this.ly == null) {
                throw new Exception("No editable layer selected");
            }
            if (!this.ly.getFMD().isInsertAllowed() && this.featureEdit != null) {
                throw new Exception("Layer is not insertable");
            }
            Geometry newGeom = null;
            switch (intType) {
                case 1: {
                    newGeom = this.firstGeom;
                    CoordUtil.absorbZ(this.firstGeom.getCoordinates(), newGeom.getCoordinates());
                    break;
                }
                case 2: {
                    newGeom = this.firstGeom.intersection(this.secondGeom);
                    CoordUtil.absorbZ(this.firstGeom.getCoordinates(), newGeom.getCoordinates());
                    break;
                }
                case 3: {
                    newGeom = this.firstGeom.difference(this.secondGeom);
                    CoordUtil.absorbZ(this.firstGeom.getCoordinates(), newGeom.getCoordinates());
                }
            }
            if (newGeom != null && !newGeom.isEmpty()) {
                if (this.featureEdit != null) {
                    this.featureEdit = FeatureUtil.cloneFeature((SimpleFeature)this.featureEdit);
                    EditTransaction transaction = new EditTransaction(Arrays.asList(this.featureEdit), this.getName(), this.ly, true, false, this.context.getLayerViewPanel());
                    if (this.lstNoAreas.size() > 0) {
                        ArrayList<Geometry> lstNewGeom = new ArrayList<Geometry>(this.lstNoAreas);
                        lstNewGeom.add(newGeom);
                        Geometry[] arrNewGeom = lstNewGeom.toArray(new Geometry[0]);
                        newGeom = JTSSupport.mergeGeom((Geometry[])arrNewGeom);
                    }
                    transaction.setGeometry(0, newGeom);
                    transaction.commit();
                    if (this.featureEdit != null) {
                        WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().clear();
                        WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(this.ly, this.featureEdit);
                    }
                } else {
                    SimpleFeature newFeat = null;
                    newFeat = FeatureUtil.createFeature((SimpleFeatureType)this.ly.getFeatureType(), (Geometry)newGeom);
                    AbstractPlugIn.execute(this.createAddCommand(this.ly, newFeat), (LayerManagerProxy)WorkbenchContext.getInstance());
                    if (newFeat != null) {
                        WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().clear();
                        WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(this.ly, newFeat);
                    }
                    SaveLayerFeatureChangesPlugIn.commitLayer(this.ly, true, false, false);
                }
            } else {
                GUISupport.msgbox((Component)this.context.getWorkbenchFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstPolygonAssistPlugIn.error"), (String)I18N.get("common.error"));
                return;
            }
            this.execute_step1();
        }
        catch (Exception e) {
            WorkbenchContext.getFrame().handleThrowable(e);
        }
    }

    private UndoableCommand createAddCommand(final Layer ly, SimpleFeature newFeat) {
        final ArrayList<SimpleFeature> lstNewFeat = new ArrayList<SimpleFeature>();
        lstNewFeat.add(newFeat);
        UndoableCommand command = new UndoableCommand(this, "ConstPolygonAssist"){

            @Override
            public void execute() {
                ly.editFeature(lstNewFeat, 1);
            }

            @Override
            public void unexecute() {
                ly.editFeature(lstNewFeat, 3);
            }
        };
        return command;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{Polygon.class, MultiPolygon.class});
    }
}

