/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.AbstractConstTool;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class ConstOrthoTool
extends AbstractConstTool {
    private double dblLine = 0.0;
    private double dblOrtho = 0.0;
    double tmpDblLine;
    double tmpDblOrtho;
    private boolean bolDrawNewPoint = false;
    private final ActionListener valueChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConstOrthoTool.this.dblLine = (Double)GetValuePanel.instanceOf().getValue();
                ConstOrthoTool.this.redrawShape();
            }
            catch (Throwable t) {
                WorkbenchContext.getFrame().warnUser(t.getMessage());
            }
        }
    };
    private final ActionListener value1ChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConstOrthoTool.this.dblOrtho = (Double)GetValuePanel.instanceOf().getValue1();
                ConstOrthoTool.this.redrawShape();
            }
            catch (Throwable t) {
                WorkbenchContext.getFrame().warnUser(t.getMessage());
            }
        }
    };
    private final ActionListener butOKListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConstOrthoTool.this.addOrthoPoint();
            }
            catch (Throwable t) {
                ConstOrthoTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };
    private final ActionListener butBackListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConstOrthoTool.this.back();
                EditingPanel.instanceOf().activatePanel(ConstOrthoTool.this.getAssistentPanel());
                ConstOrthoTool.this.bolDrawNewPoint = false;
            }
            catch (Throwable t) {
                ConstOrthoTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };

    protected ConstOrthoTool() {
        super(3);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        ConstOrthoTool csTool = new ConstOrthoTool();
        return csTool;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_orthogonal.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.construction.ConstOrthoTool.name");
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        Point2D endPoint;
        Point2D startPoint;
        Point2D point;
        Coordinate coord;
        List<Coordinate> lstCoord = this.getCoordinates();
        GeneralPath path = new GeneralPath();
        this.drawPoints(path, lstCoord);
        int counter = 0;
        double dblOri = 0.0;
        Iterator<Coordinate> iC = lstCoord.iterator();
        Point2D lastPoint = null;
        while (iC.hasNext()) {
            coord = iC.next();
            point = this.getPanel().getViewport().toViewPoint(coord);
            switch (counter) {
                case 0: {
                    lastPoint = point;
                    break;
                }
                case 1: {
                    dblOri = ConstSupport.getOrientation((Point2D)lastPoint, (Point2D)point, (int)2);
                    startPoint = ConstSupport.getPolarPoint2D((Point2D)lastPoint, (double)1000.0, (double)(dblOri - Math.PI));
                    endPoint = ConstSupport.getPolarPoint2D((Point2D)point, (double)1000.0, (double)dblOri);
                    path.moveTo((float)startPoint.getX(), (float)startPoint.getY());
                    path.lineTo((float)endPoint.getX(), (float)endPoint.getY());
                    break;
                }
            }
            ++counter;
        }
        if (counter == 1) {
            coord = this.getTentativeCoordinate();
            point = this.getPanel().getViewport().toViewPoint(coord);
            dblOri = ConstSupport.getOrientation((Point2D)lastPoint, (Point2D)point, (int)2);
            startPoint = ConstSupport.getPolarPoint2D((Point2D)lastPoint, (double)1000.0, (double)(dblOri - Math.PI));
            endPoint = ConstSupport.getPolarPoint2D((Point2D)point, (double)1000.0, (double)dblOri);
            path.moveTo((float)startPoint.getX(), (float)startPoint.getY());
            path.lineTo((float)endPoint.getX(), (float)endPoint.getY());
        }
        if (counter >= 1) {
            double dblArrowOri = dblOri - Math.PI;
            Point2D rootPoint = ConstSupport.getPolarPoint2D((Point2D)lastPoint, (double)8.0, (double)(dblArrowOri + 0.7853981633974483));
            Point2D arrowPoint = ConstSupport.getPolarPoint2D((Point2D)rootPoint, (double)30.0, (double)dblArrowOri);
            Point2D arrowPoint1 = ConstSupport.getPolarPoint2D((Point2D)arrowPoint, (double)6.0, (double)(dblArrowOri + 2.5132741228718345));
            Point2D arrowPoint2 = ConstSupport.getPolarPoint2D((Point2D)arrowPoint, (double)6.0, (double)(dblArrowOri - 2.5132741228718345));
            path.moveTo((float)rootPoint.getX(), (float)rootPoint.getY());
            path.lineTo((float)arrowPoint.getX(), (float)arrowPoint.getY());
            path.lineTo((float)arrowPoint1.getX(), (float)arrowPoint1.getY());
            path.moveTo((float)arrowPoint.getX(), (float)arrowPoint.getY());
            path.lineTo((float)arrowPoint2.getX(), (float)arrowPoint2.getY());
            arrowPoint = ConstSupport.getPolarPoint2D((Point2D)rootPoint, (double)30.0, (double)(dblArrowOri += 1.5707963267948966));
            arrowPoint1 = ConstSupport.getPolarPoint2D((Point2D)arrowPoint, (double)6.0, (double)(dblArrowOri + 2.5132741228718345));
            arrowPoint2 = ConstSupport.getPolarPoint2D((Point2D)arrowPoint, (double)6.0, (double)(dblArrowOri - 2.5132741228718345));
            path.moveTo((float)rootPoint.getX(), (float)rootPoint.getY());
            path.lineTo((float)arrowPoint.getX(), (float)arrowPoint.getY());
            path.lineTo((float)arrowPoint1.getX(), (float)arrowPoint1.getY());
            path.moveTo((float)arrowPoint.getX(), (float)arrowPoint.getY());
            path.lineTo((float)arrowPoint2.getX(), (float)arrowPoint2.getY());
        }
        if (this.bolDrawNewPoint && !lstCoord.isEmpty()) {
            this.tmpDblLine = this.dblLine;
            this.tmpDblOrtho = this.dblOrtho;
            Task task = this.getTaskFrame().getTask();
            if (task.isProjectionReductionActive()) {
                Coordinate coordCenter = CoordUtil.average(lstCoord.get(0), lstCoord.get(1));
                CRSDefinition crsDef = task.getCRSDefinition();
                DrawingUnit unit = task.getDrawingUnit();
                double height = task.getHeightReduction();
                this.tmpDblLine = crsDef.getProjectedDistance(this.dblLine, height, coordCenter, unit);
                this.tmpDblOrtho = crsDef.getProjectedDistance(this.dblOrtho, height, coordCenter, unit);
            }
            Coordinate coordOrtho = ConstSupport.getOrthoCoord((Coordinate)lstCoord.get(0), (Coordinate)lstCoord.get(1), (double)this.tmpDblLine, (double)this.tmpDblOrtho);
            Coordinate coordAbscissa = ConstSupport.getOrthoCoord((Coordinate)lstCoord.get(0), (Coordinate)lstCoord.get(1), (double)this.tmpDblLine, (double)0.0);
            Point2D pointAbs = this.getPanel().getViewport().toViewPoint(coordAbscissa);
            Point2D pointOrtho = this.getPanel().getViewport().toViewPoint(coordOrtho);
            path.moveTo((float)pointAbs.getX(), (float)pointAbs.getY());
            path.lineTo((float)pointOrtho.getX(), (float)pointOrtho.getY());
            ArrayList<Coordinate> lstTemp = new ArrayList<Coordinate>();
            lstTemp.add(coordOrtho);
            this.drawPoints(path, lstTemp);
        }
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        return path;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.getCoordinates().size() == 2) {
            this.getValuesAbscissaOrdinate();
            this.bolDrawNewPoint = true;
        } else {
            EditingPanel.instanceOf().activatePanel(this.getAssistentPanel());
            this.bolDrawNewPoint = false;
        }
    }

    @Override
    public JPanel getAssistentPanel() {
        return DescriptionPanel.getBackPanel(I18N.get("ui.cursortool.editing.construction.ConstOrthoTool.desc"), this);
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.getCoordinates().size() < 2) {
            return;
        }
    }

    private void getValuesAbscissaOrdinate() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setValueFormat(0);
        valPanel.setValue1Format(0);
        valPanel.setDescription(I18N.get("ui.cursortool.editing.construction.ConstOrthoTool.desc-line-ortho"));
        valPanel.setValueLabelListener(I18N.get("ui.cursortool.editing.construction.ConstOrthoTool.line") + ":", this.valueChangedListener);
        valPanel.setValue1LabelListener(I18N.get("ui.cursortool.editing.construction.ConstOrthoTool.ortho") + ":", this.value1ChangedListener);
        valPanel.setValue(this.dblLine);
        valPanel.setValue1(this.dblOrtho);
        valPanel.setRightButton(I18N.get("common.ok"), this.butOKListener);
        valPanel.setLeftButton(I18N.get("common.back"), this.butBackListener);
        valPanel.setEnterListener(this.butOKListener);
        EditingPanel.instanceOf().activatePanel(valPanel);
    }

    private void addOrthoPoint() throws Exception {
        if (this.getCoordinates().size() < 2) {
            return;
        }
        this.execute(FeatureDrawingUtil.createAddCommand((Geometry)this.getPoint(), this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
        SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
    }

    protected Point getPoint() throws NoninvertibleTransformException {
        List<Coordinate> lstCoord = this.getCoordinates();
        Coordinate coordOrtho = ConstSupport.getOrthoCoord((Coordinate)lstCoord.get(0), (Coordinate)lstCoord.get(1), (double)this.tmpDblLine, (double)this.tmpDblOrtho);
        return new GeometryFactory().createPoint(coordOrtho);
    }
}

