/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.AbstractConstTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.ConstMoveParallelSupport;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ConstMoveParallelTool
extends AbstractConstTool {
    private double dblMovement = 1.0;
    private final ActionListener valueChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConstMoveParallelTool.this.dblMovement = (Double)GetValuePanel.instanceOf().getValue();
                ConstMoveParallelTool.this.redrawShape();
            }
            catch (Throwable t) {
                WorkbenchContext.getFrame().warnUser(t.getMessage());
            }
        }
    };
    private static final EnableCheck CHK_LINE = EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{LineString.class});
    private static final EnableCheck CHK_MULTILINE = EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{MultiLineString.class});

    private double getMovement() {
        return this.dblMovement;
    }

    protected ConstMoveParallelTool() {
        super(1, false);
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        ConstMoveParallelTool csTool = new ConstMoveParallelTool();
        return csTool;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_parallel.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.construction.ConstMoveParallel.name");
    }

    private Geometry getNewGeom() {
        Coordinate coord = this.getTentativeCoordinate();
        Collection<Geometry> colGeom = this.getPanel().getSelectionManager().getSelectedItems();
        if (colGeom.size() != 1) {
            return null;
        }
        Geometry geom = colGeom.iterator().next();
        double tmpMovement = this.dblMovement;
        Task task = this.getTaskFrame().getTask();
        if (task.isProjectionReductionActive()) {
            Point centerPoint = geom.getCentroid();
            Coordinate centerCoord = new Coordinate(centerPoint.getX(), centerPoint.getY());
            CRSDefinition crsDef = task.getCRSDefinition();
            DrawingUnit unit = task.getDrawingUnit();
            tmpMovement = crsDef.getProjectedDistance(this.dblMovement, task.getHeightReduction(), centerCoord, unit);
        }
        return ConstMoveParallelSupport.moveParallel(geom, tmpMovement, coord);
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        try {
            GeneralPath path = new GeneralPath();
            Geometry newGeom = this.getNewGeom();
            if (newGeom != null) {
                Shape shape = this.getPanel().getJava2DConverter().toShape(newGeom);
                path.append(shape, false);
            }
            this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
            return path;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setValueFormat(0);
        valPanel.setValueLabelListener(I18N.get("ui.cursortool.editing.construction.ConstMoveParallel.movement"), this.valueChangedListener);
        valPanel.setValue(this.getMovement());
        return valPanel;
    }

    @Override
    protected void gestureFinished() throws Exception {
        Geometry newGeom = this.getNewGeom();
        if (newGeom == null) {
            return;
        }
        UndoableCommand cmdAddGeom = FeatureDrawingUtil.createAddCommand(newGeom, this.isRollingBackInvalidEdits(), this.getPanel(), FeatureDrawingUtil.layer(), this.getName(), true);
        this.execute(cmdAddGeom);
        SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
    }

    public static EnableCheck createEnableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Object strCheck = null;
                LayerViewPanel lvp = WorkbenchContext.getInstance().getLayerViewPanel();
                if (lvp == null) {
                    return "No LayerViewPanel active";
                }
                Iterator<Geometry> iSelGeom = lvp.getSelectionManager().getSelectedItems().iterator();
                if (iSelGeom.hasNext()) {
                    int count = 0;
                    while (iSelGeom.hasNext()) {
                        if (count > 0) {
                            return "Exactly one item has to be selected";
                        }
                        ++count;
                        Geometry geom = iSelGeom.next();
                        if (geom instanceof LineString || geom instanceof MultiLineString || geom instanceof Polygon || geom instanceof MultiPolygon) {
                            String strCheckLine = CHK_LINE.check(component);
                            String strCheckMultiLine = CHK_MULTILINE.check(component);
                            if (strCheckLine == null || strCheckMultiLine == null) continue;
                            return strCheckLine;
                        }
                        return "Only LineString and Polygons are supported.";
                    }
                    return null;
                }
                return "Exactly one item has to be selected";
            }
        };
    }
}

