/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.ConstBufferPlugIn;
import de.riwagis.util.construction.ConstSupport;
import java.util.ArrayList;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;

public class ConstMoveParallelSupport {
    private static final GeometryFactory gfac = new GeometryFactory();

    private static void checkType(Geometry geom) throws IllegalArgumentException {
        if (!(geom instanceof LineString || geom instanceof Polygon || geom instanceof MultiLineString || geom instanceof MultiPolygon)) {
            throw new IllegalArgumentException("Geometry has invalid type. Only LineString,MultiLineString,Polygon,MultiPolygon are allowed.");
        }
    }

    private static double nearestDistance(Geometry geom, Coordinate coord4Distance) throws IllegalArgumentException {
        if (geom instanceof LineString) {
            CoordinateSequence seq = ((LineString)geom).getCoordinateSequence();
            return ConstMoveParallelSupport.moveRight(seq, coord4Distance);
        }
        if (geom instanceof Polygon) {
            CoordinateSequence seqExt = ((Polygon)geom).getExteriorRing().getCoordinateSequence();
            double ldiff = ConstMoveParallelSupport.moveRight(seqExt, coord4Distance);
            if (CGAlgorithms.isCCW((Coordinate[])seqExt.toCoordinateArray())) {
                ldiff *= -1.0;
            }
            for (int i = 0; i < ((Polygon)geom).getNumInteriorRing(); ++i) {
                CoordinateSequence seqHole = ((Polygon)geom).getInteriorRingN(i).getCoordinateSequence();
                double ldifftmp = ConstMoveParallelSupport.moveRight(seqHole, coord4Distance);
                if (!(Math.abs(ldifftmp) < Math.abs(ldiff))) continue;
                ldiff = ldifftmp;
                if (!CGAlgorithms.isCCW((Coordinate[])seqExt.toCoordinateArray())) continue;
                ldiff *= -1.0;
            }
            return ldiff;
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollection gcol = (GeometryCollection)geom;
            double ldiff = Double.MAX_VALUE;
            for (int i = 0; i < gcol.getNumGeometries(); ++i) {
                Geometry geomPart = gcol.getGeometryN(i);
                double ldifftmp = ConstMoveParallelSupport.nearestDistance(geomPart, coord4Distance);
                if (!(Math.abs(ldifftmp) < Math.abs(ldiff))) continue;
                ldiff = ldifftmp;
            }
            return ldiff;
        }
        return Double.MAX_VALUE;
    }

    private static Geometry moveParallel(Geometry geom, double distance, Coordinate coord4Distance, boolean bolMoveRight) throws IllegalArgumentException {
        if (geom instanceof LineString) {
            CoordinateSequence seq = ((LineString)geom).getCoordinateSequence();
            return ConstMoveParallelSupport.moveParallelLineString(seq, distance, bolMoveRight);
        }
        if (geom instanceof Polygon) {
            return ConstMoveParallelSupport.moveParallelPolygon((Polygon)geom, distance, bolMoveRight);
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollection gcol = (GeometryCollection)geom;
            ArrayList<LineString> lstGeoms = new ArrayList<LineString>();
            for (int i = 0; i < gcol.getNumGeometries(); ++i) {
                Geometry geomPart = gcol.getGeometryN(i);
                Geometry geomPartParallel = ConstMoveParallelSupport.moveParallel(geomPart, distance, coord4Distance, bolMoveRight);
                if (geomPartParallel == null || geomPartParallel.isEmpty()) continue;
                if (geomPartParallel instanceof LineString) {
                    lstGeoms.add((LineString)geomPartParallel);
                    continue;
                }
                if (!(geomPartParallel instanceof MultiLineString)) continue;
                MultiLineString mline = (MultiLineString)geomPartParallel;
                for (int j = 0; j < mline.getNumGeometries(); ++j) {
                    lstGeoms.add((LineString)mline.getGeometryN(j));
                }
            }
            return gfac.createMultiLineString(lstGeoms.toArray(new LineString[0]));
        }
        return null;
    }

    public static Geometry moveParallel(Geometry geom, double distance, Coordinate coord4Distance) throws IllegalArgumentException {
        ConstMoveParallelSupport.checkType(geom);
        geom = ConstBufferPlugIn.toPolygon(geom);
        double ldiff = ConstMoveParallelSupport.nearestDistance(geom, coord4Distance);
        boolean bolMoveRight = false;
        if (ldiff >= 0.0) {
            bolMoveRight = true;
        }
        return ConstMoveParallelSupport.moveParallel(geom, distance, coord4Distance, bolMoveRight);
    }

    private static LineString moveParallelLineString(CoordinateSequence coordSeq, double distance, boolean bolRight) {
        BufferParameters bufParams = new BufferParameters();
        bufParams.setEndCapStyle(2);
        bufParams.setJoinStyle(2);
        bufParams.setMitreLimit(20.0);
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(new PrecisionModel(), bufParams);
        double factor = bolRight ? -1.0 : 1.0;
        return gfac.createLineString(ocb.getOffsetCurve(coordSeq.toCoordinateArray(), distance *= factor));
    }

    private static Geometry moveParallelPolygon(Polygon poly, double distance, boolean bolRight) {
        double factor = bolRight ? -1.0 : 1.0;
        return ConstBufferPlugIn.buffer((Geometry)poly, distance *= factor, false, true);
    }

    private static double moveRight(CoordinateSequence cseq, Coordinate coord4Distance) throws IllegalArgumentException {
        double oriTest;
        Coordinate coord1 = null;
        Coordinate coord2 = null;
        double ldiff = Double.MAX_VALUE;
        Coordinate[] arrGeomCoord = cseq.toCoordinateArray();
        for (int i = 1; i < arrGeomCoord.length; ++i) {
            double l2;
            Coordinate coord1Tmp = arrGeomCoord[i - 1];
            Coordinate coord2Tmp = arrGeomCoord[i];
            double l1 = ConstSupport.getLength((Coordinate)coord1Tmp, (Coordinate)coord2Tmp);
            double ldifftmp = Math.abs(l1 - (l2 = ConstSupport.getLength((Coordinate)coord1Tmp, (Coordinate)coord4Distance) + ConstSupport.getLength((Coordinate)coord2Tmp, (Coordinate)coord4Distance)));
            if (!(ldifftmp < ldiff)) continue;
            coord1 = coord1Tmp;
            coord2 = coord2Tmp;
            ldiff = ldifftmp;
        }
        Coordinate coordSection = ConstSupport.getOrthoSection(coord1, coord2, (Coordinate)coord4Distance);
        double ori1 = ConstSupport.getPositiveOrientation((double)ConstSupport.getOrientation(coord1, coord2, (int)2), (int)2);
        double ori2 = ConstSupport.getPositiveOrientation((double)ConstSupport.getOrientation((Coordinate)coordSection, (Coordinate)coord4Distance, (int)2), (int)2);
        if (Math.abs(ori2 - (oriTest = ConstSupport.getPositiveOrientation((double)(ori1 + 1.5707963267948966), (int)2))) < Math.PI / 360) {
            return ldiff * -1.0;
        }
        return ldiff;
    }

    private ConstMoveParallelSupport() {
    }
}

