/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.ConstBufferPanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.jts.JTSSupport;
import de.riwagis.util.jts.MoveXYCoordinateFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ConstBufferPlugIn
extends AbstractPlugIn {
    private static Supplier<Task> TASK_SUPPLIER = WorkbenchContext::getTask;
    private final ActionListener listenBuffer = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                double dblDistance = ConstBufferPlugIn.this.pnlBuffer.getDistance();
                boolean bolBufferExtra = ConstBufferPlugIn.this.pnlBuffer.getBufferExtra();
                boolean bolRoundCorners = ConstBufferPlugIn.this.pnlBuffer.getRoundCorners();
                boolean bolCreateLines = ConstBufferPlugIn.this.pnlBuffer.getCreateLines();
                ConstBufferPlugIn.this.drawbuffer(dblDistance, bolBufferExtra, bolRoundCorners, bolCreateLines);
            }
            catch (Throwable t) {
                WorkbenchContext.getFrame().warnUser(t.getMessage());
            }
        }
    };
    private ConstBufferPanel pnlBuffer = null;
    private final EnableCheck chkPoly = EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{Polygon.class, MultiPolygon.class});
    private final GeometryFactory gfac = new GeometryFactory();

    public ConstBufferPlugIn() {
        this.pnlBuffer = ConstBufferPanel.instanceOf();
        this.pnlBuffer.setDistance(20.0);
        this.pnlBuffer.setBufferExtra(false);
        this.pnlBuffer.setRoundCorners(true);
        this.pnlBuffer.setBufferListener(this.listenBuffer);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.construction.ConstBufferPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"geometry_buffer.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        EditingPanel.instanceOf().activateDefaultCT();
        SwingUtilities.invokeLater(() -> EditingPanel.instanceOf().activatePanel(this.pnlBuffer));
        return true;
    }

    public static Geometry buffer(Geometry geom, double dblDistance, boolean bolRoundCorners, boolean bolCreateLines) {
        Geometry newGeom;
        BufferParameters bparam = new BufferParameters();
        if (bolRoundCorners) {
            bparam.setJoinStyle(1);
            bparam.setEndCapStyle(1);
        } else {
            bparam.setJoinStyle(2);
            bparam.setEndCapStyle(3);
            bparam.setMitreLimit(20.0);
        }
        geom = (Geometry)geom.clone();
        geom = ConstBufferPlugIn.toPolygon(geom);
        double tmpDistance = dblDistance;
        Task task = TASK_SUPPLIER.get();
        if (task.isProjectionReductionActive()) {
            Point p = geom.getCentroid();
            Coordinate coordCenter = new Coordinate(p.getX(), p.getY());
            CRSDefinition crsDef = task.getCRSDefinition();
            DrawingUnit unit = task.getDrawingUnit();
            tmpDistance = crsDef.getProjectedDistance(dblDistance, task.getHeightReduction(), coordCenter, unit);
        }
        if (!bolRoundCorners) {
            double distX = geom.getEnvelopeInternal().getMinX();
            double distY = geom.getEnvelopeInternal().getMinY();
            geom.apply((CoordinateFilter)new MoveXYCoordinateFilter(-distX, -distY));
            newGeom = BufferOp.bufferOp((Geometry)geom, (double)tmpDistance, (BufferParameters)bparam);
            newGeom.apply((CoordinateFilter)new MoveXYCoordinateFilter(distX, distY));
            newGeom = newGeom.buffer(0.0);
        } else {
            newGeom = BufferOp.bufferOp((Geometry)geom, (double)tmpDistance, (BufferParameters)bparam);
        }
        if (bolCreateLines) {
            newGeom = JTSSupport.extractLines((Geometry)newGeom, (boolean)false);
        }
        return newGeom;
    }

    private void drawbuffer(double dblDistance, boolean bolBufferExtra, boolean bolRoundCorners, boolean bolCreateLines) {
        Layer ly = EditingPanel.instanceOf().getCurrentLayer();
        try {
            if (ly == null) {
                throw new Exception("No editable layer selected");
            }
            if (!ly.getFMD().isInsertAllowed()) {
                throw new Exception("Layer is not insertable");
            }
            Collection<SimpleFeature> colSel = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
            if (colSel.isEmpty()) {
                JOptionPane.showMessageDialog(WorkbenchContext.getFrame(), I18N.get("ui.cursortool.editing.construction.ConstBufferPlugIn.no-geometries-selected"), I18N.get("common.error"), 0);
                return;
            }
            Iterator<SimpleFeature> iFeat = colSel.iterator();
            ArrayList<UndoableCommand> lstCommands = new ArrayList<UndoableCommand>();
            boolean bolGeomIgnored = false;
            SimpleFeature newFeat = null;
            if (bolBufferExtra) {
                while (iFeat.hasNext()) {
                    SimpleFeature feat = iFeat.next();
                    Geometry geom = (Geometry)feat.getDefaultGeometry();
                    Geometry newGeom = ConstBufferPlugIn.buffer(geom, dblDistance, bolRoundCorners, bolCreateLines);
                    if (newGeom == null || newGeom.isEmpty()) continue;
                    CoordUtil.absorbZ(geom.getCoordinates(), newGeom.getCoordinates());
                    boolean bolGeomFound = true;
                    if (ly.getFMD().getRestrictGeomType()) {
                        Class<?>[] arrGeomClasses;
                        bolGeomFound = false;
                        for (Class<?> arrGeomClasse : arrGeomClasses = ly.getFMD().getGeomTypes()) {
                            if (!arrGeomClasse.isInstance(newGeom)) continue;
                            bolGeomFound = true;
                        }
                        if (!bolGeomFound) {
                            bolGeomIgnored = true;
                        }
                    }
                    if (!bolGeomFound) continue;
                    newFeat = FeatureUtil.createFeature((SimpleFeatureType)ly.getFeatureType(), (Geometry)newGeom);
                    lstCommands.add(this.createAddCommand(ly, newFeat));
                }
            } else {
                ArrayList<Geometry> lstGeom = new ArrayList<Geometry>();
                while (iFeat.hasNext()) {
                    SimpleFeature feat = iFeat.next();
                    Geometry geom = (Geometry)feat.getDefaultGeometry();
                    lstGeom.add(geom);
                }
                Geometry[] arrGeom = lstGeom.toArray(new Geometry[0]);
                Geometry gcol = this.gfac.createGeometryCollection(arrGeom).union();
                Geometry newGeom = ConstBufferPlugIn.buffer(gcol, dblDistance, bolRoundCorners, bolCreateLines);
                if (newGeom != null && !newGeom.isEmpty()) {
                    CoordUtil.absorbZ(gcol.getCoordinates(), newGeom.getCoordinates());
                    boolean bolGeomFound = true;
                    if (ly.getFMD().getRestrictGeomType()) {
                        Class<?>[] arrGeomClasses;
                        bolGeomFound = false;
                        for (Class<?> arrGeomClasse : arrGeomClasses = ly.getFMD().getGeomTypes()) {
                            if (!arrGeomClasse.isInstance(newGeom)) continue;
                            bolGeomFound = true;
                        }
                        if (!bolGeomFound) {
                            bolGeomIgnored = true;
                        }
                    }
                    if (bolGeomFound) {
                        newFeat = FeatureUtil.createFeature((SimpleFeatureType)ly.getFeatureType(), (Geometry)newGeom);
                        lstCommands.add(this.createAddCommand(ly, newFeat));
                    }
                }
            }
            if (bolGeomIgnored) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstBufferPlugIn.geometries-ignored"), (String)I18N.get("common.message"));
            }
            AbstractPlugIn.execute(lstCommands, (LayerManagerProxy)WorkbenchContext.getInstance(), this.isUndoable());
            if (newFeat != null) {
                WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().clear();
                WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(ly, newFeat);
            }
            SaveLayerFeatureChangesPlugIn.commitLayer(ly, true, false, false);
        }
        catch (Exception e) {
            WorkbenchContext.getFrame().handleThrowable(e);
        }
    }

    private UndoableCommand createAddCommand(final Layer ly, SimpleFeature newFeat) {
        final ArrayList<SimpleFeature> lstNewFeat = new ArrayList<SimpleFeature>();
        lstNewFeat.add(newFeat);
        UndoableCommand command = new UndoableCommand(this, "ConstBuffer"){

            @Override
            public void execute() {
                ly.editFeature(lstNewFeat, 1);
            }

            @Override
            public void unexecute() {
                ly.editFeature(lstNewFeat, 3);
            }
        };
        return command;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return component -> {
            String strCheck = this.chkPoly.check(component);
            if (strCheck != null) {
                return strCheck;
            }
            Iterator<Layer> iSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().iterator();
            if (iSelLy.hasNext()) {
                return null;
            }
            return "At least one item has to be selected";
        };
    }

    public static Geometry toPolygon(Geometry geom) {
        LineString l;
        Coordinate[] arrCoord;
        if (geom instanceof LineString && (arrCoord = (l = (LineString)geom).getCoordinates())[0].equals2D(arrCoord[arrCoord.length - 1])) {
            try {
                LinearRing ring = l.getFactory().createLinearRing(arrCoord);
                Polygon p = l.getFactory().createPolygon(ring, null);
                if (!p.isValid()) {
                    return geom;
                }
                geom = p;
            }
            catch (Exception e) {
                return geom;
            }
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollection gcol = (GeometryCollection)geom;
            ArrayList<Geometry> lstGeom = new ArrayList<Geometry>();
            for (int i = 0; i < gcol.getNumGeometries(); ++i) {
                Geometry g = gcol.getGeometryN(i);
                lstGeom.add(ConstBufferPlugIn.toPolygon(g));
            }
            return gcol.getFactory().createGeometryCollection(lstGeom.toArray(new Geometry[0]));
        }
        return geom;
    }

    public static void setTaskSupplier(Supplier<Task> taskSupplier) {
        TASK_SUPPLIER = taskSupplier;
    }
}

