/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.NamedCursorToolAssistentPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class ConstBufferPanel
extends JPanel
implements NamedCursorToolAssistentPanel {
    private final DecimalFormat df = new DecimalFormat();
    private ActionListener butBufferListener = null;
    private static ConstBufferPanel constBufferPanel = null;
    private JButton butBuffer;
    private JCheckBox chkBufferExtra;
    private JCheckBox chkCreateLine;
    private JCheckBox chkRoundCorners;
    private JLabel lblDescription;
    private JLabel lblDist;
    private JPanel pnlButton;
    private JFormattedTextField txtDist;

    private ConstBufferPanel() {
        this.initComponents();
        this.i18n();
        this.txtDist.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.df.setGroupingUsed(false);
        this.txtDist.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    ConstBufferPanel.this.butBufferListener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "Enter"));
                }
            }
        });
    }

    public static ConstBufferPanel instanceOf() {
        if (constBufferPanel == null) {
            constBufferPanel = new ConstBufferPanel();
        }
        return constBufferPanel;
    }

    public final void i18n() {
        this.lblDescription.setText(I18N.get("ui.cursortool.editing.construction.ConstBufferPanel.description"));
        this.chkBufferExtra.setText(I18N.get("ui.cursortool.editing.construction.ConstBufferPanel.buffer-extra"));
        this.chkRoundCorners.setText(I18N.get("ui.cursortool.editing.construction.ConstBufferPanel.round-corners"));
        this.chkCreateLine.setText(I18N.get("ui.cursortool.editing.construction.ConstBufferPanel.result-as-line"));
        this.lblDist.setText(I18N.get("ui.cursortool.editing.construction.ConstBufferPanel.distance"));
        this.butBuffer.setText(I18N.get("ui.cursortool.editing.construction.ConstBufferPanel.buffer"));
    }

    public double getDistance() throws ParseException {
        String strValue = this.txtDist.getText().trim();
        if (strValue.equals("-") || strValue.length() == 0) {
            strValue = "0";
        }
        return this.df.parse(strValue).doubleValue();
    }

    public void setDistance(double dblDist) {
        this.txtDist.setText(this.df.format(dblDist));
    }

    public void setBufferListener(ActionListener listener) {
        this.butBufferListener = listener;
    }

    public boolean getBufferExtra() {
        return this.chkBufferExtra.isSelected();
    }

    public void setBufferExtra(boolean bolBufferExtra) {
        this.chkBufferExtra.setSelected(bolBufferExtra);
    }

    public boolean getRoundCorners() {
        return this.chkRoundCorners.isSelected();
    }

    public void setRoundCorners(boolean bolRoundCorners) {
        this.chkRoundCorners.setSelected(bolRoundCorners);
    }

    public boolean getCreateLines() {
        return this.chkCreateLine.isSelected();
    }

    public void setCreateLines(boolean bolCreateLines) {
        this.chkCreateLine.setSelected(bolCreateLines);
    }

    @Override
    public String getAssistentName() {
        return I18N.get("ui.cursortool.editing.construction.ConstBufferPlugIn.name");
    }

    private void initComponents() {
        this.lblDist = new JLabel();
        this.txtDist = new JFormattedTextField();
        this.lblDescription = new JLabel();
        this.pnlButton = new JPanel();
        this.butBuffer = new JButton();
        this.chkBufferExtra = new JCheckBox();
        this.chkCreateLine = new JCheckBox();
        this.chkRoundCorners = new JCheckBox();
        this.setEnabled(false);
        this.setPreferredSize(new Dimension(180, 220));
        this.setLayout(new GridBagLayout());
        this.lblDist.setText("distance:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.add((Component)this.lblDist, gridBagConstraints);
        this.txtDist.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.######"))));
        this.txtDist.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtDist, gridBagConstraints);
        this.lblDescription.setText("draw buffer arround elements.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 3);
        this.add((Component)this.lblDescription, gridBagConstraints);
        this.butBuffer.setText("buffer");
        this.butBuffer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstBufferPanel.this.butBuffer_onActionPerformed(evt);
            }
        });
        this.pnlButton.add(this.butBuffer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlButton, gridBagConstraints);
        this.chkBufferExtra.setText("buffer extra");
        this.chkBufferExtra.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkBufferExtra.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 9, 3);
        this.add((Component)this.chkBufferExtra, gridBagConstraints);
        this.chkCreateLine.setText("create line");
        this.chkCreateLine.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.chkCreateLine.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 3);
        this.add((Component)this.chkCreateLine, gridBagConstraints);
        this.chkRoundCorners.setText("round corners");
        this.chkRoundCorners.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.chkRoundCorners.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 3);
        this.add((Component)this.chkRoundCorners, gridBagConstraints);
    }

    private void butBuffer_onActionPerformed(ActionEvent evt) {
        if (this.butBufferListener == null) {
            return;
        }
        this.butBufferListener.actionPerformed(evt);
    }
}

