/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.geom.InteriorPointFinder;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.ConstBufferPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.locationtech.jts.algorithm.distance.DistanceToPoint;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ConstBufferIntersectionPlugIn
extends AbstractPlugIn {
    private String strFirstDesc = I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.select-first");
    private String strSecondDesc = I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.select-second");
    private String strThirdDesc = I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.select-third");
    private String strDistance = I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.distance");
    private String strUseDistance = I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.use-distance");
    private String strArea = I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.area");
    private String strUseArea = I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.use-area");
    private String strCorners = I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.round-corners");
    private String strContinue = I18N.get("common.continue");
    private String strCancel = I18N.get("common.cancel");
    private String strBack = I18N.get("common.back");
    private String strYes = I18N.get("common.yes");
    private String strNo = I18N.get("common.no");
    private GeometryFactory gfac = new GeometryFactory();
    private PlugInContext context = null;
    private Geometry firstGeom = null;
    private Geometry secondGeom = null;
    private double dblArea = 100.0;
    private double dblDistance = 20.0;
    private boolean bolUseDistance = true;
    private boolean bolRoundCorners = false;
    private ActionListener listenFirstOK = e -> {
        Collection<Geometry> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getSelectedItems();
        if (colSelLy.size() > 0) {
            Geometry[] arrGeom = colSelLy.toArray(new Geometry[0]);
            this.firstGeom = this.gfac.createGeometryCollection(arrGeom);
            this.execute_step2();
            return;
        }
        GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.select-elements"), (String)I18N.get("common.error"));
    };
    private ActionListener listenFirstCancel = e -> EditingPanel.instanceOf().activateDefaultCT();
    private final ActionListener listenSecondOK = e -> {
        Collection<Geometry> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getSelectedItems();
        if (colSelLy.size() > 0) {
            Geometry[] arrGeom = colSelLy.toArray(new Geometry[0]);
            this.secondGeom = arrGeom.length > 1 ? this.gfac.createGeometryCollection(arrGeom).buffer(0.0) : arrGeom[0].buffer(0.0);
            if (this.secondGeom != null && !this.secondGeom.isEmpty() && (this.secondGeom instanceof Polygon || this.secondGeom instanceof MultiPolygon)) {
                this.execute_step3();
                return;
            }
        }
        GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.select-area-elements"), (String)I18N.get("common.error"));
    };
    private final ActionListener listenSecondBack = e -> this.execute_step1();
    private final ActionListener listenThirdBack = e -> this.execute_step2();
    private final ActionListener listenThirdOK = e -> this.buffer_intersect();
    private final ActionListener listenThirdRoundCorners = e -> {
        this.bolRoundCorners = GetValuePanel.instanceOf().getCbo1Value();
    };
    private final ActionListener listenThirdUseDistance = e -> {
        this.bolUseDistance = GetValuePanel.instanceOf().getCbo2Value();
        GetValuePanel.instanceOf().resetPanel();
        this.execute_step3();
    };
    private final ActionListener listenThirdUseArea = e -> {
        this.bolUseDistance = !GetValuePanel.instanceOf().getCbo3Value();
        GetValuePanel.instanceOf().resetPanel();
        this.execute_step3();
    };
    private final ActionListener listenThirdDistance = e -> {
        try {
            this.dblDistance = (Double)GetValuePanel.instanceOf().getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    };
    private final ActionListener listenThirdArea = e -> {
        try {
            this.dblArea = (Double)GetValuePanel.instanceOf().getValue1();
        }
        catch (Exception exception) {
            // empty catch block
        }
    };

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"geometry_limit.svg");
    }

    @Override
    public boolean execute(PlugInContext _context) throws Exception {
        this.context = _context;
        this.execute_step1();
        return true;
    }

    private void execute_step1() {
        EditingPanel.instanceOf().activateDefaultCT();
        SwingUtilities.invokeLater(() -> {
            DescriptionPanel.instanceOf().resetPanel();
            DescriptionPanel.instanceOf().setDescription(this.strFirstDesc);
            DescriptionPanel.instanceOf().setLeftButton(this.strCancel, this.listenFirstCancel);
            DescriptionPanel.instanceOf().setRightButton(this.strContinue, this.listenFirstOK);
            EditingPanel.instanceOf().activatePanel(DescriptionPanel.instanceOf());
        });
    }

    private void execute_step2() {
        EditingPanel.instanceOf().activateDefaultCT();
        SwingUtilities.invokeLater(() -> {
            DescriptionPanel.instanceOf().resetPanel();
            DescriptionPanel.instanceOf().setDescription(this.strSecondDesc);
            DescriptionPanel.instanceOf().setLeftButton(this.strBack, this.listenSecondBack);
            DescriptionPanel.instanceOf().setRightButton(this.strContinue, this.listenSecondOK);
            EditingPanel.instanceOf().activatePanel(DescriptionPanel.instanceOf());
        });
    }

    private void execute_step3() {
        EditingPanel.instanceOf().activateDefaultCT();
        SwingUtilities.invokeLater(() -> {
            GetValuePanel.instanceOf().resetPanel();
            GetValuePanel.instanceOf().setLeftButton(this.strBack, this.listenThirdBack);
            GetValuePanel.instanceOf().setRightButton(this.strContinue, this.listenThirdOK);
            GetValuePanel.instanceOf().setEnterListener(this.listenThirdOK);
            GetValuePanel.instanceOf().setDescription(this.strThirdDesc);
            GetValuePanel.instanceOf().setCbo1LabelListener(this.strCorners, this.listenThirdRoundCorners);
            GetValuePanel.instanceOf().setCbo1Value(this.bolRoundCorners);
            GetValuePanel.instanceOf().setCbo2LabelListener(this.strUseDistance, this.listenThirdUseDistance);
            GetValuePanel.instanceOf().setCbo2Value(this.bolUseDistance);
            GetValuePanel.instanceOf().setCbo3LabelListener(this.strUseArea, this.listenThirdUseArea);
            GetValuePanel.instanceOf().setCbo3Value(!this.bolUseDistance);
            if (this.bolUseDistance) {
                GetValuePanel.instanceOf().setValueFormat(0);
                GetValuePanel.instanceOf().setValueLabelListener(this.strDistance, this.listenThirdDistance);
                GetValuePanel.instanceOf().setValue(this.dblDistance);
            } else {
                GetValuePanel.instanceOf().setValue1Format(0);
                GetValuePanel.instanceOf().setValue1LabelListener(this.strArea, this.listenThirdArea);
                GetValuePanel.instanceOf().setValue1(this.dblArea);
            }
            EditingPanel.instanceOf().activatePanel(GetValuePanel.instanceOf());
        });
    }

    private void buffer_intersect() {
        Layer ly = EditingPanel.instanceOf().getCurrentLayer();
        try {
            if (ly == null) {
                throw new Exception("No editable layer selected");
            }
            if (!ly.getFMD().isInsertAllowed()) {
                throw new Exception("Layer is not insertable");
            }
            Task task = WorkbenchContext.getTask();
            Geometry newGeom = null;
            if (this.bolUseDistance) {
                Geometry bufferGeom = ConstBufferPlugIn.buffer(this.firstGeom, this.dblDistance, this.bolRoundCorners, false);
                Geometry intersGeom = this.secondGeom;
                Geometry bufferedFirstGeom = this.firstGeom.buffer(0.0);
                if (!bufferedFirstGeom.isEmpty() && bufferedFirstGeom.getArea() > 0.0 && !(bufferedFirstGeom instanceof GeometryCollection)) {
                    intersGeom = this.secondGeom.difference(bufferedFirstGeom);
                }
                if (intersGeom == null || intersGeom.isEmpty()) {
                    GUISupport.msgbox((Component)this.context.getWorkbenchFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.error"), (String)I18N.get("common.error"));
                    return;
                }
                newGeom = bufferGeom.intersection(intersGeom);
                CoordUtil.absorbZ(this.firstGeom.getCoordinates(), newGeom.getCoordinates());
            } else {
                double tmpArea = this.dblArea;
                if (task.isProjectionReductionActive()) {
                    Point p = this.firstGeom.getCentroid();
                    Coordinate coordCenter = new Coordinate(p.getX(), p.getY());
                    CRSDefinition crsDef = task.getCRSDefinition();
                    DrawingUnit unit = task.getDrawingUnit();
                    tmpArea = crsDef.getProjectedArea(this.dblArea, task.getHeightReduction(), coordCenter, unit);
                }
                Geometry intersGeom = this.secondGeom;
                Geometry bufferedFirstGeom = this.firstGeom.buffer(0.0);
                if (!bufferedFirstGeom.isEmpty() && bufferedFirstGeom.getArea() > 0.0 && !(bufferedFirstGeom instanceof GeometryCollection)) {
                    intersGeom = this.secondGeom.difference(bufferedFirstGeom);
                }
                if (intersGeom == null || intersGeom.isEmpty()) {
                    GUISupport.msgbox((Component)this.context.getWorkbenchFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.error"), (String)I18N.get("common.error"));
                    return;
                }
                double dblGeomArea = intersGeom.getArea();
                if (dblGeomArea < tmpArea) {
                    GUISupport.msgbox((Component)this.context.getWorkbenchFrame(), (String)I18N.getMessage("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.area-to-small", "" + tmpArea), (String)I18N.get("common.message"));
                    newGeom = intersGeom;
                } else {
                    Coordinate[] arrCoordInters;
                    InteriorPointFinder pfind = new InteriorPointFinder();
                    Coordinate coord = pfind.findPoint(intersGeom);
                    PointPairDistance ppdist = new PointPairDistance();
                    DistanceToPoint.computeDistance((Geometry)this.firstGeom, (Coordinate)coord, (PointPairDistance)ppdist);
                    double dist = ppdist.getDistance();
                    double mindist = 0.0;
                    double maxdist = Double.NEGATIVE_INFINITY;
                    for (Coordinate crd : arrCoordInters = intersGeom.getCoordinates()) {
                        PointPairDistance ppdisttmp = new PointPairDistance();
                        DistanceToPoint.computeDistance((Geometry)this.firstGeom, (Coordinate)crd, (PointPairDistance)ppdisttmp);
                        double tmpdist = ppdisttmp.getDistance();
                        if (!(tmpdist > maxdist)) continue;
                        maxdist = tmpdist;
                    }
                    int counter = 0;
                    double area = -1.0;
                    while (area != tmpArea) {
                        Geometry bufferGeom = ConstBufferPlugIn.buffer(this.firstGeom, dist, this.bolRoundCorners, false);
                        newGeom = bufferGeom.intersection(intersGeom);
                        area = newGeom.getArea();
                        if (area < tmpArea) {
                            mindist = dist;
                            dist += (maxdist - dist) / 2.0;
                        } else if (area > tmpArea) {
                            maxdist = dist;
                            dist -= (dist - mindist) / 2.0;
                        }
                        if (counter > 1000) break;
                        ++counter;
                    }
                }
            }
            SimpleFeature newFeat = null;
            if (newGeom == null || newGeom.isEmpty()) {
                GUISupport.msgbox((Component)this.context.getWorkbenchFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstBufferIntersectionPlugIn.error"), (String)I18N.get("common.error"));
                return;
            }
            newFeat = FeatureUtil.createFeature((SimpleFeatureType)ly.getFeatureType(), (Geometry)newGeom);
            AbstractPlugIn.execute(this.createAddCommand(ly, newFeat), (LayerManagerProxy)WorkbenchContext.getInstance(), this.isUndoable());
            SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
            this.execute_step1();
            if (newFeat != null) {
                WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().clear();
                WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(ly, newFeat);
            }
        }
        catch (Exception e) {
            WorkbenchContext.getFrame().handleThrowable(e);
        }
    }

    private UndoableCommand createAddCommand(final Layer ly, SimpleFeature newFeat) {
        final ArrayList<SimpleFeature> lstNewFeat = new ArrayList<SimpleFeature>();
        lstNewFeat.add(newFeat);
        UndoableCommand command = new UndoableCommand(this, "ConstBufferIntersection"){

            @Override
            public void execute() {
                ly.editFeature(lstNewFeat, 1);
            }

            @Override
            public void unexecute() {
                ly.editFeature(lstNewFeat, 3);
            }
        };
        return command;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{Polygon.class, MultiPolygon.class});
    }
}

