/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.AbstractConstTool;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.construction.ConstSupport;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class ConstArcSectionTool
extends AbstractConstTool {
    private double dblR1 = 10.0;
    private double dblR2 = 10.0;
    private final ActionListener valueChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConstArcSectionTool.this.dblR1 = (Double)GetValuePanel.instanceOf().getValue();
                ConstArcSectionTool.this.redrawShape();
            }
            catch (Throwable t) {
                WorkbenchContext.getFrame().warnUser(t.getMessage());
            }
        }
    };
    private final ActionListener value1ChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConstArcSectionTool.this.dblR2 = (Double)GetValuePanel.instanceOf().getValue1();
                ConstArcSectionTool.this.redrawShape();
            }
            catch (Throwable t) {
                WorkbenchContext.getFrame().warnUser(t.getMessage());
            }
        }
    };
    private final ActionListener butRightListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConstArcSectionTool.this.addRightPoint();
            }
            catch (Throwable t) {
                ConstArcSectionTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };
    private final ActionListener butLeftListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConstArcSectionTool.this.addLeftPoint();
            }
            catch (Throwable t) {
                ConstArcSectionTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };
    private final ActionListener enterListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConstArcSectionTool.this.addLeftPoint();
                ConstArcSectionTool.this.addRightPoint();
            }
            catch (Throwable t) {
                ConstArcSectionTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };

    protected ConstArcSectionTool() {
        super(3);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        ConstArcSectionTool csTool = new ConstArcSectionTool();
        return csTool;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_arc_section.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.construction.ConstArcSectionTool.name");
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        List<Coordinate> lstCoord = this.getCoordinates();
        GeneralPath path = new GeneralPath();
        this.drawPoints(path, lstCoord);
        int counter = 0;
        Iterator<Coordinate> iC = lstCoord.iterator();
        Object lastPoint = null;
        while (iC.hasNext()) {
            Coordinate coord = iC.next();
            Point2D point = this.getPanel().getViewport().toViewPoint(coord);
            switch (counter) {
                case 0: {
                    Point p = new GeometryFactory().createPoint(coord);
                    Geometry buffer = p.buffer(this.dblR1);
                    try {
                        Shape shpR1 = WorkbenchContext.getInstance().getLayerViewPanel().getJava2DConverter().toShape(buffer);
                        path.append(shpR1, false);
                    }
                    catch (NoninvertibleTransformException e) {
                        System.out.println("ConstArcSectionTool: Exception " + String.valueOf(e));
                    }
                    break;
                }
                case 1: {
                    Point p = new GeometryFactory().createPoint(coord);
                    Geometry buffer = p.buffer(this.dblR2);
                    try {
                        Shape shpR2 = WorkbenchContext.getInstance().getLayerViewPanel().getJava2DConverter().toShape(buffer);
                        path.append(shpR2, false);
                    }
                    catch (NoninvertibleTransformException e) {
                        System.out.println("ConstArcSectionTool: Exception " + String.valueOf(e));
                    }
                    break;
                }
            }
            ++counter;
        }
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        return path;
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setValueFormat(0);
        valPanel.setValue1Format(0);
        valPanel.setDescription(I18N.get("ui.cursortool.editing.construction.ConstArcSectionTool.desc-radius"));
        valPanel.setValueLabelListener("R1 : ", this.valueChangedListener);
        valPanel.setValue1LabelListener("R2 : ", this.value1ChangedListener);
        valPanel.setValue(this.dblR1);
        valPanel.setValue1(this.dblR2);
        valPanel.setRightButton(I18N.get("ui.cursortool.editing.construction.ConstArcSectionTool.right-section"), this.butRightListener);
        valPanel.setLeftButton(I18N.get("ui.cursortool.editing.construction.ConstArcSectionTool.left-section"), this.butLeftListener);
        valPanel.setEnterListener(this.enterListener);
        return valPanel;
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.getCoordinates().size() < 2) {
            return;
        }
    }

    private void addRightPoint() throws Exception {
        if (this.getCoordinates().size() < 2) {
            return;
        }
        Point rPt = this.getRightPoint();
        if (rPt == null) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstArcSectionTool.no-section"), (String)I18N.get("common.error"));
            return;
        }
        this.execute(FeatureDrawingUtil.createAddCommand((Geometry)rPt, this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
        SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
    }

    private void addLeftPoint() throws Exception {
        if (this.getCoordinates().size() < 2) {
            return;
        }
        Point lPt = this.getLeftPoint();
        if (lPt == null) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.construction.ConstArcSectionTool.no-section"), (String)I18N.get("common.error"));
            return;
        }
        this.execute(FeatureDrawingUtil.createAddCommand((Geometry)lPt, this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
        SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
    }

    protected Point getRightPoint() throws NoninvertibleTransformException {
        Coordinate coordArcSec;
        List<Coordinate> lstCoord = this.getCoordinates();
        double tmpR1 = this.dblR1;
        double tmpR2 = this.dblR2;
        Task task = this.getTaskFrame().getTask();
        if (task.isProjectionReductionActive()) {
            CRSDefinition crsDef = task.getCRSDefinition();
            DrawingUnit unit = task.getDrawingUnit();
            double height = task.getHeightReduction();
            tmpR1 = crsDef.getProjectedDistance(this.dblR1, height, lstCoord.get(0), unit);
            tmpR2 = crsDef.getProjectedDistance(this.dblR2, height, lstCoord.get(1), unit);
        }
        if ((coordArcSec = ConstSupport.getArcSection((Coordinate)lstCoord.get(0), (Coordinate)lstCoord.get(1), (double)tmpR1, (double)tmpR2, (boolean)true)) == null) {
            return null;
        }
        return new GeometryFactory().createPoint(coordArcSec);
    }

    protected Point getLeftPoint() throws NoninvertibleTransformException {
        Coordinate coordArcSec;
        List<Coordinate> lstCoord = this.getCoordinates();
        double tmpR1 = this.dblR1;
        double tmpR2 = this.dblR2;
        Task task = this.getTaskFrame().getTask();
        if (task.isProjectionReductionActive()) {
            CRSDefinition crsDef = task.getCRSDefinition();
            DrawingUnit unit = task.getDrawingUnit();
            double height = task.getHeightReduction();
            tmpR1 = crsDef.getProjectedDistance(this.dblR1, height, lstCoord.get(0), unit);
            tmpR2 = crsDef.getProjectedDistance(this.dblR2, height, lstCoord.get(1), unit);
        }
        if ((coordArcSec = ConstSupport.getArcSection((Coordinate)lstCoord.get(0), (Coordinate)lstCoord.get(1), (double)tmpR1, (double)tmpR2, (boolean)false)) == null) {
            return null;
        }
        return new GeometryFactory().createPoint(coordArcSec);
    }
}

