/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.AbstractConstTool;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

public class ConstAlignTool
extends AbstractConstTool {
    private final GeometryFactory geometryFactory = new GeometryFactory();

    protected ConstAlignTool() {
        super(4);
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        ConstAlignTool csTool = new ConstAlignTool();
        return csTool;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_align.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.construction.ConstAlignTool.name");
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        Point2D point;
        Coordinate coord;
        List<Coordinate> lstCoord = this.getCoordinates();
        GeneralPath path = new GeneralPath();
        this.drawPoints(path, lstCoord);
        int counter = 0;
        Iterator<Coordinate> iC = lstCoord.iterator();
        Point2D lastPoint = null;
        while (iC.hasNext()) {
            coord = iC.next();
            point = this.getPanel().getViewport().toViewPoint(coord);
            switch (counter) {
                case 0: {
                    lastPoint = point;
                    break;
                }
                case 1: {
                    path.moveTo((float)lastPoint.getX(), (float)lastPoint.getY());
                    path.lineTo((float)point.getX(), (float)point.getY());
                    break;
                }
                case 2: {
                    lastPoint = point;
                    break;
                }
            }
            ++counter;
        }
        if (counter == 1 || counter == 3) {
            coord = this.getTentativeCoordinate();
            point = this.getPanel().getViewport().toViewPoint(coord);
            path.moveTo((float)lastPoint.getX(), (float)lastPoint.getY());
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        if (counter == 3) {
            ArrayList<Coordinate> lstCoordTemp = new ArrayList<Coordinate>();
            lstCoordTemp.addAll(lstCoord);
            lstCoordTemp.add(this.getTentativeCoordinate());
            Coordinate[] arrCoord = lstCoordTemp.toArray(new Coordinate[0]);
            Shape shpSel = this.createSelectedItemsShape(arrCoord);
            path.append(shpSel, false);
        }
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        return path;
    }

    @Override
    public JPanel getAssistentPanel() {
        return DescriptionPanel.getBackPanel(I18N.get("ui.cursortool.editing.construction.ConstAlignTool.desc"), this);
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.getCoordinates().size() < 4) {
            return;
        }
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
            if (!layerWithSelectedItems.isEditable()) continue;
            transactions.add(this.createTransaction(layerWithSelectedItems));
        }
        EditTransaction.commit(transactions);
    }

    private EditTransaction createTransaction(Layer layer) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    ConstAlignTool.this.transform(item);
                }
                return geometryWithSelectedItems;
            }
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
        return transaction;
    }

    private void transform(Geometry geometry) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                Coordinate[] arrCoord = ConstAlignTool.this.getCoordinates().toArray(new Coordinate[0]);
                double dblOri1 = ConstSupport.getOrientation((Coordinate)arrCoord[0], (Coordinate)arrCoord[1], (int)2);
                double dblOri2 = ConstSupport.getOrientation((Coordinate)arrCoord[2], (Coordinate)arrCoord[3], (int)2);
                double dblRotation = dblOri2 - dblOri1;
                double dx = arrCoord[2].x - arrCoord[0].x;
                double dy = arrCoord[2].y - arrCoord[0].y;
                Coordinate coordNew = ConstSupport.getTransformedCoordinate((Coordinate)coordinate, (Coordinate)arrCoord[0], (double)dblRotation, (double)dx, (double)dy);
                coordinate.setCoordinate(coordNew);
            }
        });
    }

    private List getTransformedGeometries(List lstGeomToTransform, Coordinate centerCoord, double dblRotation, double dx, double dy) {
        ArrayList<Geometry> lstGeom = new ArrayList<Geometry>();
        Iterator iter = lstGeomToTransform.iterator();
        while (iter.hasNext()) {
            Geometry geom = (Geometry)((Geometry)iter.next()).clone();
            Coordinate[] arrGeomCoord = geom.getCoordinates();
            for (int i = 0; i < arrGeomCoord.length; ++i) {
                boolean treffer = false;
                for (int l = 0; l < i; ++l) {
                    if (arrGeomCoord[l] != arrGeomCoord[i]) continue;
                    treffer = true;
                    break;
                }
                if (treffer) continue;
                Coordinate coordNew = ConstSupport.getTransformedCoordinate((Coordinate)arrGeomCoord[i], (Coordinate)centerCoord, (double)dblRotation, (double)dx, (double)dy);
                arrGeomCoord[i].x = coordNew.x;
                arrGeomCoord[i].y = coordNew.y;
            }
            lstGeom.add(geom);
        }
        return lstGeom;
    }

    private Shape createSelectedItemsShape(Coordinate[] arrCoord) throws NoninvertibleTransformException {
        List<Object> itemsToRender = new ArrayList<Geometry>(this.getPanel().getSelectionManager().getSelectedItems());
        if (itemsToRender.size() > 100) {
            Collections.shuffle(itemsToRender);
            itemsToRender = itemsToRender.subList(0, 99);
        }
        double dblOri1 = ConstSupport.getOrientation((Coordinate)arrCoord[0], (Coordinate)arrCoord[1], (int)2);
        double dblOri2 = ConstSupport.getOrientation((Coordinate)arrCoord[2], (Coordinate)arrCoord[3], (int)2);
        double dblRotation = dblOri2 - dblOri1;
        double dx = arrCoord[2].x - arrCoord[0].x;
        double dy = arrCoord[2].y - arrCoord[0].y;
        List lstGeom = this.getTransformedGeometries(itemsToRender, arrCoord[0], dblRotation, dx, dy);
        GeometryCollection gc = this.geometryFactory.createGeometryCollection(lstGeom.toArray(new Geometry[0]));
        return this.getPanel().getJava2DConverter().toShape((Geometry)gc);
    }
}

