/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.construction;

import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;

public abstract class AbstractConstTool
extends MultiClickTool {
    private int intMaxPoints = 0;
    private int intCurrentPoints = 0;

    public AbstractConstTool(int _intMaxPoints) {
        this.intMaxPoints = _intMaxPoints;
        this.setColor(Color.BLUE);
        this.allowSnapping();
    }

    public AbstractConstTool(int _intMaxPoints, boolean snap) {
        this.intMaxPoints = _intMaxPoints;
        this.setColor(Color.BLUE);
        if (snap) {
            this.allowSnapping();
        }
    }

    @Override
    public void cancelGesture() {
        super.cancelGesture();
        this.intCurrentPoints = 0;
    }

    @Override
    protected void finishGesture() throws Exception {
        super.finishGesture();
        this.intCurrentPoints = 0;
    }

    @Override
    public void back() {
        super.back();
        if (this.intCurrentPoints > 0) {
            --this.intCurrentPoints;
        }
    }

    @Override
    public Cursor createCursor() {
        return FeatureDrawingUtil.createEditCursor();
    }

    protected void drawPoints(GeneralPath path, List lstCoord) throws NoninvertibleTransformException {
        for (Coordinate coord : lstCoord) {
            Point2D point = this.getPanel().getViewport().toViewPoint(coord);
            path.moveTo((float)point.getX(), (float)(point.getY() - 8.0));
            path.lineTo((float)point.getX(), (float)(point.getY() + 8.0));
            path.moveTo((float)(point.getX() - 8.0), (float)point.getY());
            path.lineTo((float)(point.getX() + 8.0), (float)point.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ++this.intCurrentPoints;
        super.mousePressed(e);
    }

    @Override
    protected boolean isFinishingRelease(MouseEvent e) {
        return this.intCurrentPoints >= this.intMaxPoints;
    }
}

