/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.SnapVerticesOp;
import com.vividsolutions.jump.workbench.ui.plugin.VerticesInFencePlugIn;
import de.riwagis.icons.IconLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class SnapVerticesTool
extends SpecifyFeaturesTool {
    private static final EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();

    public SnapVerticesTool() {
        this.setColor(Color.green.darker());
        this.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f));
        this.setViewClickBuffer(8);
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (!this.check(checkFactory.createAtLeastNLayersMustBeEditableCheck(1))) {
            return;
        }
        Coordinate suggestedTarget = EnvelopeUtil.centre(this.getBoxInModelCoordinates());
        SimpleFeature targetFeature = this.targetFeature(suggestedTarget, this.getBoxInModelCoordinates());
        if (!this.check(component -> targetFeature == null ? I18N.get("ui.cursortool.editing.SnapVerticesTool.no-vertices-or-edges-here") : null)) {
            return;
        }
        this.snapVertices(this.getPanel().getLayerManager().getEditableLayers(), suggestedTarget, targetFeature);
    }

    protected void snapVertices(Collection editableLayers, Coordinate suggestedTarget, SimpleFeature targetFeature) throws Exception, NoninvertibleTransformException {
        new SnapVerticesOp().execute(EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates()), editableLayers, this.isRollingBackInvalidEdits(), this.getPanel(), this.getTaskFrame().getTask(), suggestedTarget, targetFeature, JUMPWorkbench.getBlackboard().get(SnapVerticesOp.INSERT_VERTICES_IF_NECESSARY_KEY, true));
    }

    private SimpleFeature targetFeature(Coordinate suggestedTarget, Envelope fence) throws NoninvertibleTransformException {
        SimpleFeature targetFeature = this.targetFeature(suggestedTarget, fence, false);
        if (targetFeature == null) {
            targetFeature = this.targetFeature(suggestedTarget, fence, true);
        }
        return targetFeature;
    }

    private SimpleFeature targetFeature(Coordinate suggestedTarget, Envelope fence, boolean fromEditableLayers) throws NoninvertibleTransformException {
        ArrayList<SimpleFeature> candidateFeatures = new ArrayList<SimpleFeature>();
        Map<Layer, Collection<SimpleFeature>> layerToSpecifiedFeaturesMap = this.layerToSpecifiedFeaturesMap();
        for (Layer layer : layerToSpecifiedFeaturesMap.keySet()) {
            if (layer.isEditable() != fromEditableLayers) continue;
            candidateFeatures.addAll(layerToSpecifiedFeaturesMap.get(layer));
        }
        SimpleFeature targetFeature = null;
        double distanceToTargetVertices = -1.0;
        for (SimpleFeature candidate : candidateFeatures) {
            double distanceToCandidateVertices = this.distanceToVertices(suggestedTarget, candidate, fence);
            if (distanceToCandidateVertices == -1.0 || targetFeature != null && !(distanceToCandidateVertices < distanceToTargetVertices)) continue;
            targetFeature = candidate;
            distanceToTargetVertices = distanceToCandidateVertices;
        }
        return targetFeature;
    }

    private double distanceToVertices(Coordinate referenceCoordinate, SimpleFeature feature, Envelope vertexFilter) {
        double distanceToVertices = -1.0;
        for (Coordinate vertex : VerticesInFencePlugIn.verticesInFence((Geometry)feature.getDefaultGeometry(), EnvelopeUtil.toGeometry(vertexFilter), true).getCoordinates()) {
            double distanceToVertex = vertex.distance(referenceCoordinate);
            if (distanceToVertices != -1.0 && !(distanceToVertex < distanceToVertices)) continue;
            distanceToVertices = distanceToVertex;
        }
        return distanceToVertices;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_catch_points.svg");
    }

    @Override
    public Cursor createCursor() {
        return SnapVerticesTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_snap.svg").getImage());
    }

    public static EnableCheck createEnableCheck() {
        EnableCheck atLeastNLayersMustBeEditable = checkFactory.createAtLeastNLayersMustBeEditableCheck(1);
        EnableCheck frameActive = EditingPanel.instanceOf().getInternalFrameActiveCheck();
        return component -> {
            String checkLayers = atLeastNLayersMustBeEditable.check(component);
            if (checkLayers != null) {
                return checkLayers;
            }
            return frameActive.check(component);
        };
    }
}

