/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsDialog;
import com.vividsolutions.jump.workbench.ui.plugin.options.common.CommonOptionsPlugIn;
import com.vividsolutions.jump.workbench.ui.snap.GridRenderer;
import com.vividsolutions.jump.workbench.ui.snap.SnapToFeaturesPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToGridPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToIntersectionPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToVerticesPolicy;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class SnapPanel
extends JPanel {
    private Blackboard pBB = null;
    private JCheckBox cboSnapGrid;
    private JCheckBox cboSnapIntersection;
    private JCheckBox cboSnapPoint;
    private JCheckBox cboSnapPointLine;

    public SnapPanel() {
        this.initComponents();
        this.pBB = PersistentBlackboardPlugIn.get();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.cboSnapPoint.setText(I18N.get("ui.cursortool.editing.SnapPanel.snap-point"));
        this.cboSnapIntersection.setText(I18N.get("ui.cursortool.editing.SnapPanel.snap-intersection"));
        this.cboSnapPointLine.setText(I18N.get("ui.cursortool.editing.SnapPanel.snap-line"));
        this.cboSnapGrid.setText(I18N.get("ui.cursortool.editing.SnapPanel.snap-grid"));
    }

    private void init() {
        this.initSnapValues();
        OptionsDialog dlg = OptionsDialog.instance(WorkbenchContext.getWorkbench(), OptionsDialog.COMMON_DIALOG_KEY);
        dlg.addCangedListener(new OptionsDialog.ChangedListener(){

            @Override
            public void propertiesChanged() {
                SnapPanel.this.initSnapValues();
            }
        });
    }

    private void initSnapValues() {
        this.cboSnapPoint.setSelected(this.pBB.get(SnapToVerticesPolicy.ENABLED_KEY, true));
        this.cboSnapIntersection.setSelected(this.pBB.get(SnapToIntersectionPolicy.ENABLED_KEY, true));
        this.cboSnapPointLine.setSelected(this.pBB.get(SnapToFeaturesPolicy.ENABLED_KEY, false));
        this.cboSnapGrid.setSelected(this.pBB.get(SnapToGridPolicy.ENABLED_KEY, false));
    }

    private void initComponents() {
        this.cboSnapPoint = new JCheckBox();
        this.cboSnapPointLine = new JCheckBox();
        this.cboSnapGrid = new JCheckBox();
        this.cboSnapIntersection = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.cboSnapPoint.setText("Punktfang");
        this.cboSnapPoint.setMargin(new Insets(0, 0, 0, 0));
        this.cboSnapPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapPanel.this.cboSnapPoint_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.cboSnapPoint, gridBagConstraints);
        this.cboSnapPointLine.setText("Linienfang");
        this.cboSnapPointLine.setMargin(new Insets(0, 0, 0, 0));
        this.cboSnapPointLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapPanel.this.cboSnapPointLine_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.cboSnapPointLine, gridBagConstraints);
        this.cboSnapGrid.setText("Gitter anzeigen");
        this.cboSnapGrid.setMargin(new Insets(0, 0, 0, 0));
        this.cboSnapGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapPanel.this.cboSnapGrid_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.cboSnapGrid, gridBagConstraints);
        this.cboSnapIntersection.setText("Schnittpunktfang");
        this.cboSnapIntersection.setMargin(new Insets(0, 0, 0, 0));
        this.cboSnapIntersection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapPanel.this.cboSnapIntersection_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.cboSnapIntersection, gridBagConstraints);
    }

    private void cboSnapPoint_onActionPerformed(ActionEvent evt) {
        this.pBB.put(SnapToVerticesPolicy.ENABLED_KEY, this.cboSnapPoint.isSelected());
    }

    private void cboSnapPointLine_onActionPerformed(ActionEvent evt) {
        this.pBB.put(SnapToFeaturesPolicy.ENABLED_KEY, this.cboSnapPointLine.isSelected());
    }

    private void cboSnapGrid_onActionPerformed(ActionEvent evt) {
        this.pBB.put(SnapToGridPolicy.ENABLED_KEY, this.cboSnapGrid.isSelected());
        this.pBB.put(GridRenderer.ENABLED_KEY, this.cboSnapGrid.isSelected());
        if (!this.pBB.get(GridRenderer.DOTS_ENABLED_KEY, false)) {
            this.pBB.put(GridRenderer.LINES_ENABLED_KEY, this.cboSnapGrid.isSelected());
        }
        CommonOptionsPlugIn.renderGrid();
    }

    private void cboSnapIntersection_onActionPerformed(ActionEvent evt) {
        this.pBB.put(SnapToIntersectionPolicy.ENABLED_KEY, this.cboSnapIntersection.isSelected());
    }
}

