/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.ui.EditAttTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotateSelectedItemPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotationRenderObject;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.TransformableRenderObject;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingListener;
import de.riwagis.geotools.feature.RenderPointSpec;
import de.riwagis.geotools.feature.RenderType;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.bsh.BshCalculator;
import de.riwagis.util.construction.ConstSupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.type.Types;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ListRotationRenderObject;

public class RotateSymbolAndTextTool
extends NClickTool {
    static final String angleST = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.angle");
    static final String degrees = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.degrees");
    private final RenderingListener renderingListener = new RenderingListener(){

        @Override
        public void renderingStarted(LayerViewPanel panel) {
        }

        @Override
        public void renderingStopped(LayerViewPanel panel) {
            if (RotateSymbolAndTextTool.this.getCoordinates().size() != 1) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        RotateSymbolAndTextTool.this.createAndSetSelectedItemShape();
                        RotateSymbolAndTextTool.this.redrawShape();
                    }
                    catch (Exception e) {
                        RotateSymbolAndTextTool.this.getPanel().getContext().handleThrowable(e);
                    }
                }
            });
        }
    };
    private boolean undoable = true;
    private static RotateSymbolAndTextTool instance = null;
    private double fullAngle = 0.0;
    private TransformableRenderObject selectedFeatureShape = null;

    private RotateSymbolAndTextTool() {
        super(2);
        this.allowSnapping();
        this.setColor(Color.BLUE);
    }

    public void setUndoable(boolean undoable) {
        this.undoable = undoable;
    }

    @Override
    public boolean isUndoable() {
        return this.undoable;
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        Coordinate tentativeCoordinate = this.getTentativeCoordinate();
        if (tentativeCoordinate == null || this.getCoordinates().isEmpty()) {
            GeneralPath path = new GeneralPath();
            this.drawSnapCross(tentativeCoordinate, path, this.getPanel());
            return path;
        }
        Point2D firstPoint = this.getPanel().getViewport().toViewPoint(this.getCoordinates().get(0));
        Point2D tentativePoint = this.getPanel().getViewport().toViewPoint(tentativeCoordinate);
        double dblOri = ConstSupport.getOrientation((Point2D)firstPoint, (Point2D)tentativePoint, (int)2);
        Point2D textPoint = ConstSupport.getPolarPoint2D((Point2D)firstPoint, (double)50.0, (double)(dblOri += 1.5707963267948966));
        GeneralPath path = new GeneralPath();
        path.moveTo((float)textPoint.getX(), (float)textPoint.getY());
        Point2D arrowPoint1 = ConstSupport.getPolarPoint2D((Point2D)textPoint, (double)10.0, (double)(dblOri + 3.5342917352885173));
        path.lineTo((float)arrowPoint1.getX(), (float)arrowPoint1.getY());
        Point2D arrowPoint2 = ConstSupport.getPolarPoint2D((Point2D)textPoint, (double)10.0, (double)(dblOri - 3.5342917352885173));
        path.moveTo((float)textPoint.getX(), (float)textPoint.getY());
        path.lineTo((float)arrowPoint2.getX(), (float)arrowPoint2.getY());
        path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
        path.lineTo((float)firstPoint.getX(), (float)firstPoint.getY() - 50.0f);
        this.fullAngle = dblOri;
        double dblOriDeg = Math.toDegrees(dblOri);
        dblOriDeg *= -1.0;
        dblOriDeg = this.ensure360Degree(dblOriDeg);
        path.append(new Arc2D.Float((float)firstPoint.getX() - 25.0f, (float)firstPoint.getY() - 25.0f, 50.0f, 50.0f, 90.0f, (float)dblOriDeg, 0), true);
        Point2D arrowPoint3 = ConstSupport.getPolarPoint2D((Point2D)firstPoint, (double)25.0, (double)dblOri);
        path.moveTo((float)arrowPoint3.getX(), (float)arrowPoint3.getY());
        arrowPoint1 = ConstSupport.getPolarPoint2D((Point2D)arrowPoint3, (double)10.0, (double)(dblOri + 1.9634954084936207));
        path.lineTo((float)arrowPoint1.getX(), (float)arrowPoint1.getY());
        arrowPoint2 = ConstSupport.getPolarPoint2D((Point2D)arrowPoint3, (double)10.0, (double)(dblOri - 5.105088062083414));
        path.moveTo((float)arrowPoint3.getX(), (float)arrowPoint3.getY());
        path.lineTo((float)arrowPoint2.getX(), (float)arrowPoint2.getY());
        path.moveTo((float)textPoint.getX(), (float)textPoint.getY());
        path.lineTo((float)firstPoint.getX(), (float)firstPoint.getY());
        path.lineTo((int)tentativePoint.getX(), (int)tentativePoint.getY());
        this.drawSnapCross(tentativeCoordinate, path, this.getPanel());
        DecimalFormat df2 = new DecimalFormat("##0.0#");
        this.getPanel().getContext().setStatusMessage(angleST + ": " + df2.format(dblOriDeg) + " " + degrees);
        Path2D transformedShape = this.createTransformedShape();
        if (transformedShape != null) {
            path.append(transformedShape, false);
        }
        return path;
    }

    @Override
    public Cursor createCursor() {
        return RotateSymbolAndTextTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_rotate_label.svg").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"label_rotate.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.RotateSymbolAndTextTool.name");
    }

    @Override
    protected void gestureFinished() throws Exception {
        int intSelCount = this.getPanel().getSelectionManager().getFeatureSelection().getSelectedItems().size();
        if (intSelCount < 1) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.RotatePointTool.no-selection"));
            return;
        }
        final WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Coordinate> lstCoord = RotateSymbolAndTextTool.this.getCoordinates();
                    Coordinate coord1 = lstCoord.get(0);
                    Coordinate coord2 = lstCoord.get(1);
                    double dblOriDeg = ConstSupport.getOrientation((Coordinate)coord1, (Coordinate)coord2, (int)0);
                    double dblAdditionConstant = RotateSelectedItemPanel.instanceOf().getAdditionConstant();
                    dblOriDeg += 90.0 + dblAdditionConstant;
                    dblOriDeg = RotateSymbolAndTextTool.this.ensure360Degree(dblOriDeg);
                    Collection<Layer> colLy = RotateSymbolAndTextTool.this.getPanel().getSelectionManager().getLayersWithSelectedItems();
                    Iterator<Layer> iLy = colLy.iterator();
                    ArrayList<EditAttTransaction> lstTrans = new ArrayList<EditAttTransaction>();
                    while (iLy.hasNext()) {
                        boolean useTextOriAtt;
                        Layer ly = iLy.next();
                        String strOriAtt = ly.getFMD().getOriAtt();
                        String strTextOriAtt = ly.getFMD().getTextOriAtt();
                        String strOriTrans = ly.getFMD().getOriTrans();
                        boolean useOriAtt = RotateSymbolAndTextTool.this.containsAtt(ly, strOriAtt) && RotateSelectedItemPanel.instanceOf().isRotateSymbol();
                        boolean bl = useTextOriAtt = ly.getFMD().getUseText() && RotateSymbolAndTextTool.this.containsAtt(ly, strTextOriAtt) && RotateSelectedItemPanel.instanceOf().isRotateText();
                        if (!useOriAtt && !useTextOriAtt) continue;
                        EditAttTransaction trans = RotateSymbolAndTextTool.this.createTransaction(ly);
                        if (strOriTrans == null || strOriTrans.trim().length() == 0) {
                            Object objOri;
                            if (useOriAtt) {
                                objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strOriAtt), (Object)new Double(dblOriDeg));
                                trans.addAttribute(strOriAtt, objOri);
                            }
                            if (useTextOriAtt) {
                                objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strTextOriAtt), (Object)new Double(dblOriDeg));
                                trans.addAttribute(strTextOriAtt, objOri);
                            }
                        } else {
                            Object objOri;
                            BshCalculator calc = ly.getFMD().getOriTransCalc();
                            calc.setValue(dblOriDeg);
                            Double calcOri = new Double(calc.getDouble());
                            if (useOriAtt) {
                                objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strOriAtt), (Object)calcOri);
                                trans.addAttribute(strOriAtt, objOri);
                            }
                            if (useTextOriAtt) {
                                objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strTextOriAtt), (Object)calcOri);
                                trans.addAttribute(strTextOriAtt, objOri);
                            }
                        }
                        lstTrans.add(trans);
                    }
                    EditAttTransaction.commit(lstTrans, null, RotateSymbolAndTextTool.this.isUndoable());
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        });
        dlgWait.setVisible(500L);
        if (dlgWait.getError() != null) {
            this.getPanel().getContext().handleThrowable(dlgWait.getError());
        }
    }

    @Override
    public JPanel getAssistentPanel() {
        return RotateSelectedItemPanel.instanceOf();
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        this.getPanel().getRenderingManager().addRenderingListener(this.renderingListener);
        RotateSelectedItemPanel.instanceOf().setAdditionConstantEnabled(this.isActive());
        Collection<Layer> colLy = this.getPanel().getSelectionManager().getLayersWithSelectedItems();
        for (Layer ly : colLy) {
            String strOriAtt = ly.getFMD().getOriAtt();
            String strTextOriAtt = ly.getFMD().getTextOriAtt();
            boolean useOriAtt = this.containsAtt(ly, strOriAtt);
            boolean useTextOriAtt = this.containsAtt(ly, strTextOriAtt) && ly.getFMD().getUseText();
            RotateSelectedItemPanel.instanceOf().setRotateSymbolEnabled(useOriAtt);
            RotateSelectedItemPanel.instanceOf().setRotateTextEnabled(useTextOriAtt);
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.getPanel().getRenderingManager().removeRenderingListener(this.renderingListener);
        RotateSelectedItemPanel.instanceOf().setAdditionConstantEnabled(this.isActive());
    }

    private EditAttTransaction createTransaction(Layer layer) {
        return EditAttTransaction.createTransactionOnSelection(WorkbenchContext.getInstance().getLayerViewPanel(), WorkbenchContext.getInstance().getLayerViewPanel().getContext(), this.getName(), layer);
    }

    public static EnableCheck createEnableCheck() {
        return new MultiEnableCheck().add(EditingPanel.instanceOf().getInternalFrameActiveCheck()).add(EnableCheckFactory.getInstance().createAtLeastNFeaturesMustBeSelectedCheck(1)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                boolean useOriAtt = RotateSelectedItemPanel.instanceOf().isRotateSymbol();
                boolean useTextOriAtt = RotateSelectedItemPanel.instanceOf().isRotateText();
                if (useOriAtt || useTextOriAtt) {
                    return null;
                }
                return I18N.get("ui.cursortool.editing.RotateSymbolAndTextTool.no-rotation-mode");
            }
        }).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection<Layer> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
                if (colSelLy.size() != 1) {
                    return I18N.get("ui.cursortool.editing.RotateSymbolAndTextTool.only-items-on-one-layer");
                }
                for (Layer ly2test : EditingPanel.instanceOf().getEditableLayers()) {
                    if (!colSelLy.contains(ly2test) || !StringUtils.isNotEmpty((CharSequence)ly2test.getFMD().getOriAtt()) && (!ly2test.getFMD().getUseText() || !StringUtils.isNotEmpty((CharSequence)ly2test.getFMD().getTextOriAtt()))) continue;
                    return null;
                }
                return I18N.get("ui.cursortool.editing.RotateSymbolAndTextTool.no-layer-rotation");
            }
        });
    }

    private boolean containsAtt(Layer ly, String strText) {
        return StringUtils.isNotEmpty((CharSequence)strText) && ly.getFeatureType().indexOf(strText) > -1;
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return RotateSymbolAndTextTool.getInstance();
    }

    public static RotateSymbolAndTextTool getInstance() {
        if (instance == null) {
            instance = new RotateSymbolAndTextTool();
        }
        return instance;
    }

    private TransformableRenderObject createSelectedItemsShape() throws NoninvertibleTransformException {
        try {
            Collection<Layer> layersWithSelectedItems = this.getPanel().getSelectionManager().getLayersWithSelectedItems();
            if (layersWithSelectedItems.isEmpty()) {
                Assert.shouldNeverReachHere((String)"no Layer with selected features found");
            }
            Iterator<Layer> layerIter = layersWithSelectedItems.iterator();
            Layer layer = layerIter.next();
            Viewport vp = WorkbenchContext.getInstance().getLayerViewPanel().getViewport();
            FeatureIterator<SimpleFeature> fi = layer.getSelectedFeatures();
            HashSet<String> lstKeys = new HashSet<String>();
            Envelope queryEnv = new Envelope();
            while (fi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                lstKeys.add(sf.getID());
                Geometry geo = (Geometry)sf.getDefaultGeometry();
                queryEnv.expandToInclude(geo.getEnvelopeInternal());
            }
            if (lstKeys.size() > 100) {
                ArrayList lst = new ArrayList(lstKeys);
                Collections.shuffle(lst);
                lstKeys = new HashSet(lst.subList(0, 100));
            }
            if ((queryEnv = queryEnv.intersection(vp.getEnvelopeInModelCoordinates())) == null) {
                return null;
            }
            double scale = vp.getPixelScale() * vp.getScale();
            if (queryEnv.minExtent() < scale) {
                queryEnv.expandToInclude(vp.getEnvelopeInModelCoordinates());
            }
            Rectangle2D queryRect = vp.toViewRectangle(queryEnv);
            Iterator<Object> renderedIndexIter = layer.getRenderedIndexIterator(queryRect);
            String strOriAtt = layer.getFMD().getOriAtt();
            String strTextOriAtt = layer.getFMD().getTextOriAtt();
            boolean useOriAtt = this.containsAtt(layer, strOriAtt) && RotateSelectedItemPanel.instanceOf().isRotateSymbol();
            boolean useTextOriAtt = layer.getFMD().getUseText() && this.containsAtt(layer, strTextOriAtt) && RotateSelectedItemPanel.instanceOf().isRotateText();
            ListRotationRenderObject renderObject = new ListRotationRenderObject();
            while (renderedIndexIter.hasNext()) {
                Shape[] fShapes;
                RenderPointSpec spec;
                Object[] arrObj = (Object[])renderedIndexIter.next();
                SimpleFeature f = (SimpleFeature)arrObj[1];
                if (!lstKeys.contains(f.getID()) || layer instanceof AbstractCadLayer && (ObjectUtils.toString((Object)f.getAttribute("isdim")).equals("1") || ObjectUtils.toString((Object)f.getAttribute("ISDIM")).equals("1")) || arrObj[0] == null || (spec = (RenderPointSpec)arrObj[2]) == null || !useOriAtt && !useTextOriAtt) continue;
                double ori = 0.0;
                Point2D centerPt = null;
                if (useOriAtt && spec.getRenderType() == RenderType.SYMBOL) {
                    ori = spec.getOrientation();
                    centerPt = spec.getCenterPoint();
                } else {
                    if (!useTextOriAtt || spec.getRenderType() != RenderType.TEXT) continue;
                    ori = spec.getOrientation();
                    centerPt = spec.getCenterPoint();
                }
                Geometry g = (Geometry)f.getDefaultGeometry();
                if (centerPt == null) {
                    centerPt = this.getPanel().getViewport().toViewPoint(g.getCentroid().getCoordinate());
                }
                AffineTransform transform = new AffineTransform();
                transform.rotate(Math.toRadians(ori), centerPt.getX(), centerPt.getY());
                for (Shape fShape : fShapes = (Shape[])arrObj[0]) {
                    if (fShape == null) continue;
                    Path2D.Double path = new Path2D.Double(fShape, transform);
                    renderObject.addObject(new RotationRenderObject(path, centerPt));
                }
            }
            return renderObject;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean createAndSetSelectedItemShape() {
        final WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(new Runnable(){

            @Override
            public void run() {
                try {
                    RotateSymbolAndTextTool.this.selectedFeatureShape = RotateSymbolAndTextTool.this.createSelectedItemsShape();
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        });
        dlgWait.setVisible(500L);
        if (dlgWait.getError() != null) {
            this.getPanel().getContext().handleThrowable(dlgWait.getError());
        }
        return dlgWait.isCanceled();
    }

    private Path2D createTransformedShape() {
        if (this.selectedFeatureShape == null) {
            return null;
        }
        double dblOri = this.fullAngle;
        double dblAdditionConstant = RotateSelectedItemPanel.instanceOf().getAdditionConstant();
        return this.selectedFeatureShape.getTransformedShape(dblOri -= Math.toRadians(dblAdditionConstant));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.check(RotateSymbolAndTextTool.createEnableCheck())) {
            return;
        }
        if (this.getCoordinates().isEmpty()) {
            this.createAndSetSelectedItemShape();
        }
        super.mousePressed(e);
    }

    private double ensure360Degree(double dblOriDeg) {
        if (dblOriDeg < 0.0) {
            dblOriDeg += 360.0;
            dblOriDeg = this.ensure360Degree(dblOriDeg);
        } else if (dblOriDeg > 360.0) {
            dblOriDeg -= 360.0;
            dblOriDeg = this.ensure360Degree(dblOriDeg);
        }
        return dblOriDeg;
    }
}

