/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.EnableCheckable;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotateSymbolAndTextTool;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.RotateSelectedItemTool;

public class RotateSelectedItemPanel
extends JPanel
implements EnableCheckable {
    private final ToolboxPanel pnlToolbox = new ToolboxPanel();
    private static RotateSelectedItemPanel rotatePanel = null;
    private final DecimalFormat df = new DecimalFormat();
    private JComboBox<Double> cbAdditionConstant;
    private JCheckBox cbRotateSymbol;
    private JCheckBox cbRotateText;
    private JLabel lblAdditionConstant;
    private JPanel pnlTools;

    private RotateSelectedItemPanel() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    public static RotateSelectedItemPanel instanceOf() {
        if (rotatePanel == null) {
            rotatePanel = new RotateSelectedItemPanel();
        }
        return rotatePanel;
    }

    public final void i18n() {
        this.lblAdditionConstant.setText(I18N.get("ui.cursortool.editing.RotateSelectedItemPanel.additionconstant-text"));
        this.cbAdditionConstant.setToolTipText(I18N.get("ui.cursortool.editing.RotateSelectedItemPanel.additionconstant-tooltiptext"));
        this.cbRotateSymbol.setText(I18N.get("ui.cursortool.editing.RotateSelectedItemPanel.rotate-symbol"));
        this.cbRotateText.setText(I18N.get("ui.cursortool.editing.RotateSelectedItemPanel.rotate-text"));
    }

    public final void init() {
        this.pnlTools.add((Component)this.pnlToolbox, "Center");
        this.pnlToolbox.add(RotateSelectedItemTool.create(this.pnlToolbox.getContext()), RotateSelectedItemTool.createEnableCheck());
        this.pnlToolbox.getToolBar().addSeparator();
        this.pnlToolbox.add(RotateSymbolAndTextTool.create(this.pnlToolbox.getContext()), RotateSymbolAndTextTool.createEnableCheck());
        this.df.setGroupingUsed(false);
        this.cbAdditionConstant.setEditor(new ComboBoxEditor(){
            JFormattedTextField txt;
            {
                this.txt = new JFormattedTextField(GUIUtil.getNumberFormat(RotateSelectedItemPanel.this.df));
            }

            @Override
            public Component getEditorComponent() {
                return this.txt;
            }

            @Override
            public void setItem(Object anObject) {
                this.txt.setText(RotateSelectedItemPanel.this.df.format(anObject));
            }

            @Override
            public Object getItem() {
                String strValue = this.txt.getText().trim();
                if (strValue.equals("-") || strValue.length() == 0) {
                    strValue = "0";
                }
                try {
                    return RotateSelectedItemPanel.this.df.parse(strValue).doubleValue();
                }
                catch (ParseException ex) {
                    return 0;
                }
            }

            @Override
            public void selectAll() {
                this.txt.selectAll();
            }

            @Override
            public void addActionListener(ActionListener l) {
                this.txt.addActionListener(l);
            }

            @Override
            public void removeActionListener(ActionListener l) {
                this.txt.removeActionListener(l);
            }
        });
        ((JTextField)this.cbAdditionConstant.getEditor().getEditorComponent()).setHorizontalAlignment(4);
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (RotateSelectedItemTool.getInstance().isActive()) {
                    if (RotateSelectedItemTool.getInstance().isGestureInProgress()) {
                        RotateSelectedItemTool.getInstance().createAndSetSelectedItemShape();
                    }
                } else if (RotateSymbolAndTextTool.getInstance().isActive() && RotateSymbolAndTextTool.getInstance().getCoordinates().size() == 1) {
                    RotateSymbolAndTextTool.getInstance().createAndSetSelectedItemShape();
                }
                RotateSelectedItemPanel.this.updateEnabledState();
            }
        };
        this.cbRotateSymbol.addItemListener(il);
        this.cbRotateText.addItemListener(il);
    }

    public void activateRotatetSelectedItemTool(LayerViewPanel lyViewPanel) {
        this.pnlToolbox.getToolBar().getButton(0).doClick();
    }

    public void activateRotateSymbolAndTextTool(LayerViewPanel lyViewPanel) {
        this.pnlToolbox.getToolBar().getButton(1).doClick();
    }

    public double getAdditionConstant() {
        Double d = (Double)this.cbAdditionConstant.getSelectedItem();
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public void setRotateSymbol(boolean selected) {
        this.cbRotateSymbol.setSelected(selected);
    }

    public boolean isRotateSymbol() {
        return this.cbRotateSymbol.isSelected() && this.cbRotateSymbol.isEnabled();
    }

    public void setRotateSymbolEnabled(boolean enabled) {
        this.cbRotateSymbol.setEnabled(enabled);
    }

    public void setRotateText(boolean selected) {
        this.cbRotateText.setSelected(selected);
    }

    public boolean isRotateText() {
        return this.cbRotateText.isSelected() && this.cbRotateText.isEnabled();
    }

    public void setRotateTextEnabled(boolean enabled) {
        this.cbRotateText.setEnabled(enabled);
    }

    @Override
    public void updateEnabledState() {
        this.pnlToolbox.updateEnabledState();
    }

    public void setAdditionConstantEnabled(boolean enabled) {
        this.lblAdditionConstant.setEnabled(enabled);
        this.cbAdditionConstant.setEnabled(enabled);
    }

    private void initComponents() {
        this.pnlTools = new JPanel();
        this.lblAdditionConstant = new JLabel();
        this.cbAdditionConstant = new JComboBox();
        this.cbRotateSymbol = new JCheckBox();
        this.cbRotateText = new JCheckBox();
        this.setEnabled(false);
        this.setPreferredSize(new Dimension(180, 200));
        this.setLayout(new GridBagLayout());
        this.pnlTools.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlTools, gridBagConstraints);
        this.lblAdditionConstant.setText("Additionskonstante:");
        this.lblAdditionConstant.setToolTipText("Die Additionskonstante wird zu den gew\u00e4hlten Drehwinkel addiert.");
        this.lblAdditionConstant.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.add((Component)this.lblAdditionConstant, gridBagConstraints);
        this.cbAdditionConstant.setEditable(true);
        this.cbAdditionConstant.setModel(new DefaultComboBoxModel<Double>(new Double[]{0.0, 90.0, -90.0, 180.0}));
        this.cbAdditionConstant.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.cbAdditionConstant, gridBagConstraints);
        this.cbRotateSymbol.setSelected(true);
        this.cbRotateSymbol.setText("Symbol drehen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbRotateSymbol, gridBagConstraints);
        this.cbRotateText.setSelected(true);
        this.cbRotateText.setText("Text drehen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 99999.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbRotateText, gridBagConstraints);
    }
}

