/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.jts.JTSSupport;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasteItemsTool
extends NClickTool {
    private static final Logger LOG = LoggerFactory.getLogger(PasteItemsTool.class);
    private Shape pasteFeaturesShape;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private List<Coordinate> verticesToSnap = null;
    private List<SimpleFeature> features = null;
    private List<SimpleFeature> someFeatures = null;
    private Coordinate modelDestination = null;
    private Coordinate modelSource = null;
    private Layer targetLayer = null;

    public PasteItemsTool() {
        super(1);
        this.allowSnapping();
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.PasteItemsTool.name");
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public void setPasteFeatures(List<SimpleFeature> features) {
        this.features = features;
        this.verticesToSnap = null;
        this.someFeatures = null;
    }

    @Override
    protected void gestureFinished() throws Exception {
        Layer ly = this.targetLayer;
        ArrayList<SimpleFeature> lstNewFeatures = new ArrayList<SimpleFeature>();
        if (ly == null) {
            throw new Exception("No editable layer selected");
        }
        if (!ly.getFMD().isInsertAllowed()) {
            throw new Exception("Layer is not insertable");
        }
        Coordinate displacement = CoordUtil.subtract(this.modelDestination, this.modelSource);
        for (SimpleFeature f : this.features) {
            Geometry geom = (Geometry)f.getDefaultGeometry();
            geom = (Geometry)geom.clone();
            this.move(geom, displacement);
            SimpleFeature newFeat = FeatureUtil.createFeature((SimpleFeatureType)ly.getFeatureType());
            FeatureUtil.copyFeatureData((SimpleFeature)f, (SimpleFeature)newFeat);
            newFeat.setDefaultGeometry((Object)geom);
            if (ly instanceof RedlineLayer && geom != null && !geom.isEmpty()) {
                List lstGeom;
                Map userData = f.getUserData();
                Object sourceLayer = userData.get("RL_SOURCE_LAYER");
                if (sourceLayer instanceof RedlineLayer) {
                    RedlineLayerUtils.addSymbolAndFillIfNecessary(ly, (RedlineLayer)sourceLayer, f);
                    newFeat.getUserData().put("RL_KEEP_ATTRIBUTES", true);
                }
                if ((lstGeom = JTSSupport.splitGeometryCollections((Geometry)geom)).size() > 1) {
                    newFeat.setDefaultGeometry(lstGeom.get(0));
                    for (int i = 1; i < lstGeom.size(); ++i) {
                        SimpleFeature newFeat2Add = FeatureUtil.cloneFeature((SimpleFeature)newFeat, (boolean)true);
                        newFeat2Add.setDefaultGeometry(lstGeom.get(i));
                        lstNewFeatures.add(newFeat2Add);
                    }
                }
            }
            lstNewFeatures.add(newFeat);
        }
        this.execute(this.createAddDeleteCommand(ly, lstNewFeatures));
        SaveLayerFeatureChangesPlugIn.commitLayer(ly, true, false, false);
    }

    private UndoableCommand createAddDeleteCommand(final Layer ly, final ArrayList<SimpleFeature> lstNewFeatures) {
        return new UndoableCommand(this, "AddToLayer"){

            @Override
            public void execute() {
                ly.editFeature(lstNewFeatures, 1);
            }

            @Override
            public void unexecute() {
                try {
                    if (ly instanceof RedlineLayer) {
                        ((RedlineLayer)ly).setUseDefaultFeature(false);
                    }
                    ly.editFeature(lstNewFeatures, 3);
                }
                finally {
                    if (ly instanceof RedlineLayer) {
                        ((RedlineLayer)ly).setUseDefaultFeature(true);
                    }
                }
            }
        };
    }

    private void move(Geometry geometry, Coordinate displacement) {
        geometry.apply(coordinate -> coordinate.setCoordinate(CoordUtil.add(coordinate, displacement)));
        geometry.geometryChanged();
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(13);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_move.svg");
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            this.verticesToSnap = null;
            this.pasteFeaturesShape = this.createPasteItemsShape();
            super.mouseMoved(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Collection<Coordinate> verticesToSnap() {
        if (this.verticesToSnap == null) {
            this.verticesToSnap = new ArrayList<Coordinate>();
            for (SimpleFeature f : this.someFeatures()) {
                Geometry g = (Geometry)f.getDefaultGeometry();
                if (g == null || g.isEmpty()) continue;
                Coordinate[] coordinates = g.getCoordinates();
                this.verticesToSnap.addAll(Arrays.asList(coordinates));
                if (this.verticesToSnap.size() <= 50) continue;
                this.verticesToSnap.clear();
                this.verticesToSnap.add(this.getTentativeCoordinate());
                return this.verticesToSnap;
            }
        }
        return this.verticesToSnap;
    }

    private List<SimpleFeature> someFeatures() {
        if (this.someFeatures == null) {
            this.someFeatures = new ArrayList<SimpleFeature>(this.features);
            if (this.someFeatures.size() > 100) {
                Collections.shuffle(this.someFeatures);
                this.someFeatures = this.someFeatures.subList(0, 99);
            }
        }
        return this.someFeatures;
    }

    private Shape createPasteItemsShape() throws NoninvertibleTransformException {
        ArrayList<Geometry> lstGeom = new ArrayList<Geometry>();
        for (SimpleFeature f : this.someFeatures()) {
            Geometry g = (Geometry)f.getDefaultGeometry();
            if (g == null || g.isEmpty()) continue;
            lstGeom.add(g);
        }
        GeometryCollection gc = this.geometryFactory.createGeometryCollection(lstGeom.toArray(new Geometry[0]));
        this.setModelSource((Geometry)gc);
        return this.getPanel().getJava2DConverter().toShape((Geometry)gc);
    }

    @Override
    protected Shape getShape() {
        try {
            AffineTransform transform = new AffineTransform();
            this.setModelDestination(this.getTentativeCoordinate());
            Point2D ptDest = this.getPanel().getViewport().toViewPoint(this.modelDestination);
            Point2D ptOrigin = this.getPanel().getViewport().toViewPoint(this.modelSource);
            transform.translate(ptDest.getX() - ptOrigin.getX(), ptDest.getY() - ptOrigin.getY());
            return transform.createTransformedShape(this.pasteFeaturesShape);
        }
        catch (Exception e) {
            LOG.error("Error drawing shape in PasteItemsTool", (Throwable)e);
            return null;
        }
    }

    private void setModelSource(Geometry geom) {
        Coordinate[] arrCoord = geom.getCoordinates();
        int index = -1;
        double minY = Double.MAX_VALUE;
        double minX = Double.MAX_VALUE;
        int count = 0;
        for (Coordinate coord : arrCoord) {
            if (coord.y <= minY) {
                if (coord.y == minY && coord.x >= minX) continue;
                index = count;
                minY = coord.y;
                minX = coord.x;
            }
            ++count;
        }
        if (index == -1) {
            return;
        }
        this.modelSource = arrCoord[index];
    }

    private void setModelDestination(Coordinate modelDestination) {
        Collection<Coordinate> colCoord = this.verticesToSnap();
        for (Coordinate vertex : colCoord) {
            Coordinate displacement = CoordUtil.subtract(vertex, this.modelSource);
            Coordinate snapPoint = this.snap(CoordUtil.add(modelDestination, displacement));
            if (!this.getSnapManager().wasSnapCoordinateFound()) continue;
            this.modelDestination = CoordUtil.subtract(snapPoint, displacement);
            return;
        }
        this.modelDestination = modelDestination;
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setDescription("<html>" + I18N.get("ui.cursortool.editing.PasteItemsTool.description") + "</html>");
        valPanel.setLeftButton(I18N.get("ui.cursortool.editing.PasteItemsTool.insert-original-position"), e -> {
            this.modelDestination = (Coordinate)this.modelSource.clone();
            try {
                this.gestureFinished();
            }
            catch (Exception ex) {
                JUMPWorkbench.getFrame().handleThrowable(ex);
            }
        });
        return valPanel;
    }

    public void setTargetLayer(Layer targetLayer) {
        this.targetLayer = targetLayer;
    }
}

