/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.highdpi.HighDpiCursorSupport;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class MoveVertexTool
extends DragTool {
    public static final int TOLERANCE = HighDpiCursorSupport.CURSOR_32PIXEL_SIZE / 2;
    private final EnableCheckFactory checkFactory;
    private final ArrayList<Geometry> previewGeometry = new ArrayList();

    public MoveVertexTool(EnableCheckFactory checkFactory) {
        this.checkFactory = checkFactory;
        this.allowSnapping();
    }

    @Override
    public Cursor createCursor() {
        return MoveVertexTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_place.svg").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_move_vertex.svg");
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.previewGeometry.clear();
        this.moveVertices(this.getModelSource(), this.getModelDestination());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            if (!this.checkMouseButton(e)) {
                return;
            }
            if (!this.check(this.checkFactory.createAtLeastNLayersMustBeEditableCheck(1))) {
                return;
            }
            if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
                return;
            }
            Optional<Coordinate> nearestPoint = this.getNearestPoint(e.getPoint());
            if (!this.check(component -> {
                try {
                    return !nearestPoint.isPresent() ? I18N.get("ui.cursortool.MoveVertexTool.no-editable-selection-handles-here") : null;
                }
                catch (Exception e1) {
                    return e1.toString();
                }
            })) {
                return;
            }
            super.mousePressed(e);
            nearestPoint.ifPresent(x$0 -> this.setModelSource((Coordinate)x$0));
        }
        catch (NoninvertibleTransformException t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Optional<Coordinate> getNearestPoint(Point2D uiPoint) throws NoninvertibleTransformException {
        Coordinate mousePt = this.snap(this.getPanel().getViewport().toModelCoordinate(uiPoint));
        Envelope dragArea = this.vertexBuffer(mousePt);
        SelectionManager selectionManager = this.getPanel().getSelectionManager();
        List<Geometry> geometries = selectionManager.getLayersWithSelectedItems().stream().filter(Layer::isEditable).flatMap(layer -> selectionManager.getSelectedItems((Layer)layer).stream()).collect(Collectors.toUnmodifiableList());
        Optional<Coordinate> nearestPoint = geometries.stream().flatMap(geometry -> Arrays.stream(geometry.getCoordinates())).filter(arg_0 -> ((Envelope)dragArea).contains(arg_0)).min(Comparator.comparingDouble(arg_0 -> ((Coordinate)mousePt).distance(arg_0)));
        this.updatePreviewGeometry(geometries, dragArea);
        return nearestPoint;
    }

    private void updatePreviewGeometry(List<Geometry> geometries, Envelope dragArea) {
        this.previewGeometry.clear();
        geometries.stream().map(geometry -> Pair.of((Object)geometry, Arrays.stream(geometry.getCoordinates()))).filter(geoAndCoords -> ((Stream)geoAndCoords.getRight()).anyMatch(arg_0 -> ((Envelope)dragArea).contains(arg_0))).forEach(geoAndCoords -> this.previewGeometry.add(((Geometry)geoAndCoords.getLeft()).copy()));
    }

    private Envelope vertexBuffer(Coordinate c) {
        double tolerance = (double)TOLERANCE / this.getPanel().getViewport().getScale();
        return this.vertexBuffer(c, tolerance);
    }

    public void moveVertices(Coordinate initialLocation, Coordinate finalLocation) {
        Coordinate newVertex = finalLocation;
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
            if (!layerWithSelectedItems.isEditable()) continue;
            transactions.add(this.createTransaction(layerWithSelectedItems, initialLocation, newVertex));
        }
        EditTransaction.commit(transactions);
    }

    private EditTransaction createTransaction(Layer layer, final Coordinate oldVertex, final Coordinate newVertex) {
        return EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            @Override
            public Geometry edit(Geometry geometryWithSelectedItems, Collection<Geometry> selectedItems) {
                for (Geometry item : selectedItems) {
                    this.edit(item);
                }
                return geometryWithSelectedItems;
            }

            private void edit(Geometry selectedItem) {
                selectedItem.apply(coordinate -> {
                    if (oldVertex.equals((Object)coordinate)) {
                        coordinate.x = newVertex2.x;
                        coordinate.y = newVertex2.y;
                    }
                });
            }
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
    }

    @Override
    protected Shape getShape(Point2D source, Point2D destination) throws Exception {
        GeneralPath path = new GeneralPath();
        this.drawSnapCross(this.getModelDestination(), path, this.getPanel());
        Coordinate oldVertex = this.getModelSource();
        Coordinate newVertex = this.getModelDestination();
        for (Geometry item : this.previewGeometry) {
            Geometry copy = item.copy();
            copy.apply(coordinate -> {
                if (oldVertex.equals2D(coordinate)) {
                    coordinate.x = newVertex.x;
                    coordinate.y = newVertex.y;
                }
            });
            path.append(this.getPanel().getJava2DConverter().toShape(copy), false);
        }
        return path;
    }

    private Envelope vertexBuffer(Coordinate vertex, double tolerance) {
        return new Envelope(vertex.x - tolerance, vertex.x + tolerance, vertex.y - tolerance, vertex.y + tolerance);
    }
}

