/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingListener;
import de.riwagis.geotools.feature.RenderPointSpec;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveSelectedItemsTool
extends DragTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MoveSelectedItemsTool.class);
    private final EnableCheckFactory checkFactory;
    private Shape selectedFeaturesShape;
    private List<Coordinate> verticesToSnap = null;
    private final RenderingListener renderingListener = new RenderingListener(){

        @Override
        public void renderingStarted(LayerViewPanel panel) {
        }

        @Override
        public void renderingStopped(LayerViewPanel panel) {
            if (!MoveSelectedItemsTool.this.isDragApproved()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                try {
                    MoveSelectedItemsTool.this.createAndSetSelectedItemShape();
                    MoveSelectedItemsTool.this.redrawShape();
                }
                catch (Exception e) {
                    MoveSelectedItemsTool.this.getPanel().getContext().handleThrowable(e);
                }
            });
        }
    };

    public MoveSelectedItemsTool(EnableCheckFactory checkFactory) {
        this.checkFactory = checkFactory;
        this.allowSnapping();
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        this.getPanel().getRenderingManager().addRenderingListener(this.renderingListener);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.getPanel().getRenderingManager().removeRenderingListener(this.renderingListener);
        this.selectedFeaturesShape = null;
    }

    @Override
    protected void gestureFinished() throws Exception {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(() -> {
            try {
                Coordinate displacement = CoordUtil.subtract(this.getModelDestination(), this.getModelSource());
                ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
                for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
                    transactions.add(this.createTransaction(layerWithSelectedItems, displacement));
                }
                EditTransaction.commit(transactions);
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(500L);
        if (dlgWait.getError() != null) {
            this.getPanel().getContext().handleThrowable(dlgWait.getError());
        }
    }

    private EditTransaction createTransaction(Layer layer, Coordinate displacement) {
        return EditTransaction.createTransactionOnSelection((geometryWithSelectedItems, selectedItems) -> {
            for (Geometry item : selectedItems) {
                this.move(item, displacement);
            }
            return geometryWithSelectedItems;
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
    }

    private void move(Geometry geometry, Coordinate displacement) {
        geometry.apply(coordinate -> coordinate.setCoordinate(CoordUtil.add(coordinate, displacement)));
        geometry.geometryChanged();
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(13);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_move.svg");
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            if (!this.checkMouseButton(e)) {
                return;
            }
            if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
                return;
            }
            if (!this.check(this.checkFactory.createSelectedItemsLayersMustBeEditableCheck())) {
                return;
            }
            this.verticesToSnap = null;
            boolean ret = this.createAndSetSelectedItemShape();
            if (ret) {
                return;
            }
            super.mousePressed(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Collection<Coordinate> verticesToSnap() {
        if (this.verticesToSnap == null) {
            this.verticesToSnap = new ArrayList<Coordinate>();
            for (Geometry selectedItem : this.getPanel().getSelectionManager().getSelectedItems()) {
                Collections.addAll(this.verticesToSnap, selectedItem.getCoordinates());
            }
            if (this.verticesToSnap.size() > 100) {
                Collections.shuffle(this.verticesToSnap);
                this.verticesToSnap = this.verticesToSnap.subList(0, 99);
            }
        }
        return this.verticesToSnap;
    }

    private Shape createSelectedItemsShape() {
        try {
            Collection<Layer> layersWithSelectedItems = this.getPanel().getSelectionManager().getLayersWithSelectedItems();
            if (layersWithSelectedItems.isEmpty()) {
                Assert.shouldNeverReachHere((String)"no Layer with selected features found");
            }
            Iterator<Layer> layerIter = layersWithSelectedItems.iterator();
            Viewport vp = WorkbenchContext.getInstance().getLayerViewPanel().getViewport();
            ArrayList<Shape> selectedShapes = new ArrayList<Shape>();
            while (layerIter.hasNext()) {
                Layer layer = layerIter.next();
                Envelope queryEnv = vp.getEnvelopeInModelCoordinates();
                Rectangle2D queryRect = vp.toViewRectangle(queryEnv);
                FeatureIterator<SimpleFeature> fi = layer.getSelectedFeatures();
                HashSet<String> lstKeys = new HashSet<String>();
                while (fi.hasNext()) {
                    lstKeys.add(((SimpleFeature)fi.next()).getID());
                }
                if (lstKeys.size() > 100) {
                    ArrayList lst = new ArrayList(lstKeys);
                    Collections.shuffle(lst);
                    lstKeys = new HashSet(lst.subList(0, 100));
                }
                Iterator<Object> renderedIndexIter = layer.getRenderedIndexIterator(queryRect);
                while (renderedIndexIter.hasNext()) {
                    Object[] arrObj = (Object[])renderedIndexIter.next();
                    Shape[] featureShapes = (Shape[])arrObj[0];
                    SimpleFeature f = (SimpleFeature)arrObj[1];
                    RenderPointSpec spec = (RenderPointSpec)arrObj[2];
                    if (!lstKeys.contains(f.getID())) continue;
                    Geometry filteredGeo = this.getPanel().getSelectionManager().filterGeometryIfNecessary(layer, f);
                    Shape shape = this.getPanel().getJava2DConverter().toShape(filteredGeo, 10.0);
                    selectedShapes.add(shape);
                    if (featureShapes == null) continue;
                    if (filteredGeo == f.getDefaultGeometry()) {
                        Collections.addAll(selectedShapes, featureShapes);
                        continue;
                    }
                    this.processIfSelected(spec, featureShapes, filteredGeo, selectedShapes::add);
                }
            }
            if (selectedShapes.isEmpty()) {
                return null;
            }
            Path2D.Double area = new Path2D.Double();
            for (Shape tmpShape : selectedShapes) {
                area.append(tmpShape, false);
            }
            return area;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean createAndSetSelectedItemShape() {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(() -> {
            try {
                this.selectedFeaturesShape = this.createSelectedItemsShape();
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(500L);
        if (dlgWait.getError() != null) {
            this.getPanel().getContext().handleThrowable(dlgWait.getError());
        }
        return dlgWait.isCanceled();
    }

    @Override
    protected Shape getShape() throws Exception {
        AffineTransform transform = new AffineTransform();
        transform.translate(this.getViewDestination().getX() - this.getViewSource().getX(), this.getViewDestination().getY() - this.getViewSource().getY());
        return transform.createTransformedShape(this.selectedFeaturesShape);
    }

    @Override
    protected void setModelDestination(Coordinate modelDestination) {
        Iterator<Coordinate> iterator = this.verticesToSnap().iterator();
        while (iterator.hasNext()) {
            Coordinate o;
            Coordinate vertex = o = iterator.next();
            Coordinate displacement = CoordUtil.subtract(vertex, this.getModelSource());
            Coordinate snapPoint = this.snap(CoordUtil.add(modelDestination, displacement));
            if (!this.getSnapManager().wasSnapCoordinateFound()) continue;
            this.modelDestination = CoordUtil.subtract(snapPoint, displacement);
            return;
        }
        this.modelDestination = modelDestination;
    }
}

