/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.jts.CoordinateArraySupport;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public class InsertVertexTool
extends NClickTool {
    private static final int PIXEL_RANGE = 5;
    private final EnableCheckFactory checkFactory;
    private final GeometryEditor geometryEditor = new GeometryEditor();
    private final List<SegmentContext> previewSegments = new ArrayList<SegmentContext>();
    private final SegmentUtilities segmentUtilities = new SegmentUtilities();

    public InsertVertexTool(EnableCheckFactory checkFactory) {
        super(1);
        this.checkFactory = checkFactory;
        this.allowSnapping();
    }

    private double modelRange() {
        return 5.0 / this.getPanel().getViewport().getScale();
    }

    private Collection<SimpleFeature> featuresInRange(Coordinate modelClickCoordinate, Layer layer) {
        Point modelClickPoint = new GeometryFactory().createPoint(modelClickCoordinate);
        Collection<SimpleFeature> featuresWithSelectedItems = this.getPanel().getSelectionManager().getFeaturesWithSelectedItems(layer);
        if (featuresWithSelectedItems.isEmpty()) {
            return new ArrayList<SimpleFeature>();
        }
        ArrayList<SimpleFeature> featuresInRange = new ArrayList<SimpleFeature>();
        for (SimpleFeature candidate : featuresWithSelectedItems) {
            if (!(modelClickPoint.distance((Geometry)candidate.getDefaultGeometry()) <= this.modelRange())) continue;
            featuresInRange.add(candidate);
        }
        return featuresInRange;
    }

    private Coordinate modelClickCoordinate() throws NoninvertibleTransformException {
        return this.getCoordinates().get(0);
    }

    private List<SegmentContext> findSegment(Layer layer, Collection<SimpleFeature> features, Coordinate target) {
        Assert.isTrue((boolean)layer.isEditable());
        ArrayList<SegmentContext> segments = new ArrayList<SegmentContext>();
        for (SimpleFeature feature : features) {
            for (Geometry selectedItem : this.getPanel().getSelectionManager().getSelectedItems(layer, feature)) {
                LineSegment segment = this.segmentUtilities.segmentInRange(selectedItem, target, this.modelRange());
                if (segment == null) continue;
                segments.add(new SegmentContext(this, layer, feature, segment));
            }
        }
        return segments;
    }

    private Map<Layer, List<SegmentContext>> findSegments(Map<Layer, Collection<SimpleFeature>> layerToFeaturesMap, Coordinate target) {
        HashMap<Layer, List<SegmentContext>> segments = new HashMap<Layer, List<SegmentContext>>();
        layerToFeaturesMap.keySet().forEach(layer -> {
            Collection features = (Collection)layerToFeaturesMap.get(layer);
            List<SegmentContext> segmentContext = this.findSegment((Layer)layer, features, target);
            if (!segmentContext.isEmpty()) {
                segments.put((Layer)layer, segmentContext);
            }
        });
        return segments;
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.previewSegments.clear();
        if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
            return;
        }
        Map<Layer, Collection<SimpleFeature>> layerToFeaturesInRangeMap = this.layerToFeaturesInRangeMap();
        if (layerToFeaturesInRangeMap.isEmpty()) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.InsertVertexTool.no-selected-editable-items-here"));
            return;
        }
        Coordinate targetStart = this.modelClickCoordinate();
        Coordinate targetEnd = this.getTentativeCoordinate();
        Map<Layer, List<SegmentContext>> segmentsOnLayers = this.findSegments(layerToFeaturesInRangeMap, targetStart);
        if (segmentsOnLayers.isEmpty()) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.InsertVertexTool.no-selected-line-segments-here"));
            return;
        }
        segmentsOnLayers.forEach((layer, segments) -> this.createTransactionForLayer((Layer)layer, (List<SegmentContext>)segments, targetStart, targetEnd));
    }

    private void createTransactionForLayer(Layer layer, List<SegmentContext> segments, Coordinate targetStart, Coordinate targetEnd) {
        List<SimpleFeature> features = segments.stream().map(s -> s.getFeature()).collect(Collectors.toList());
        EditTransaction transaction = new EditTransaction(features, this.getName(), layer, this.isRollingBackInvalidEdits(), false, this.getPanel());
        segments.stream().forEach(segment -> {
            Geometry newGeometry = this.getTransformedGeometry((SegmentContext)segment, targetStart, targetEnd);
            transaction.setGeometry(segment.getFeature(), newGeometry);
        });
        transaction.commit(() -> {
            try {
                Animations.drawExpandingRing(this.getPanel().getViewport().toViewPoint(this.getTentativeCoordinate()), false, Color.green, this.getPanel(), null);
            }
            catch (Throwable t) {
                this.getPanel().getContext().warnUser(t.toString());
            }
        });
    }

    private Geometry getTransformedGeometry(SegmentContext segment, Coordinate targetStart, Coordinate targetEnd) {
        LineSegment seg = segment.getSegment();
        Coordinate newVertex = this.segmentUtilities.newVertex(seg, targetStart, targetEnd, this.getPanel().getViewport().getScale(), this.modelRange());
        Geometry oldGeometry = (Geometry)segment.getFeature().getDefaultGeometry();
        Geometry newGeometry = this.geometryEditor.insertVertex(oldGeometry, seg.p0, seg.p1, newVertex);
        return newGeometry;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.getCoordinates().size() == 1 && this.previewSegments.isEmpty()) {
            try {
                Coordinate targetStart = this.modelClickCoordinate();
                Map<Layer, Collection<SimpleFeature>> layerToFeaturesInRangeMap = this.layerToFeaturesInRangeMap();
                Map<Layer, List<SegmentContext>> segmentsOnLayers = this.findSegments(layerToFeaturesInRangeMap, targetStart);
                this.previewSegments.addAll(segmentsOnLayers.values().stream().flatMap(r -> r.stream()).collect(Collectors.toList()));
            }
            catch (NoninvertibleTransformException ex) {
                this.getPanel().getContext().warnUser(ex.toString());
            }
        }
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        List<Coordinate> coordinates = this.getCoordinates();
        GeneralPath path = new GeneralPath();
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        if (!coordinates.isEmpty()) {
            Coordinate targetStart = this.modelClickCoordinate();
            Coordinate targetEnd = this.getTentativeCoordinate();
            for (SegmentContext segment : this.previewSegments) {
                Geometry newGeometry = this.getTransformedGeometry(segment, targetStart, targetEnd);
                path.append(this.getPanel().getJava2DConverter().toShape(newGeometry), false);
            }
        }
        return path;
    }

    private Map<Layer, Collection<SimpleFeature>> layerToFeaturesInRangeMap() throws NoninvertibleTransformException {
        LinkedHashMap<Layer, Collection<SimpleFeature>> layerToFeaturesInRangeMap = new LinkedHashMap<Layer, Collection<SimpleFeature>>();
        for (Layer editableLayer : this.getPanel().getLayerManager().getEditableLayers()) {
            Collection<SimpleFeature> featuresInRange = this.featuresInRange(this.modelClickCoordinate(), editableLayer);
            if (featuresInRange.isEmpty()) continue;
            layerToFeaturesInRangeMap.put(editableLayer, featuresInRange);
        }
        return layerToFeaturesInRangeMap;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_vertex.svg");
    }

    @Override
    public Cursor createCursor() {
        return InsertVertexTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_add.svg").getImage());
    }

    @Override
    protected void mouseLocationChanged(MouseEvent e) {
        if (!this.getCoordinates().isEmpty()) {
            super.mouseLocationChanged(e);
        }
    }

    public static class SegmentUtilities {
        public LineSegment segmentInRange(Geometry geometry, Coordinate target, double modelRange) {
            LineSegment closest = null;
            Collection coordArrays = CoordinateArraySupport.toCoordinateArrays((Geometry)geometry, (boolean)false);
            for (Coordinate[] coordinates : coordArrays) {
                for (int j = 1; j < coordinates.length; ++j) {
                    LineSegment candidate = new LineSegment(coordinates[j - 1], coordinates[j]);
                    if (candidate.distance(target) > modelRange || closest != null && !(candidate.distance(target) < closest.distance(target))) continue;
                    closest = candidate;
                }
            }
            return closest;
        }

        public Coordinate newVertex(LineSegment segment, Coordinate target, double viewportScale) {
            return this.newVertex(segment, target, target, viewportScale, 0.0);
        }

        public Coordinate newVertex(LineSegment segment, Coordinate targetStart, Coordinate targetEnd, double viewportScale, double modelRange) {
            boolean pointWasDragged = targetStart != targetEnd && targetStart.distance(targetEnd) > modelRange;
            Coordinate closestPoint = pointWasDragged ? targetEnd : segment.closestPoint(targetStart);
            CoordUtil.absorbZ(targetStart, closestPoint);
            if (!closestPoint.equals((Object)segment.p0) && !closestPoint.equals((Object)segment.p1)) {
                return closestPoint;
            }
            double threshold = 6.0 / viewportScale;
            if (segment.getLength() < threshold) {
                return CoordUtil.average(segment.p0, segment.p1);
            }
            double offset = 3.0 / viewportScale;
            Coordinate unitVector = closestPoint.equals((Object)segment.p0) ? CoordUtil.divide(CoordUtil.subtract(segment.p1, segment.p0), segment.getLength()) : CoordUtil.divide(CoordUtil.subtract(segment.p0, segment.p1), segment.getLength());
            return CoordUtil.add(closestPoint, CoordUtil.multiply(offset, unitVector));
        }
    }

    private final class SegmentContext {
        private final LineSegment segment;
        private final SimpleFeature feature;
        private final Layer layer;

        SegmentContext(InsertVertexTool insertVertexTool, Layer layer, SimpleFeature feature, LineSegment segment) {
            this.layer = layer;
            this.feature = feature;
            this.segment = segment;
        }

        public SimpleFeature getFeature() {
            return this.feature;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public LineSegment getSegment() {
            return this.segment;
        }
    }
}

