/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.plugin.layer.draft.Draft;
import com.vividsolutions.jump.workbench.ui.plugin.layer.draft.GraphicDrafts;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.jts.JTSSupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class InsertSelectionPlugIn
extends AbstractPlugIn {
    private final GeometryEditor geometryEditor = new GeometryEditor();

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.InsertSelectionPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_duplicate.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer targetLayer = EditingPanel.instanceOf().getCurrentLayer();
        SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
        ArrayList<UndoableCommand> lstCommands = new ArrayList<UndoableCommand>();
        ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
        if (targetLayer == null) {
            throw new Exception("No editable layer selected");
        }
        if (!targetLayer.getFMD().isInsertAllowed()) {
            throw new Exception("Layer is not insertable");
        }
        boolean skippedGeometry = false;
        for (Layer sourceLayer : selectionManager.getLayersWithSelectedItems()) {
            boolean isTargetCadLayer = targetLayer instanceof AbstractCadLayer;
            boolean isSourceBasicLayer = sourceLayer.getClass().equals(Layer.class);
            ArrayList<SimpleFeature> lstNewFeatures = new ArrayList<SimpleFeature>();
            ArrayList<SimpleFeature> lstOldFeatures = new ArrayList<SimpleFeature>();
            for (SimpleFeature featureWithSelections : selectionManager.getFeaturesWithSelectedItems(sourceLayer)) {
                Geometry sourceGeometry = (Geometry)featureWithSelections.getDefaultGeometry();
                if (this.isFeatureOnTargetLayerAllowed(sourceGeometry, targetLayer)) {
                    Draft selectedDraft = EditingPanel.instanceOf().getSelectedDraft();
                    SimpleFeature newFeature = GraphicDrafts.createFeatureFromDraft(targetLayer, selectedDraft, sourceGeometry, featureWithSelections);
                    Geometry filteredGeometry = this.geometryEditor.simplify(selectionManager.filterGeometryIfNecessary(sourceLayer, featureWithSelections));
                    if (targetLayer instanceof RedlineLayer && sourceLayer instanceof RedlineLayer) {
                        RedlineLayerUtils.addSymbolAndFillIfNecessary(targetLayer, (AbstractCadLayer)sourceLayer, featureWithSelections);
                    }
                    if (isTargetCadLayer && isSourceBasicLayer) {
                        String strText = InsertSelectionPlugIn.getTextForFeature(sourceLayer, featureWithSelections);
                        if (StringUtils.isNotBlank((CharSequence)strText)) {
                            FeatureUtil.setAttribute((SimpleFeature)newFeature, (String)CadFeatureAtts.TEXT.getName(), (Object)strText);
                        }
                        JTSSupport.splitGeometryCollections((Geometry)filteredGeometry).forEach(flatGeometry -> {
                            SimpleFeature newFeat2Add = FeatureUtil.cloneFeature((SimpleFeature)newFeature, (boolean)true);
                            newFeat2Add.setDefaultGeometry(flatGeometry);
                            lstNewFeatures.add(newFeat2Add);
                        });
                        lstOldFeatures.add(featureWithSelections);
                        continue;
                    }
                    newFeature.setDefaultGeometry((Object)filteredGeometry);
                    if (filteredGeometry.isEmpty()) continue;
                    lstNewFeatures.add(newFeature);
                    lstOldFeatures.add(featureWithSelections);
                    continue;
                }
                skippedGeometry = true;
            }
            lstCommands.add(this.createAddDeleteCommand(targetLayer, sourceLayer, lstOldFeatures, lstNewFeatures));
            lstFeatures.addAll(lstNewFeatures);
        }
        selectionManager.clear();
        selectionManager.getFeatureSelection().selectItems(targetLayer, lstFeatures);
        InsertSelectionPlugIn.execute(lstCommands, (LayerManagerProxy)context, this.isUndoable());
        SaveLayerFeatureChangesPlugIn.commitLayer(targetLayer, true, false, false);
        if (skippedGeometry) {
            GUISupport.msgbox((Component)context.getWorkbenchFrame(), (String)I18N.get("ui.cursortool.editing.InsertSelectionPlugIn.geometries-ignored"), (String)I18N.get("common.message"));
        }
        return true;
    }

    private boolean isFeatureOnTargetLayerAllowed(Geometry sourceGeometry, Layer targetLayer) {
        if (!(targetLayer instanceof AbstractCadLayer) && targetLayer.getFMD().getRestrictGeomType()) {
            for (Class<?> arrGeomClasse : targetLayer.getFMD().getGeomTypes()) {
                if (!arrGeomClasse.isInstance(sourceGeometry)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    private static String getTextForFeature(Layer ly, SimpleFeature feat) {
        ColorThemingStyleModel thStyle;
        LayerStyleCollection sCol = ly.getValidLayerStyleCollection();
        if (sCol == null) {
            return null;
        }
        BasicStyleModel basStyle = sCol.getBasicStyle();
        if (basStyle == null) {
            return null;
        }
        if (!basStyle.isEnabled() && (basStyle = ((ColorThemingRenderer)(thStyle = sCol.getStyle(ColorThemingStyleModel.class)).getIntelligence()).getStyle(feat)) == null) {
            return null;
        }
        if (!basStyle.isRenderingText()) {
            return null;
        }
        if (basStyle.isRenderingSymbol()) {
            return null;
        }
        TextStyleModel txtStyle = basStyle.getTextStyle();
        if (txtStyle == null) {
            return null;
        }
        return ((TextRenderer)txtStyle.getIntelligence()).getTextForFeature(feat);
    }

    private UndoableCommand createAddDeleteCommand(final Layer ly, final Layer lySel, final List<SimpleFeature> lstOldFeatures, final List<SimpleFeature> lstNewFeatures) {
        return new UndoableCommand(this, "AddDeleteFromRedline"){

            @Override
            public void execute() {
                if (lySel instanceof RedlineLayer && lySel.isEditable()) {
                    lySel.editFeature(lstOldFeatures, 3);
                }
                if (lySel instanceof RedlineLayer && ly instanceof RedlineLayer) {
                    AbstractCadLayer rly = (AbstractCadLayer)ly;
                    try {
                        rly.setUseDefaultFeature(false);
                        rly.editFeature(lstNewFeatures, 1);
                    }
                    finally {
                        rly.setUseDefaultFeature(true);
                    }
                } else {
                    ly.editFeature(lstNewFeatures, 1);
                }
            }

            @Override
            public void unexecute() {
                if (lySel instanceof RedlineLayer) {
                    AbstractCadLayer rly = (AbstractCadLayer)lySel;
                    try {
                        rly.setUseDefaultFeature(false);
                        rly.editFeature(lstOldFeatures, 1);
                    }
                    finally {
                        rly.setUseDefaultFeature(true);
                    }
                }
                ly.editFeature(lstNewFeatures, 3);
            }
        };
    }

    @Override
    public EnableCheck createEnableCheck() {
        return component -> {
            String strCheck = EditingPanel.instanceOf().getAllLayerEnableCheck().check(component);
            if (strCheck != null) {
                return strCheck;
            }
            boolean isEmpty = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().isEmpty();
            if (!isEmpty) {
                return null;
            }
            return "At least one item has to be selected";
        };
    }
}

