/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.layer.draft.Draft;
import com.vividsolutions.jump.workbench.ui.plugin.layer.draft.GraphicDrafts;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.highdpi.HighDpiCursorSupport;
import java.awt.Color;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureDrawingUtil {
    private static final GeometryEditor editor = new GeometryEditor();
    private static final Cursor EDIT_CURSOR = GUIUtil.createCursor(IconLoader.svgIconCursortool((String)"cursor_edit.svg").getImage(), HighDpiCursorSupport.getMouseSize32HotSpot((int)5, (int)26), "edit cursor");

    private static Collection<SimpleFeature> selectedFeaturesContaining(Polygon polygon, LayerViewPanel panel) {
        if (EditingPanel.instanceOf().getCurrentLayer() == null) {
            return new ArrayList<SimpleFeature>();
        }
        ArrayList<SimpleFeature> selectedFeaturesContainingPolygon = new ArrayList<SimpleFeature>();
        for (SimpleFeature feature : panel.getSelectionManager().getFeaturesWithSelectedItems(EditingPanel.instanceOf().getCurrentLayer())) {
            if (feature.getDefaultGeometry() == null || feature.getDefaultGeometry().getClass() == GeometryCollection.class || !((Geometry)feature.getDefaultGeometry()).getEnvelopeInternal().contains(polygon.getEnvelopeInternal()) || !((Geometry)feature.getDefaultGeometry()).contains((Geometry)polygon)) continue;
            selectedFeaturesContainingPolygon.add(feature);
        }
        return selectedFeaturesContainingPolygon;
    }

    private static void createHole(Polygon hole, Collection<SimpleFeature> features, Layer layer, LayerViewPanel panel, boolean rollingBackInvalidEdits, String transactionName) {
        Assert.isTrue((hole.getNumInteriorRing() == 0 ? 1 : 0) != 0);
        EditTransaction transaction = new EditTransaction(features, transactionName, layer, rollingBackInvalidEdits, false, panel);
        for (int i = 0; i < transaction.size(); ++i) {
            transaction.setGeometry(i, transaction.getGeometry(i).difference((Geometry)hole));
        }
        transaction.commit();
    }

    private FeatureDrawingUtil() {
    }

    public static Layer layer() {
        return EditingPanel.instanceOf().getCurrentLayer();
    }

    public static boolean insertsUndoable() {
        return FeatureDrawingUtil.layer() instanceof RedlineLayer;
    }

    public static UndoableCommand createAddCommand(SimpleFeature feature, boolean rollingBackInvalidEdits, LayerViewPanel layerViewPanel, AbstractCursorTool tool) {
        return FeatureDrawingUtil.createAddCommand(feature, rollingBackInvalidEdits, layerViewPanel, FeatureDrawingUtil.layer(), tool.getName(), false);
    }

    public static UndoableCommand createAddCommand(SimpleFeature feature, boolean rollingBackInvalidEdits, final LayerViewPanel layerViewPanel, final Layer layer, String strName, final boolean selectNewFeatures) {
        try {
            if (rollingBackInvalidEdits && !((Geometry)feature.getDefaultGeometry()).isValid()) {
                layerViewPanel.getContext().warnUser(I18N.get("ui.cursortool.editing.FeatureDrawingUtil.draw-feature-tool-topology-error"));
                return UndoableCommand.empty(strName);
            }
            if (layer == null) {
                layerViewPanel.getContext().warnUser(I18N.get("ui.cursortool.editing.FeatureDrawingUtil.no-layer-is-editable"));
                return UndoableCommand.empty(strName);
            }
            editor.removeRepeatedPoints((Geometry)feature.getDefaultGeometry());
            final ArrayList<SimpleFeature> lstFeature = new ArrayList<SimpleFeature>();
            lstFeature.add(feature);
            return new UndoableCommand(strName){

                @Override
                public void execute() {
                    layer.editFeature(lstFeature, 1);
                    if (selectNewFeatures) {
                        layerViewPanel.getSelectionManager().clear();
                        layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(layer, lstFeature);
                    }
                }

                @Override
                public void unexecute() {
                    layer.editFeature(lstFeature, 3);
                }
            };
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere();
            return UndoableCommand.empty(strName);
        }
    }

    public static UndoableCommand createAddCommand(Geometry geometry, boolean rollingBackInvalidEdits, LayerViewPanel layerViewPanel, AbstractCursorTool tool) {
        return FeatureDrawingUtil.createAddCommand(geometry, rollingBackInvalidEdits, layerViewPanel, tool.getName());
    }

    public static UndoableCommand createAddCommand(Geometry geometry, boolean rollingBackInvalidEdits, LayerViewPanel layerViewPanel, String strName) {
        return FeatureDrawingUtil.createAddCommand(geometry, rollingBackInvalidEdits, layerViewPanel, FeatureDrawingUtil.layer(), strName);
    }

    public static UndoableCommand createAddCommand(Geometry geometry, boolean rollingBackInvalidEdits, LayerViewPanel layerViewPanel, Layer layer, String strName) {
        return FeatureDrawingUtil.createAddCommand(geometry, rollingBackInvalidEdits, layerViewPanel, layer, strName, false);
    }

    public static UndoableCommand createAddCommand(Geometry geometry, boolean rollingBackInvalidEdits, final LayerViewPanel layerViewPanel, final Layer layer, String strName, final boolean selectNewFeatures) {
        try {
            if (rollingBackInvalidEdits && !geometry.isValid()) {
                layerViewPanel.getContext().warnUser(I18N.get("ui.cursortool.editing.FeatureDrawingUtil.draw-feature-tool-topology-error"));
                return UndoableCommand.empty(strName);
            }
            if (layer == null) {
                layerViewPanel.getContext().warnUser(I18N.get("ui.cursortool.editing.FeatureDrawingUtil.no-layer-is-editable"));
                return UndoableCommand.empty(strName);
            }
            Draft selectedDraft = EditingPanel.instanceOf().getSelectedDraft();
            Geometry finalGeometry = editor.removeRepeatedPoints(geometry);
            SimpleFeature feature = GraphicDrafts.createFeatureFromDraft(layer, selectedDraft, finalGeometry, null);
            final ArrayList<SimpleFeature> lstFeature = new ArrayList<SimpleFeature>();
            lstFeature.add(feature);
            return new UndoableCommand(strName){

                @Override
                public void execute() {
                    layer.editFeature(lstFeature, 1);
                    if (selectNewFeatures) {
                        layerViewPanel.getSelectionManager().clear();
                        layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(layer, lstFeature);
                    }
                }

                @Override
                public void unexecute() {
                    layer.editFeature(lstFeature, 3);
                }
            };
        }
        catch (Exception e) {
            WorkbenchFrame.handleThrowable(e, WorkbenchContext.getFrame());
            return UndoableCommand.empty(strName);
        }
    }

    public static CursorTool prepare(final AbstractCursorTool drawFeatureTool, boolean allowSnapping) {
        drawFeatureTool.setColor(Color.BLUE);
        if (allowSnapping) {
            drawFeatureTool.allowSnapping();
        }
        return new DelegatingTool(drawFeatureTool){
            private Cursor cursorTool;
            {
                super(cursorTool);
                this.cursorTool = null;
            }

            @Override
            public String getName() {
                return drawFeatureTool.getName();
            }

            @Override
            public Cursor getCursor() {
                if (this.cursorTool == null) {
                    this.cursorTool = FeatureDrawingUtil.createEditCursor();
                }
                return this.cursorTool;
            }
        };
    }

    public static Cursor createEditCursor() {
        return EDIT_CURSOR;
    }

    public static void drawRing(Polygon polygon, boolean rollingBackInvalidEdits, AbstractCursorTool tool, LayerViewPanel panel) {
        Collection<SimpleFeature> selectedFeaturesContainingPolygon = FeatureDrawingUtil.selectedFeaturesContaining(polygon, panel);
        if (selectedFeaturesContainingPolygon.isEmpty()) {
            AbstractPlugIn.execute(FeatureDrawingUtil.createAddCommand((Geometry)polygon, rollingBackInvalidEdits, panel, tool), (LayerManagerProxy)panel, tool.isUndoable());
        } else {
            FeatureDrawingUtil.createHole(polygon, selectedFeaturesContainingPolygon, FeatureDrawingUtil.layer(), panel, rollingBackInvalidEdits, tool.getName());
        }
    }
}

