/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.qa.ValidationError;
import com.vividsolutions.jump.qa.Validator;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ExplodeSelectedFeaturesPlugIn
extends AbstractPlugIn {
    private final GeometryEditor geometryEditor = new GeometryEditor();
    private final Supplier<EditingPanel> editingPanel;
    private final Supplier<EnableCheckFactory> enableCheckFactory;
    private final Supplier<WorkbenchContext> workbenchContext;
    private final BiConsumer<JFrame, String> errorPopup;

    public ExplodeSelectedFeaturesPlugIn() {
        this.editingPanel = EditingPanel::instanceOf;
        this.enableCheckFactory = EnableCheckFactory::getInstance;
        this.workbenchContext = WorkbenchContext::getInstance;
        this.errorPopup = (parent, message) -> JOptionPane.showMessageDialog(parent, message, I18N.get("common.error"), 0);
    }

    public ExplodeSelectedFeaturesPlugIn(Supplier<EditingPanel> editingPanel, Supplier<EnableCheckFactory> enableCheckFactory, Supplier<WorkbenchContext> workbenchContext, BiConsumer<JFrame, String> errorPopup) {
        this.editingPanel = editingPanel;
        this.enableCheckFactory = enableCheckFactory;
        this.workbenchContext = workbenchContext;
        this.errorPopup = errorPopup;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
        try {
            Layer targetLayer = this.editingPanel.get().getCurrentLayer();
            ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
            for (Layer sourceLayer : selectionManager.getLayersWithSelectedItems()) {
                transactions.addAll(this.createTransaction(sourceLayer, targetLayer, context));
            }
            return EditTransaction.commit(transactions, () -> {
                for (EditTransaction transaction : transactions) {
                    selectionManager.getFeatureSelection().selectItems(transaction.getLayer(), this.newFeatures(transaction));
                }
            });
        }
        catch (ExplosionFailedException e) {
            this.errorPopup.accept(context.getWorkbenchFrame(), e.getMessage());
            return false;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().handleThrowable(e);
            return false;
        }
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.ExplodeSelectedFeaturesPlugIn.name");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"geometry_explode.svg");
    }

    private Collection<SimpleFeature> newFeatures(EditTransaction transaction) {
        ArrayList<SimpleFeature> newFeatures = new ArrayList<SimpleFeature>();
        for (int i = 0; i < transaction.size(); ++i) {
            if (transaction.getGeometry(i).isEmpty()) continue;
            newFeatures.add(transaction.getFeature(i));
        }
        return newFeatures;
    }

    private List<EditTransaction> createTransaction(Layer sourceLayer, Layer targetLayer, PlugInContext context) {
        Collection<SimpleFeature> multiGeomFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(sourceLayer);
        this.validateSelectedFeatures(multiGeomFeatures);
        if (sourceLayer == targetLayer) {
            return this.explodeToSameLayer(multiGeomFeatures, sourceLayer, context);
        }
        return this.explodeToDifferentLayer(multiGeomFeatures, sourceLayer, targetLayer, context);
    }

    private void validateSelectedFeatures(Collection<SimpleFeature> multiGeomFeatures) {
        Validator validator = new Validator();
        Collection<ValidationError> errors = validator.validate(multiGeomFeatures);
        if (!errors.isEmpty()) {
            throw new ExplosionFailedException(I18N.get("ui.plugin.ExplodeSelectedFeaturesPlugIn.error-selection-invalid-geometries"));
        }
    }

    private List<EditTransaction> explodeToSameLayer(Collection<SimpleFeature> multiGeomFeatures, Layer layer, PlugInContext context) {
        if (!layer.getFMD().isInsertAllowed()) {
            throw new ExplosionFailedException(I18N.getMessage("ui.plugin.ExplodeSelectedFeaturesPlugIn.error-target-layer-must-be-insertable", layer));
        }
        EditTransaction transaction = new EditTransaction(multiGeomFeatures, this.getName(), layer, this.isRollingBackInvalidEdits(context), true, context.getLayerViewPanel());
        for (SimpleFeature feature : multiGeomFeatures) {
            List<Geometry> geometries = this.geometryEditor.flatten((Geometry)feature.getDefaultGeometry());
            for (int geoIdx = 0; geoIdx < geometries.size(); ++geoIdx) {
                Geometry singleGeometry = geometries.get(geoIdx);
                this.failIfGeometryTypeIsNotAllowedOnLayer(layer, singleGeometry);
                if (geoIdx == 0) {
                    transaction.setGeometry(feature, singleGeometry);
                    continue;
                }
                SimpleFeature explodedFeature = FeatureUtil.cloneFeature((SimpleFeature)feature, (boolean)true);
                explodedFeature.setDefaultGeometry((Object)singleGeometry);
                transaction.createFeature(explodedFeature);
            }
        }
        return Collections.singletonList(transaction);
    }

    private List<EditTransaction> explodeToDifferentLayer(Collection<SimpleFeature> multiGeomFeatures, Layer sourceLayer, Layer targetLayer, PlugInContext context) {
        if (!targetLayer.getFMD().isInsertAllowed()) {
            throw new ExplosionFailedException(I18N.getMessage("ui.plugin.ExplodeSelectedFeaturesPlugIn.error-target-layer-must-be-insertable", targetLayer));
        }
        EditTransaction createOnTargetTransaction = new EditTransaction(Collections.emptyList(), this.getName(), targetLayer, this.isRollingBackInvalidEdits(context), true, context.getLayerViewPanel());
        boolean targetIsRedlineLayer = this.isRedlineLayer(targetLayer);
        for (SimpleFeature feature : multiGeomFeatures) {
            List<Geometry> geometries = this.geometryEditor.flatten((Geometry)feature.getDefaultGeometry());
            for (Geometry singleGeometry : geometries) {
                this.failIfGeometryTypeIsNotAllowedOnLayer(targetLayer, singleGeometry);
                SimpleFeature explodedFeature = FeatureUtil.createFeature((SimpleFeatureType)targetLayer.getFeatureType());
                if (targetIsRedlineLayer) {
                    ((RedlineLayer)targetLayer).copyDefaultStyleToFeature(explodedFeature);
                }
                FeatureUtil.copyFeatureData((SimpleFeature)feature, (SimpleFeature)explodedFeature);
                explodedFeature.setDefaultGeometry((Object)singleGeometry);
                createOnTargetTransaction.createFeature(explodedFeature);
            }
        }
        if (this.isEditableRedlineLayer(sourceLayer)) {
            EditTransaction deleteOnSourceTransaction = new EditTransaction(Collections.emptyList(), this.getName(), sourceLayer, this.isRollingBackInvalidEdits(context), true, context.getLayerViewPanel());
            for (SimpleFeature feature : multiGeomFeatures) {
                deleteOnSourceTransaction.deleteFeature(feature);
            }
            return List.of(deleteOnSourceTransaction, createOnTargetTransaction);
        }
        return Collections.singletonList(createOnTargetTransaction);
    }

    private boolean isRedlineLayer(Layer layer) {
        return layer instanceof RedlineLayer;
    }

    private boolean isEditableRedlineLayer(Layer layer) {
        return this.isRedlineLayer(layer) && layer.isEditable() && layer.getFMD().isDeleteAllowed();
    }

    private void failIfGeometryTypeIsNotAllowedOnLayer(Layer targetLayer, Geometry singleGeometry) {
        if (targetLayer.getFMD().isGeometryAllowed(singleGeometry.getClass())) {
            return;
        }
        throw new ExplosionFailedException(I18N.getMessage("ui.plugin.ExplodeSelectedFeaturesPlugIn.error-geometry-type-on-layer-not-allowed", singleGeometry.getGeometryType(), targetLayer));
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = this.enableCheckFactory.get();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1)).add(component -> {
            Layer targetLayer = this.editingPanel.get().getCurrentLayer();
            if (targetLayer == null) {
                return I18N.getMessage("ui.plugin.ExplodeSelectedFeaturesPlugIn.no-editable-layers", targetLayer);
            }
            if (!targetLayer.getFMD().isInsertAllowed()) {
                return I18N.getMessage("ui.plugin.ExplodeSelectedFeaturesPlugIn.error-target-layer-must-be-insertable", targetLayer);
            }
            SelectionManager selectionManager = this.workbenchContext.get().getLayerViewPanel().getSelectionManager();
            Collection<SimpleFeature> featuresWithSelectedItems = selectionManager.getFeaturesWithSelectedItems();
            for (SimpleFeature feature : featuresWithSelectedItems) {
                if (feature.getDefaultGeometry() instanceof GeometryCollection) continue;
                return I18N.get("ui.plugin.ExplodeSelectedFeaturesPlugIn.error-selection-geometry-collection-only");
            }
            return null;
        });
    }

    static class ExplosionFailedException
    extends RuntimeException {
        public ExplosionFailedException(String message) {
            super(message);
        }
    }
}

