/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.COpt;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerableComparator;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckable;
import com.vividsolutions.jump.workbench.ui.DesktopPanelTabPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Priorizable;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NamedCursorToolAssistentPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditableLayersComboBox;
import com.vividsolutions.jump.workbench.ui.layertree.LegendLabelPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.plugin.layer.draft.Draft;
import com.vividsolutions.jump.workbench.ui.plugin.layer.draft.GraphicDrafts;
import com.vividsolutions.jump.workbench.ui.plugin.layer.draft.UpdateDraftsPlugIn;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPanel;
import de.riwagis.guitools.Tasks;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;

public class EditingPanel
extends JPanel
implements ViewportListener,
LayerListener,
DesktopPanelTabPanel,
EnableCheckable,
Priorizable {
    private final LayerableComparator layerableComparator = new LayerableComparator(true);
    private static final String BB_KEY_DEFAULT_EDITING_LAYER = "DEFAULT_EDITING_LAYER";
    private static EditingPanel editingPanel = null;
    private TaskFrame frmTask = null;
    private Task task = null;
    private Layer ly = null;
    private final List<Layer> lstEditLy = Collections.synchronizedList(new ArrayList());
    private final List<Layer> lstInsLy = Collections.synchronizedList(new ArrayList());
    private final List<Layer> lstDelLy = Collections.synchronizedList(new ArrayList());
    private boolean bolBlockEvents = false;
    private final Map<String, ToolboxPanel> mapToolbox = new LinkedHashMap<String, ToolboxPanel>();
    private final Map<String, JPanel> mapPanel = new LinkedHashMap<String, JPanel>();
    private JPanel currentCTPanel = null;
    private final Collection<ActionListener> lstDigiLayerChangedListeners = new ArrayList<ActionListener>();
    private final ActionListener cursorToolChangedListener = e -> {
        CursorTool ct = (CursorTool)e.getSource();
        JPanel pnlTool = ct.getAssistentPanel();
        if (this.labelTextByPanelName(pnlTool)) {
            this.getLblToolName().setText(((NamedCursorToolAssistentPanel)((Object)pnlTool)).getAssistentName());
        } else {
            this.getLblToolName().setText(ct.getName());
        }
        this.activatePanel(pnlTool);
    };
    private final Map<Layer, Draft> selectedDraftPerLayer = new HashMap<Layer, Draft>();
    private JComboBox<Draft> cmbDraft;
    private JComboBox<Object> cmbLayer;
    private JComboBox<Integer> cmbScale;
    private JComboBox<CadLayer.InternalLayer> cmbThemes;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblDraft;
    private JLabel lblLayer;
    private JLabel lblScale;
    private JLabel lblTheme;
    private JLabel lblToolName;
    private LegendLabelPanel legendLabelPanel1;
    private JPanel pnlAssist;
    private JPanel pnlDraftAndRefresh;
    private ToolboxPanel pnlDraftToolbox;
    private JPanel pnlLayer;
    private ToolboxPanel pnlStaticTools;
    private JScrollPane spAssist;
    private JXTaskPaneContainer taskPaneContainer;
    private final EnableCheck ecInternalFrame = component -> {
        if (!(JUMPWorkbench.getFrame().getActiveInternalFrame() instanceof SelectionManagerProxy)) {
            return "A window with a selection manager must be active";
        }
        if (this.frmTask == null || this.frmTask.getLayerViewPanel() == null || this.frmTask.getLayerViewPanel().getSelectionManager() == null) {
            return "A window with a selection manager must be active";
        }
        return null;
    };
    private final EnableCheck ecWrite = component -> {
        String strCheck = this.ecInternalFrame.check(component);
        if (strCheck != null) {
            return strCheck;
        }
        boolean bolFeaturesFound = false;
        List<Layer> list = this.lstEditLy;
        synchronized (list) {
            for (Layer ly2test : this.lstEditLy) {
                if (!ly2test.hasEditedFeatures()) continue;
                bolFeaturesFound = true;
                break;
            }
        }
        if (bolFeaturesFound) {
            return null;
        }
        return "No edited features found.";
    };
    private final EnableCheck ecAllLayer = component -> {
        String strCheck = this.ecInternalFrame.check(component);
        if (strCheck != null) {
            return strCheck;
        }
        if (this.ly != null) {
            return null;
        }
        return I18N.get("ui.cursortool.editing.EditingPanel.one-layer-must-be-editable");
    };
    private final EnableCheck ecLayer = component -> {
        String strCheck = this.ecInternalFrame.check(component);
        if (strCheck != null) {
            return strCheck;
        }
        if (this.ly != null) {
            if (this.ly instanceof DimLayer) {
                return I18N.get("ui.cursortool.editing.EditingPanel.dim-layer-not-allowed");
            }
            return null;
        }
        return I18N.get("ui.cursortool.editing.EditingPanel.one-layer-must-be-editable");
    };
    private final EnableCheck ecDimLayer = component -> {
        String strCheck = this.ecInternalFrame.check(component);
        if (strCheck != null) {
            return strCheck;
        }
        if (this.ly != null) {
            if (this.ly instanceof DimLayer) {
                return null;
            }
            if (this.ly instanceof AbstractCadLayer && CadFeatureAtts.checkStructureSupportsDimensions(this.ly.getFeatureType())) {
                return null;
            }
            return I18N.get("ui.cursortool.editing.EditingPanel.only-dim-layer-allowed");
        }
        return I18N.get("ui.cursortool.editing.EditingPanel.one-layer-must-be-editable");
    };
    private final EnableCheck ecEditSelLayer = component -> {
        String strCheck = this.ecInternalFrame.check(component);
        if (strCheck != null) {
            return strCheck;
        }
        Collection<Layer> colSelLy = this.frmTask.getSelectionManager().getLayersWithSelectedItems();
        boolean bolFound = false;
        List<Layer> list = this.lstEditLy;
        synchronized (list) {
            for (Layer ly2test : this.lstEditLy) {
                if (!colSelLy.contains(ly2test)) continue;
                bolFound = true;
                if (!(ly2test instanceof DimLayer)) continue;
                return I18N.get("ui.cursortool.editing.EditingPanel.one-item-on-layer-must-be-selected");
            }
        }
        if (bolFound) {
            return null;
        }
        return I18N.get("ui.cursortool.editing.EditingPanel.one-item-on-layer-must-be-selected");
    };
    private final EnableCheck ecEditSelAll = component -> {
        String strCheck = this.ecInternalFrame.check(component);
        if (strCheck != null) {
            return strCheck;
        }
        Collection<Layer> colSelLy = this.frmTask.getSelectionManager().getLayersWithSelectedItems();
        List<Layer> list = this.lstEditLy;
        synchronized (list) {
            for (Layer ly2test : this.lstEditLy) {
                if (!colSelLy.contains(ly2test)) continue;
                return null;
            }
        }
        return I18N.get("ui.cursortool.editing.EditingPanel.one-item-on-layer-must-be-selected");
    };
    private final EnableCheck ecEditSelDimLayer = component -> {
        String strCheck = this.ecInternalFrame.check(component);
        if (strCheck != null) {
            return strCheck;
        }
        Collection<Layer> colSelLy = this.frmTask.getSelectionManager().getLayersWithSelectedItems();
        boolean bolFound = false;
        List<Layer> list = this.lstEditLy;
        synchronized (list) {
            for (Layer ly2test : this.lstEditLy) {
                if (!colSelLy.contains(ly2test)) continue;
                bolFound = true;
                if (ly2test instanceof DimLayer || ly2test instanceof AbstractCadLayer) continue;
                return I18N.get("ui.cursortool.editing.EditingPanel.one-item-on-dim-layer-must-be-selected");
            }
        }
        if (bolFound) {
            return null;
        }
        return I18N.get("ui.cursortool.editing.EditingPanel.one-item-on-dim-layer-must-be-selected");
    };
    private final EnableCheck ecDelSel = component -> {
        String strCheck = this.ecInternalFrame.check(component);
        if (strCheck != null) {
            return strCheck;
        }
        int intCount = 0;
        List<Layer> list = this.lstEditLy;
        synchronized (list) {
            for (Layer ly2test : this.lstEditLy) {
                if (ly2test.isDisposed()) continue;
                intCount = ly2test.getFMD().isDeleteAllowed() ? (intCount += this.frmTask.getSelectionManager().getSelectedItems(ly2test).size()) : (intCount += this.frmTask.getSelectionManager().getPartSelection().getSelectedItems(ly2test).size());
                intCount += this.frmTask.getSelectionManager().getLineStringSelection().getSelectedItems(ly2test).size();
            }
        }
        if (intCount > 0) {
            return null;
        }
        return I18N.get("ui.cursortool.editing.EditingPanel.one-item-on-layer-must-be-selected");
    };

    private EditingPanel() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    public void addDigiLayerChangedListener(ActionListener listener) {
        this.lstDigiLayerChangedListeners.add(listener);
    }

    public void removeDigiLayerChangedListener(ActionListener listener) {
        this.lstDigiLayerChangedListeners.remove(listener);
    }

    private void fireDigiLayerChanged() {
        Iterator<ActionListener> i = this.lstDigiLayerChangedListeners.iterator();
        ActionEvent e = new ActionEvent(this, 0, "layer changed");
        while (i.hasNext()) {
            i.next().actionPerformed(e);
        }
    }

    @Override
    public void updateEnabledState() {
        for (String s : this.mapToolbox.keySet()) {
            this.mapToolbox.get(s).updateEnabledState();
        }
        this.pnlStaticTools.updateEnabledState();
        if (this.currentCTPanel instanceof EnableCheckable) {
            ((EnableCheckable)((Object)this.currentCTPanel)).updateEnabledState();
        }
    }

    public static EditingPanel instanceOf() {
        if (editingPanel == null) {
            editingPanel = new EditingPanel();
        }
        return editingPanel;
    }

    private void i18n() {
        this.lblLayer.setText(I18N.get("common.layer"));
        this.lblLayer.setToolTipText(I18N.get("ui.cursortool.editing.EditingPanel.layer-new-features-tooltip"));
        this.lblTheme.setText(I18N.get("ui.cursortool.editing.EditingPanel.theme"));
        this.lblScale.setText(I18N.get("ui.cursortool.editing.EditingPanel.redline-scale"));
        this.lblDraft.setText(I18N.get("ui.cursortool.editing.EditingPanel.draft"));
    }

    private void init() {
        UpdateDraftsPlugIn draftsPlugin = new UpdateDraftsPlugIn();
        this.pnlDraftToolbox.addPlugIn(draftsPlugin, draftsPlugin.createEnableCheck(), draftsPlugin.getIcon());
        this.cmbLayer.setMaximumRowCount(25);
        this.cmbThemes.setMaximumRowCount(25);
        this.cmbScale.addItem(100);
        this.cmbScale.addItem(250);
        this.cmbScale.addItem(500);
        this.cmbScale.addItem(1000);
        this.cmbScale.addItem(2500);
        this.cmbScale.addItem(5000);
        this.cmbScale.addItem(7500);
        this.cmbScale.addItem(10000);
        this.cmbScale.addItem(15000);
        this.cmbScale.addItem(20000);
        this.cmbScale.addItem(25000);
        this.cmbScale.addItem(50000);
        this.cmbScale.setMaximumRowCount(15);
        GUIUtil.addInternalFrameListener(WorkbenchContext.getFrame().getDesktopPane(), new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                JInternalFrame frm = e.getInternalFrame();
                if (frm instanceof TaskFrame) {
                    EditingPanel.this.initWithTaskFrame((TaskFrame)frm);
                }
            }
        });
        this.lblToolName.setText("");
        this.activateDefaultCT();
        this.lblTheme.setVisible(false);
        this.cmbThemes.setVisible(false);
        this.lblScale.setVisible(false);
        this.cmbScale.setVisible(false);
        this.lblDraft.setVisible(false);
        this.pnlDraftAndRefresh.setVisible(false);
        this.legendLabelPanel1.setVisible(false);
    }

    public Layer getCurrentLayer() {
        if (this.ly != null && this.ly.getFMD() == null) {
            return null;
        }
        return this.ly;
    }

    public void setCurrentLayer(Layer ly2set) {
        SwingUtilities.invokeLater(() -> {
            if (this.lstEditLy.contains(ly2set) && ly2set.canBeDigiLayer()) {
                this.ly = ly2set;
                this.refillLayerCombo();
            }
        });
    }

    public void activateDefaultCT() {
        if (this.frmTask != null) {
            WorkbenchContext.getFrame().activateDefaultCT();
        }
    }

    public void activatePanel(JPanel pnl) {
        this.pnlAssist.removeAll();
        this.currentCTPanel = pnl;
        this.labelTextByPanelName(pnl);
        if (pnl != null) {
            this.pnlAssist.add((Component)this.currentCTPanel, "Center");
        }
        this.pnlAssist.validate();
        this.pnlAssist.repaint();
        this.spAssist.validate();
        this.spAssist.repaint();
        this.updateEnabledState();
    }

    private boolean labelTextByPanelName(JPanel pnl) {
        if (pnl instanceof NamedCursorToolAssistentPanel && StringUtils.isNotBlank((CharSequence)((NamedCursorToolAssistentPanel)((Object)pnl)).getAssistentName())) {
            this.lblToolName.setText(((NamedCursorToolAssistentPanel)((Object)pnl)).getAssistentName());
            return true;
        }
        return false;
    }

    public void initWithTaskFrame(TaskFrame newTask) {
        if (this.frmTask != null) {
            if (this.frmTask.getLayerViewPanel() != null) {
                this.frmTask.getLayerViewPanel().removeCursorToolChangedListener(this.cursorToolChangedListener);
                this.frmTask.getLayerViewPanel().getViewport().removeListener(this);
            }
            if (this.frmTask.getTask().getLayerManager() != null) {
                this.frmTask.getTask().getLayerManager().removeLayerListener(this);
            }
        }
        this.ly = null;
        this.frmTask = newTask;
        if (newTask != null) {
            newTask.getLayerViewPanel().addCursorToolChangedListener(this.cursorToolChangedListener);
            newTask.getLayerViewPanel().getViewport().addListener(this);
            this.task = newTask.getTask();
            this.task.getLayerManager().addLayerListener(this);
        } else {
            this.task = null;
        }
        this.refillLayerCombo();
    }

    @Override
    public void featuresChanged(FeatureEvent e) {
    }

    @Override
    public void categoryChanged(CategoryEvent e) {
    }

    @Override
    public void layerChanged(LayerEvent e) {
        if (e.getType() == LayerEventType.VISIBILITY_CHANGED) {
            this.updateLayerPreview();
        } else if (e.getType() == LayerEventType.REMOVED) {
            if (this.ly == e.getLayerable()) {
                this.ly = null;
            }
            this.refillLayerCombo();
        } else if (e.getType() == LayerEventType.ADDED) {
            if (e.getLayerable() instanceof RedlineLayer && ((RedlineLayer)e.getLayerable()).isEditable()) {
                this.ly = (Layer)e.getLayerable();
            }
            this.refillLayerCombo();
        } else if (e.getType() != LayerEventType.TABLE_DATA_CHANGED) {
            this.refillLayerCombo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refillLayerCombo() {
        this.bolBlockEvents = true;
        try {
            this.cmbLayer.removeAllItems();
            this.lstEditLy.clear();
            this.lstInsLy.clear();
            this.lstDelLy.clear();
            if (this.task == null) {
                return;
            }
            List editableOrderedLayers = this.task.getLayerManager().getLayers().stream().filter(Layer::isEditable).sorted(this.layerableComparator).collect(Collectors.toList());
            Category lastCategory = null;
            Layer selectedFallbackLayer = null;
            for (Layer layer : editableOrderedLayers) {
                FeaturestoreMetadata fmd = layer.getFMD();
                if (layer.canBeDigiLayer()) {
                    lastCategory = this.addCategoryIfChangedToComboBox(lastCategory, layer.getCategory());
                    this.cmbLayer.addItem(layer);
                }
                if (layer.canBeDigiLayer() && layer instanceof RedlineLayer && selectedFallbackLayer == null) {
                    selectedFallbackLayer = layer;
                }
                if (fmd.isInsertAllowed()) {
                    this.lstInsLy.add(layer);
                }
                if (fmd.isDeleteAllowed()) {
                    this.lstDelLy.add(layer);
                }
                this.lstEditLy.add(layer);
            }
            this.selectLayerInComboBox(selectedFallbackLayer);
        }
        finally {
            this.bolBlockEvents = false;
            this.updateLayerPreview();
            this.updateDrafts();
            this.updateEnabledState();
            this.activateDefaultCT();
            this.fireDigiLayerChanged();
        }
    }

    private void selectLayerInComboBox(Layer preferredActiveLayer) {
        if (this.ly != null && this.lstEditLy.contains(this.ly) && this.ly.canBeDigiLayer()) {
            this.cmbLayer.setSelectedItem(this.ly);
        } else if (this.cmbLayer.getItemCount() > 0) {
            if (preferredActiveLayer == null) {
                this.cmbLayer.setSelectedIndex(0);
                this.ly = (Layer)this.cmbLayer.getSelectedItem();
            } else {
                this.cmbLayer.setSelectedItem(preferredActiveLayer);
                this.ly = preferredActiveLayer;
            }
        } else {
            this.ly = null;
        }
    }

    private Category addCategoryIfChangedToComboBox(Category lastCategory, Category currentCategory) {
        if (lastCategory != null && lastCategory == currentCategory) {
            return lastCategory;
        }
        lastCategory = currentCategory;
        StringBuilder sb = new StringBuilder();
        this.getCategoryName(lastCategory, sb);
        this.cmbLayer.addItem(sb.toString());
        return lastCategory;
    }

    private void getCategoryName(Category cat, StringBuilder sb) {
        if (cat.getParentCategory() == null) {
            return;
        }
        if (sb.length() > 0) {
            sb.insert(0, ",");
        }
        sb.insert(0, cat.getName());
        this.getCategoryName(cat.getParentCategory(), sb);
    }

    private synchronized void addToolbox(String strName) {
        if (!this.mapToolbox.containsKey(strName)) {
            this.mapToolbox.put(strName, new ToolboxPanel());
            this.mapPanelOrMapToolbox_changed();
        }
    }

    private synchronized void addPanel(String strName, JPanel panel) {
        if (!this.mapPanel.containsKey(strName)) {
            this.mapPanel.put(strName, panel);
            this.mapPanelOrMapToolbox_changed();
        }
    }

    public ToolboxPanel getStaticToolboxPanel() {
        return this.pnlStaticTools;
    }

    public ToolboxPanel getToolboxPanel(String strName) {
        this.addToolbox(strName);
        return this.mapToolbox.get(strName);
    }

    public void addSlideoutPanel(String strName, JPanel pnlSlideout) {
        this.addPanel(strName, pnlSlideout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapPanelOrMapToolbox_changed() {
        this.bolBlockEvents = true;
        try {
            this.taskPaneContainer.removeAll();
            VerticalLayout verticalLayout = new VerticalLayout();
            verticalLayout.setGap(1);
            this.taskPaneContainer.setLayout((LayoutManager)verticalLayout);
            for (String strTitle : this.mapPanel.keySet()) {
                JXTaskPane taskPane = new JXTaskPane();
                taskPane.setForeground(Color.black);
                taskPane.setTitle(strTitle);
                taskPane.setCollapsed(true);
                JXPanel taskPanel = (JXPanel)taskPane.getContentPane();
                taskPanel.setOpaque(false);
                taskPanel.add((Component)this.mapPanel.get(strTitle));
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createEmptyBorder(0, 0, 0, 0));
                taskPanel.setBorder((Border)compoundBorder);
                this.taskPaneContainer.add((Component)taskPane);
            }
            Iterator<String> iTb = this.mapToolbox.keySet().iterator();
            int counter = 0;
            while (iTb.hasNext()) {
                String strTitle = iTb.next();
                JXTaskPane taskPane = new JXTaskPane();
                taskPane.setForeground(Color.black);
                taskPane.setTitle(strTitle);
                taskPane.setCollapsed(counter != 0);
                JXPanel taskPanel = (JXPanel)taskPane.getContentPane();
                taskPanel.setOpaque(false);
                taskPanel.add((Component)this.mapToolbox.get(strTitle));
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createEmptyBorder(0, 0, 0, 0));
                taskPanel.setBorder((Border)compoundBorder);
                this.taskPaneContainer.add((Component)taskPane);
                ++counter;
            }
            this.updateEnabledState();
        }
        finally {
            this.bolBlockEvents = false;
        }
    }

    public EnableCheck getFeatures2WriteCheck() {
        return this.ecWrite;
    }

    public EnableCheck getLayerEnableCheck() {
        return this.ecLayer;
    }

    public EnableCheck getDimLayerEnableCheck() {
        return this.ecDimLayer;
    }

    public EnableCheck getAllLayerEnableCheck() {
        return this.ecAllLayer;
    }

    public EnableCheck getInternalFrameActiveCheck() {
        return this.ecInternalFrame;
    }

    public EnableCheck getEditSelectionLayerEnableCheck() {
        return this.ecEditSelLayer;
    }

    public EnableCheck getEditSelectionDimLayerEnableCheck() {
        return this.ecEditSelDimLayer;
    }

    public EnableCheck getEditSelectionAllLayerEnableCheck() {
        return this.ecEditSelAll;
    }

    public EnableCheck getDeleteSelectionEnableCheck() {
        return this.ecDelSel;
    }

    public EnableCheck getGeometryTypeCheck(Class<?>[] arrCls) {
        return component -> {
            String strCheck = this.ecInternalFrame.check(component);
            if (strCheck != null) {
                return strCheck;
            }
            strCheck = this.ecLayer.check(component);
            if (strCheck != null) {
                return strCheck;
            }
            if (this.ly == null || this.ly.isDisposed()) {
                return I18N.get("ui.cursortool.editing.EditingPanel.one-layer-must-be-editable");
            }
            if (this.ly instanceof DimLayer) {
                return I18N.get("ui.cursortool.editing.EditingPanel.dim-layer-not-allowed");
            }
            for (Class arrCl : arrCls) {
                if (this.ly.getFMD().isGeometryAllowed(arrCl)) continue;
                return "Geometry type is not allowed for this layer";
            }
            return null;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Layer> getLayersWithSelection() {
        ArrayList<Layer> lstSelLy = new ArrayList<Layer>();
        if (this.ly != null && this.frmTask != null) {
            List<Layer> list = this.lstEditLy;
            synchronized (list) {
                for (Layer ly2test : this.lstEditLy) {
                    int intCount = this.frmTask.getLayerViewPanel().getSelectionManager().getSelectedItems(ly2test).size();
                    if (intCount <= 0) continue;
                    lstSelLy.add(ly2test);
                }
            }
        }
        return lstSelLy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Layer> getEditableLayers() {
        List<Layer> list = this.lstEditLy;
        synchronized (list) {
            return new ArrayList<Layer>(this.lstEditLy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Layer> getInsertLayers() {
        List<Layer> list = this.lstInsLy;
        synchronized (list) {
            return new ArrayList<Layer>(this.lstInsLy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Layer> getDeleteLayers() {
        List<Layer> list = this.lstDelLy;
        synchronized (list) {
            return new ArrayList<Layer>(this.lstDelLy);
        }
    }

    private void initComponents() {
        this.pnlStaticTools = new ToolboxPanel();
        this.pnlLayer = new JPanel();
        this.cmbLayer = new EditableLayersComboBox();
        this.lblLayer = new JLabel();
        this.lblTheme = new JLabel();
        this.cmbThemes = new JComboBox();
        this.legendLabelPanel1 = new LegendLabelPanel();
        this.lblScale = new JLabel();
        this.cmbScale = new JComboBox();
        this.lblDraft = new JLabel();
        this.pnlDraftAndRefresh = new JPanel();
        this.cmbDraft = new JComboBox();
        this.pnlDraftToolbox = new ToolboxPanel();
        this.spAssist = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.taskPaneContainer = new JXTaskPaneContainer();
        this.lblToolName = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.pnlAssist = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.setName("EDITING_PANEL");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                EditingPanel.this.this_componentResized(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.add((Component)this.pnlStaticTools, gridBagConstraints);
        this.pnlLayer.setLayout(new GridBagLayout());
        this.cmbLayer.setFont(this.cmbLayer.getFont());
        this.cmbLayer.setMinimumSize(new Dimension(80, 22));
        this.cmbLayer.setPreferredSize(new Dimension(80, 22));
        this.cmbLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditingPanel.this.cmbLayer_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLayer.add(this.cmbLayer, gridBagConstraints);
        this.lblLayer.setText("Ebene");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.pnlLayer.add((Component)this.lblLayer, gridBagConstraints);
        this.lblTheme.setText("Thema");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.pnlLayer.add((Component)this.lblTheme, gridBagConstraints);
        this.cmbThemes.setMinimumSize(new Dimension(80, 22));
        this.cmbThemes.setPreferredSize(new Dimension(80, 22));
        this.cmbThemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditingPanel.this.cmbThemes_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLayer.add(this.cmbThemes, gridBagConstraints);
        this.legendLabelPanel1.setLayout(new FlowLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLayer.add((Component)this.legendLabelPanel1, gridBagConstraints);
        this.lblScale.setText("Zeichenma\u00dfstab:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.pnlLayer.add((Component)this.lblScale, gridBagConstraints);
        this.cmbScale.setEditable(true);
        this.cmbScale.setMinimumSize(new Dimension(80, 22));
        this.cmbScale.setPreferredSize(new Dimension(80, 22));
        this.cmbScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditingPanel.this.cmbScale_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLayer.add(this.cmbScale, gridBagConstraints);
        this.lblDraft.setText("Vorlagedatensatz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.pnlLayer.add((Component)this.lblDraft, gridBagConstraints);
        this.pnlDraftAndRefresh.setLayout(new GridBagLayout());
        this.cmbDraft.setMinimumSize(new Dimension(80, 22));
        this.cmbDraft.setPreferredSize(new Dimension(80, 22));
        this.cmbDraft.setRenderer(new DraftRenderer());
        this.cmbDraft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditingPanel.this.cmbDraft_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlDraftAndRefresh.add(this.cmbDraft, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.pnlDraftAndRefresh.add((Component)this.pnlDraftToolbox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlLayer.add((Component)this.pnlDraftAndRefresh, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.pnlLayer, gridBagConstraints);
        this.spAssist.setBorder(null);
        this.spAssist.setHorizontalScrollBarPolicy(31);
        this.spAssist.setMinimumSize(new Dimension(20, 100));
        this.jPanel1.setLayout(new GridBagLayout());
        this.taskPaneContainer.setBackground(new Color(212, 208, 200));
        this.taskPaneContainer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.taskPaneContainer.setOpaque(false);
        this.taskPaneContainer.setScrollableTracksViewportWidth(false);
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.setGap(14);
        this.taskPaneContainer.setLayout((LayoutManager)verticalLayout1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.jPanel1.add((Component)this.taskPaneContainer, gridBagConstraints);
        this.lblToolName.setFont(this.lblToolName.getFont().deriveFont(this.lblToolName.getFont().getStyle() | 1));
        this.lblToolName.setText("Toolname");
        this.lblToolName.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel1.add((Component)this.lblToolName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jSeparator2, gridBagConstraints);
        this.pnlAssist.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.jPanel1.add((Component)this.pnlAssist, gridBagConstraints);
        this.spAssist.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.spAssist, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jSeparator1, gridBagConstraints);
    }

    private void this_componentResized(ComponentEvent evt) {
        Dimension vpSize = this.spAssist.getViewport().getExtentSize();
        this.spAssist.getViewport().setExtentSize(new Dimension(this.getWidth() - 5, (int)vpSize.getHeight()));
    }

    private void cmbLayer_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        this.ly = (Layer)this.cmbLayer.getSelectedItem();
        this.updateEnabledState();
        this.activateDefaultCT();
        this.fireDigiLayerChanged();
        this.updateLayerPreview();
        this.updateDrafts();
    }

    private void cmbScale_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        if (this.ly != null && this.ly instanceof RedlineLayer) {
            int intDrawScale = 1000;
            try {
                intDrawScale = Integer.parseInt(Objects.toString(this.cmbScale.getSelectedItem(), ""));
            }
            catch (Exception e) {
                this.cmbScale.setSelectedItem(1000);
            }
            ((RedlineLayer)this.ly).setDrawScale(intDrawScale);
            this.ly.fireAppearanceChanged();
        }
    }

    private void cmbThemes_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        if (this.ly instanceof CadLayer) {
            CadLayer cly = (CadLayer)this.ly;
            cly.setInternalLayer4NewFeatures((CadLayer.InternalLayer)this.cmbThemes.getSelectedItem());
        }
    }

    private void cmbDraft_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        this.selectedDraftPerLayer.put(this.ly, (Draft)this.cmbDraft.getSelectedItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLayerPreview() {
        this.bolBlockEvents = true;
        try {
            this.lblScale.setVisible(false);
            this.cmbScale.setVisible(false);
            this.lblTheme.setVisible(false);
            this.cmbThemes.setVisible(false);
            this.legendLabelPanel1.setVisible(false);
            if (this.ly == null) {
                return;
            }
            if (this.ly instanceof RedlineLayer) {
                RedlineLayer rly = (RedlineLayer)this.ly;
                int intDrawScale = rly.getDrawScale();
                this.cmbScale.setSelectedItem(intDrawScale);
                this.lblScale.setVisible(true);
                this.cmbScale.setVisible(true);
            } else if (this.ly instanceof CadLayer) {
                CadLayer cly = (CadLayer)this.ly;
                List<CadLayer.InternalLayer> lstIntLy = cly.getInternalLayers();
                this.lblTheme.setVisible(true);
                this.cmbThemes.setVisible(true);
                this.cmbThemes.removeAllItems();
                if (!lstIntLy.isEmpty()) {
                    for (CadLayer.InternalLayer internalLy : lstIntLy) {
                        this.cmbThemes.addItem(internalLy);
                    }
                    CadLayer.InternalLayer internalCadLayer = cly.getInternalLayer4NewFeatures();
                    if (internalCadLayer != null) {
                        this.cmbThemes.setSelectedItem(internalCadLayer);
                    }
                    if (internalCadLayer == null || !Objects.equals(this.cmbThemes.getSelectedItem(), internalCadLayer)) {
                        this.cmbThemes.setSelectedIndex(0);
                        cly.setInternalLayer4NewFeatures(lstIntLy.get(0));
                    }
                } else {
                    cly.setInternalLayer4NewFeatures(null);
                }
            } else {
                this.legendLabelPanel1.setImageForLayerable(this.ly);
                this.legendLabelPanel1.setVisible(true);
            }
        }
        finally {
            this.bolBlockEvents = false;
        }
    }

    public void updateDrafts() {
        boolean draftsPossible;
        boolean bl = draftsPossible = this.ly != null && this.ly.getFMD().isInsertAllowed() && this.ly.getFMD().isAllowGraphicDrafts();
        if (!draftsPossible) {
            this.updateDraftUI(Collections.emptyList());
            return;
        }
        Tasks.submit(() -> {
            if (!GraphicDrafts.hasGraphicDrafts(this.ly)) {
                SwingUtilities.invokeLater(() -> this.updateDraftUI(Collections.emptyList()));
                return;
            }
            Collection<Draft> graphicDrafts = GraphicDrafts.getGraphicDrafts(this.ly);
            SwingUtilities.invokeLater(() -> this.updateDraftUI(graphicDrafts));
        }, false);
    }

    private void updateDraftUI(Collection<Draft> graphicDrafts) {
        this.bolBlockEvents = true;
        try {
            if (!graphicDrafts.isEmpty()) {
                this.cmbDraft.removeAllItems();
                this.cmbDraft.addItem(Draft.NONE);
                graphicDrafts.forEach(this.cmbDraft::addItem);
                this.cmbDraft.setSelectedItem(this.selectedDraftPerLayer.getOrDefault(this.ly, Draft.NONE));
                this.lblDraft.setVisible(true);
                this.pnlDraftAndRefresh.setVisible(true);
            } else {
                this.cmbDraft.setSelectedItem(null);
                this.lblDraft.setVisible(false);
                this.pnlDraftAndRefresh.setVisible(false);
            }
        }
        finally {
            this.bolBlockEvents = false;
        }
    }

    @Override
    public void zoomChanged(Viewport vPort) {
        this.updateLayerPreview();
    }

    private JLabel getLblToolName() {
        return this.lblToolName;
    }

    public void resetToDefault() {
        String layerKey = (String)PersistentBlackboardPlugIn.get().get(BB_KEY_DEFAULT_EDITING_LAYER);
        if (layerKey != null) {
            this.task.getLayerManager().getLayerables().stream().filter(layer -> layer instanceof Layer).map(layer -> (Layer)layer).filter(layer -> layerKey.equals(layer.getKey())).filter(layer -> layer.canBeDigiLayer()).findFirst().ifPresent(layer -> EditingPanel.instanceOf().setCurrentLayer((Layer)layer));
        }
    }

    public void persistDefaultLayer() {
        Layer currentLayer = this.getCurrentLayer();
        if (currentLayer != null) {
            PersistentBlackboardPlugIn.get().put(BB_KEY_DEFAULT_EDITING_LAYER, currentLayer.getKey());
        }
    }

    public Draft getSelectedDraft() {
        if (!this.cmbDraft.isVisible()) {
            return null;
        }
        return (Draft)this.cmbDraft.getSelectedItem();
    }

    @Override
    public int getPriority() {
        if (COpt.VIEWER) {
            return 0;
        }
        return 1000;
    }

    private static class DraftRenderer
    implements ListCellRenderer<Draft> {
        private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private final Font defaultFont = this.defaultRenderer.getFont();
        private final Font italicFont = this.defaultRenderer.getFont().deriveFont(2);

        private DraftRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Draft> list, Draft value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value == Draft.NONE) {
                renderer.setFont(this.italicFont);
                renderer.setText(I18N.get("ui.cursortool.editing.EditingPanel.no-draft"));
                renderer.setToolTipText("");
            } else {
                renderer.setFont(this.defaultFont);
                renderer.setText(value.getName());
                renderer.setToolTipText(Objects.toString(value.getDescription(), ""));
            }
            return renderer;
        }
    }
}

