/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import de.riwagis.icons.IconLoader;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class EditableLayersComboBox
extends JComboBox<Object> {
    private DefaultListCellRenderer lyRenderer = new LayerListCellRenderer();
    public DefaultComboBoxModel<Object> lyModel = new DefaultComboBoxModel<Object>(){

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof Layerable || anObject == null) {
                super.setSelectedItem(anObject);
                return;
            }
            int idx = this.getIndexOf(anObject);
            if ((idx = EditableLayersComboBox.this.findNextLayerIndex(idx)) != -1) {
                anObject = this.getElementAt(idx);
                super.setSelectedItem(anObject);
            }
        }
    };

    public EditableLayersComboBox() {
        this.setRenderer(this.lyRenderer);
        this.setModel(this.lyModel);
    }

    public int findNextLayerIndex(int idx) {
        int i;
        if (this.getItemAt(idx) != null && this.getItemAt(idx) instanceof Layerable) {
            return idx;
        }
        for (i = idx; i < this.getItemCount(); ++i) {
            if (this.getItemAt(i) == null || !(this.getItemAt(i) instanceof Layerable)) continue;
            return i;
        }
        for (i = idx; i >= 0; --i) {
            if (this.getItemAt(i) == null || !(this.getItemAt(i) instanceof Layerable)) continue;
            return i;
        }
        return -1;
    }

    public static final class LayerListCellRenderer
    extends DefaultListCellRenderer {
        private final ImageIcon icoRedline = IconLoader.svgIconSmall((String)"layer_redline.svg");
        private final ImageIcon icoCad = IconLoader.svgIconSmall((String)"layer_cad.svg");
        private final ImageIcon icoGeometry = IconLoader.svgIconSmall((String)"layer_geometry.svg");

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                comp.setEnabled(false);
                return comp;
            }
            if (value instanceof String) {
                Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                comp.setBackground(new Color(61, 61, 61));
                comp.setForeground(Color.WHITE);
                comp.setFont(comp.getFont().deriveFont(1));
                return comp;
            }
            if (value instanceof Layerable) {
                String strValue = ((Layerable)value).getName();
                Component comp = super.getListCellRendererComponent(list, strValue, index, isSelected, cellHasFocus);
                if (value instanceof RedlineLayer) {
                    ((JLabel)comp).setIcon(this.icoRedline);
                } else if (value instanceof CadLayer) {
                    ((JLabel)comp).setIcon(this.icoCad);
                } else {
                    ((JLabel)comp).setIcon(this.icoGeometry);
                }
                return comp;
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

