/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckable;
import com.vividsolutions.jump.workbench.ui.CoordinateFieldsDocumentListener;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DrawPointAtCoordinatePlugIn;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DrawPointTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPanel;
import de.riwagis.util.gui.GUISupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.locationtech.jts.geom.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditPointPanel
extends JPanel
implements EnableCheckable {
    private static final Logger LOG = LoggerFactory.getLogger(EditPointPanel.class);
    public static final String KEY_SET_ROTATION = EditPointPanel.class.getName() + "-KEY_SET_ROTATION";
    public static final String KEY_SET_ROTATION_POINT = EditPointPanel.class.getName() + "-KEY_SET_ROTATION_POINT";
    private final ToolboxPanel pnlToolbox = new ToolboxPanel();
    private final DecimalFormat df = new DecimalFormat("#,##0.00####");
    private final DecimalFormat dfImport = new DecimalFormat();
    private static EditPointPanel editPointPanel = null;
    private static EnableCheck ptCheck = EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{Point.class});
    public static final EnableCheck chkLyUsePoint = new EnableCheck(){

        @Override
        public String check(JComponent component) {
            if (EditingPanel.instanceOf().getCurrentLayer() == null || EditingPanel.instanceOf().getCurrentLayer().getFMD() == null || EditingPanel.instanceOf().getCurrentLayer() instanceof DimLayer) {
                return "No editable layer";
            }
            return ptCheck.check(component);
        }
    };
    public static final EnableCheck chkLyUseSymbolOrientation = new EnableCheck(){

        @Override
        public String check(JComponent component) {
            if (EditingPanel.instanceOf().getCurrentLayer() == null || EditingPanel.instanceOf().getCurrentLayer().getFMD() == null || EditingPanel.instanceOf().getCurrentLayer() instanceof DimLayer) {
                return "No editable layer";
            }
            if (EditingPanel.instanceOf().getCurrentLayer().getFMD().getOriAtt() == null || EditingPanel.instanceOf().getCurrentLayer().getFMD().getOriAtt().isEmpty()) {
                return "No symbol orientation";
            }
            return null;
        }
    };
    private JCheckBox cbSetRotation;
    private JCheckBox cbSetRotationPoint;
    private JLabel lblX;
    private JLabel lblY;
    private JPanel pnlTools;
    private JFormattedTextField txtX;
    private JFormattedTextField txtY;

    private EditPointPanel() {
        this.initComponents();
        this.i18n();
        this.init();
        GUISupport.addCopyInsertPopup((JTextComponent)this.txtX);
        GUISupport.addCopyInsertPopup((JTextComponent)this.txtY);
    }

    public static EditPointPanel instanceOf() {
        if (editPointPanel == null) {
            editPointPanel = new EditPointPanel();
        }
        return editPointPanel;
    }

    public final void i18n() {
        this.lblY.setText(I18N.get("ui.cursortool.editing.EditPointPanel.X"));
        this.lblX.setText(I18N.get("ui.cursortool.editing.EditPointPanel.Y"));
        this.cbSetRotation.setText(I18N.get("ui.cursortool.editing.EditPointPanel.set-rotation"));
        this.cbSetRotationPoint.setText(I18N.get("ui.cursortool.editing.EditPointPanel.set-rotation-point"));
    }

    public final void init() {
        this.pnlTools.add((Component)this.pnlToolbox, "Center");
        this.pnlToolbox.add(DrawPointTool.create(this.pnlToolbox.getContext()), EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{Point.class}));
        this.pnlToolbox.getToolBar().addSeparator();
        DrawPointAtCoordinatePlugIn dpacPlugIn = new DrawPointAtCoordinatePlugIn();
        this.pnlToolbox.addPlugIn(dpacPlugIn, dpacPlugIn.createEnableCheck(), dpacPlugIn.getIcon());
        this.txtX.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtY.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtX.getDocument().addDocumentListener(new CoordinateFieldsDocumentListener(this.txtX, this.txtX, this.txtY));
        this.txtY.getDocument().addDocumentListener(new CoordinateFieldsDocumentListener(this.txtY, this.txtX, this.txtY));
        Boolean boolSetRotation = PersistentBlackboardPlugIn.get().getBoolean(KEY_SET_ROTATION);
        if (boolSetRotation != null) {
            this.cbSetRotation.setSelected(boolSetRotation);
            this.cbSetRotationPoint.setEnabled(this.cbSetRotation.isEnabled() && boolSetRotation != false);
        }
        this.cbSetRotation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                PersistentBlackboardPlugIn.get().put(KEY_SET_ROTATION, selected);
                EditPointPanel.this.cbSetRotationPoint.setEnabled(selected);
            }
        });
        Boolean boolSetRotationPoint = PersistentBlackboardPlugIn.get().getBoolean(KEY_SET_ROTATION_POINT);
        if (boolSetRotationPoint != null) {
            this.cbSetRotationPoint.setSelected(boolSetRotationPoint);
        }
        this.cbSetRotationPoint.addItemListener(new ItemListener(this){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                PersistentBlackboardPlugIn.get().put(KEY_SET_ROTATION_POINT, selected);
            }
        });
    }

    public void activateDrawPointTool(LayerViewPanel lyViewPanel) {
        if (chkLyUsePoint.check(null) == null) {
            this.pnlToolbox.getToolBar().getButton(0).doClick();
        }
    }

    public static EnableCheck getLayerUsePointCheck() {
        return chkLyUsePoint;
    }

    @Override
    public void updateEnabledState() {
        this.cbSetRotation.setEnabled(chkLyUseSymbolOrientation.check(null) == null);
        this.cbSetRotationPoint.setEnabled(this.cbSetRotation.isEnabled() && this.cbSetRotation.isSelected());
        this.pnlToolbox.updateEnabledState();
    }

    public double getXCoord() throws ParseException {
        String strValue = this.txtX.getText().trim();
        if (strValue.equals("-") || strValue.length() == 0) {
            strValue = "0";
        }
        return this.df.parse(strValue).doubleValue();
    }

    public void setXCoord(double dblX) {
        this.txtX.setText(this.df.format(dblX));
    }

    public double getYCoord() throws ParseException {
        String strValue = this.txtY.getText().trim();
        if (strValue.equals("-") || strValue.length() == 0) {
            strValue = "0";
        }
        return this.df.parse(strValue).doubleValue();
    }

    public void setYCoord(double dblY) {
        this.txtY.setText(this.df.format(dblY));
    }

    public boolean isSetRotationSelected() {
        return this.cbSetRotation.isEnabled() && this.cbSetRotation.isSelected();
    }

    public boolean isSetRotationPointSelected() {
        return this.cbSetRotationPoint.isEnabled() && this.cbSetRotationPoint.isSelected();
    }

    private void initComponents() {
        this.pnlTools = new JPanel();
        this.lblX = new JLabel();
        this.txtY = new JFormattedTextField();
        this.lblY = new JLabel();
        this.txtX = new JFormattedTextField();
        this.cbSetRotation = new JCheckBox();
        this.cbSetRotationPoint = new JCheckBox();
        this.setEnabled(false);
        this.setPreferredSize(new Dimension(180, 200));
        this.setLayout(new GridBagLayout());
        this.pnlTools.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlTools, gridBagConstraints);
        this.lblX.setText("X:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblX, gridBagConstraints);
        this.txtY.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtY, gridBagConstraints);
        this.lblY.setText("Y:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblY, gridBagConstraints);
        this.txtX.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtX, gridBagConstraints);
        this.cbSetRotation.setText("Drehung erfassen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbSetRotation, gridBagConstraints);
        this.cbSetRotationPoint.setText("Drehpunkt automatisch setzen");
        this.cbSetRotationPoint.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 99999.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbSetRotationPoint, gridBagConstraints);
    }
}

