/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DrawLineStringTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditLineStringTool
extends DrawLineStringTool {
    private static final Logger LOG = LoggerFactory.getLogger(EditLineStringTool.class);
    private Layer ly2Edit = null;
    private SimpleFeature feat2Edit = null;
    private LineString geom2Edit = null;
    private boolean active = false;
    private final KeyListener klstEnter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10) {
                try {
                    EditLineStringTool.this.finishGesture();
                }
                catch (Exception e1) {
                    WorkbenchContext.getFrame().handleThrowable(e1);
                }
            }
        }
    };

    private EditLineStringTool() {
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new EditLineStringTool(), true);
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.EditLineString.edit-linestring");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_edit_line.svg");
    }

    @Override
    protected void gestureFinished() throws Exception {
        LineString newLine;
        if (!this.checkLineString()) {
            return;
        }
        LineString newGeom = newLine = this.getLineString();
        SimpleFeature f = FeatureUtil.cloneFeature((SimpleFeature)this.feat2Edit);
        Geometry wholeFeatGeom = (Geometry)f.getDefaultGeometry();
        if (wholeFeatGeom instanceof GeometryCollection) {
            ArrayList<Object> lstNewGeom = new ArrayList<Object>();
            for (int i = 0; i < wholeFeatGeom.getNumGeometries(); ++i) {
                Geometry cand = wholeFeatGeom.getGeometryN(i);
                if (cand == this.geom2Edit) continue;
                lstNewGeom.add(cand);
            }
            lstNewGeom.add(newGeom);
            newGeom = wholeFeatGeom.getFactory().buildGeometry(lstNewGeom);
        }
        EditTransaction transaction = new EditTransaction(Arrays.asList(f), this.getName(), this.ly2Edit, this.isRollingBackInvalidEdits(), false, this.getPanel());
        transaction.setGeometry(0, (Geometry)newGeom);
        transaction.commit();
        WorkbenchContext.getInstance().getSelectionManager().clear();
        EditingPanel.instanceOf().activateDefaultCT();
    }

    private static Layer getLayer(LayerViewPanel panel) {
        if (panel == null) {
            return null;
        }
        Collection<Layer> colLy = panel.getSelectionManager().getLayersWithSelectedItems();
        if (colLy.size() != 1) {
            return null;
        }
        return colLy.iterator().next();
    }

    private static SimpleFeature getFeature(LayerViewPanel panel, Layer ly) {
        if (ly == null || panel == null) {
            return null;
        }
        Collection<SimpleFeature> colFeat = panel.getSelectionManager().getFeaturesWithSelectedItems(ly);
        if (colFeat.size() != 1) {
            return null;
        }
        return colFeat.iterator().next();
    }

    private static LineString getGeometry(LayerViewPanel panel, Layer ly, SimpleFeature feat) {
        MultiLineString mline;
        if (ly == null || panel == null) {
            return null;
        }
        Collection<Geometry> colGeom = panel.getSelectionManager().getSelectedItems(ly, feat);
        if (colGeom.size() != 1) {
            return null;
        }
        Geometry featGeom = colGeom.iterator().next();
        if (featGeom instanceof MultiLineString && (mline = (MultiLineString)featGeom).getNumGeometries() == 1) {
            return (LineString)mline.getGeometryN(0);
        }
        if (featGeom instanceof LineString) {
            return (LineString)featGeom;
        }
        return null;
    }

    public static EnableCheck createEnableCheck() {
        final EnableCheck editSelCheck = EditingPanel.instanceOf().getEditSelectionLayerEnableCheck();
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String strEditCheck = editSelCheck.check(component);
                if (strEditCheck != null) {
                    return strEditCheck;
                }
                Layer ly = EditLineStringTool.getLayer(WorkbenchContext.getInstance().getLayerViewPanel());
                if (ly == null) {
                    return "Please select exactly one feature with a linestring geometry.";
                }
                SimpleFeature feat = EditLineStringTool.getFeature(WorkbenchContext.getInstance().getLayerViewPanel(), ly);
                if (feat == null) {
                    return "Please select exactly one feature with a linestring geometry.";
                }
                LineString line = EditLineStringTool.getGeometry(WorkbenchContext.getInstance().getLayerViewPanel(), ly, feat);
                if (line == null) {
                    return "Please select exactly one feature with a linestring geometry.";
                }
                return null;
            }
        };
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.active = false;
    }

    @Override
    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        if (!this.active) {
            this.resetCoordinates();
            this.ly2Edit = EditLineStringTool.getLayer(panel);
            this.feat2Edit = EditLineStringTool.getFeature(panel, this.ly2Edit);
            if (this.feat2Edit == null) {
                Assert.shouldNeverReachHere();
            }
            this.geom2Edit = EditLineStringTool.getGeometry(panel, this.ly2Edit, this.feat2Edit);
            Coordinate[] arrCoord = this.geom2Edit.getCoordinates();
            this.addAll(arrCoord);
            this.active = true;
        }
    }

    @Override
    public KeyListener getKeyListener() {
        return this.klstEnter;
    }
}

