/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.RectangleTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class DrawRectangleTool
extends RectangleTool {
    private double width = 20.0;
    private double height = 20.0;
    private Point2D mouseReleasePoint;
    private final ActionListener valueChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DrawRectangleTool.this.width = (Double)GetValuePanel.instanceOf().getValue();
            }
            catch (Throwable t) {
                DrawRectangleTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };
    private final ActionListener value1ChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DrawRectangleTool.this.height = (Double)GetValuePanel.instanceOf().getValue1();
            }
            catch (Throwable t) {
                DrawRectangleTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };

    private DrawRectangleTool() {
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new DrawRectangleTool(), true);
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.DrawRectangleTool.name");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_rectangle.svg");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        try {
            super.mouseDragged(e);
            if (!this.isDragApproved()) {
                return;
            }
            Coordinate coordStart = this.getModelSource();
            Coordinate coordEnd = this.getModelDestination();
            this.width = coordEnd.x - coordStart.x;
            this.height = coordEnd.y - coordStart.y;
            Task task = this.getTaskFrame().getTask();
            if (task.isProjectionReductionActive()) {
                CRSDefinition crsDef = task.getCRSDefinition();
                DrawingUnit unit = task.getDrawingUnit();
                double heightReduction = task.getHeightReduction();
                Coordinate coordCenter = CoordUtil.average(coordStart, coordEnd);
                double distWidthConverted = crsDef.getRealWorldDistance(this.width, heightReduction, coordCenter, unit);
                double distHeightConverted = crsDef.getRealWorldDistance(this.height, heightReduction, coordCenter, unit);
                this.width = distWidthConverted;
                this.height = distHeightConverted;
            }
            GetValuePanel.instanceOf().setValue(this.width);
            GetValuePanel.instanceOf().setValue1(this.height);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            Coordinate endPoint;
            this.setViewSource(e.getPoint());
            this.modelDestination = endPoint = new Coordinate(this.modelSource.x + this.width, this.modelSource.y + this.height);
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseReleasePoint = e.getPoint();
        super.mouseReleased(e);
    }

    @Override
    protected Shape getShape() {
        try {
            Coordinate endPoint = new Coordinate(this.getModelDestination().x, this.getModelDestination().y);
            Point2D viewDestinationPoint = this.getPanel().getViewport().toViewPoint(endPoint);
            return super.getShape(this.getViewSource(), viewDestinationPoint);
        }
        catch (Exception e) {
            System.out.println("DrawRectangleTool : Exception " + String.valueOf(e));
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.getModelSource().equals((Object)this.getModelDestination())) {
            return;
        }
        Polygon rectangle = this.getRectangle();
        this.setViewDestination(this.mouseReleasePoint);
        Task task = this.getTaskFrame().getTask();
        if (task.isProjectionReductionActive() && (!this.getSnapManager().wasSnapCoordinateFound() || this.wasClick())) {
            Point pointCenter = rectangle.getCentroid();
            Coordinate coordCenter = new Coordinate(pointCenter.getX(), pointCenter.getY());
            Coordinate[] coords = rectangle.getCoordinates();
            Coordinate source = coords[0];
            Coordinate dest = coords[2];
            double dist = source.distance(dest);
            CRSDefinition crsDef = task.getCRSDefinition();
            DrawingUnit unit = task.getDrawingUnit();
            double distanceConverted = crsDef.getProjectedDistance(dist, task.getHeightReduction(), coordCenter, unit);
            double t = ConstSupport.getOrientation((Coordinate)source, (Coordinate)dest, (int)2);
            Coordinate coordEndConverted = ConstSupport.getPolarCoord((Coordinate)source, (double)distanceConverted, (double)t);
            Envelope e = new Envelope(source.x, coordEndConverted.x, source.y, coordEndConverted.y);
            rectangle = new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(e.getMinX(), e.getMinY(), 0.0), new Coordinate(e.getMinX(), e.getMaxY(), 0.0), new Coordinate(e.getMaxX(), e.getMaxY(), 0.0), new Coordinate(e.getMaxX(), e.getMinY(), 0.0), new Coordinate(e.getMinX(), e.getMinY(), 0.0)}), null);
        }
        FeatureDrawingUtil.drawRing(rectangle, this.isRollingBackInvalidEdits(), this, this.getPanel());
        SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setValueFormat(0);
        valPanel.setValue1Format(0);
        valPanel.setDescription(I18N.get("ui.cursortool.editing.DrawRectangleTool.description"));
        valPanel.setValueLabelListener(I18N.get("common.width"), this.valueChangedListener);
        valPanel.setValue1LabelListener(I18N.get("common.height"), this.value1ChangedListener);
        valPanel.setValue(this.width);
        valPanel.setValue1(this.height);
        return valPanel;
    }
}

