/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.reduction.ProjectionReduction;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.construction.ConstSupport;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class DrawPolygonTool
extends PolygonTool {
    private static final GeometryFactory GFAC = new GeometryFactory();
    private static final String I18N_AREA = I18N.get("ui.cursortool.MeasureTool.area");
    private final DecimalFormat dfArea = new DecimalFormat();
    private String strUnit = "";
    private DrawingUnit unit = null;
    private final ActionListener valueChangedListener = e -> {
        try {
            this.setAngle((Double)GetValuePanel.instanceOf().getValue());
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    };
    private final ActionListener value1ChangedListener = e -> {
        try {
            this.setLength((Double)GetValuePanel.instanceOf().getValue1());
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    };
    private final ActionListener cbo1Listener = e -> {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        this.setUseAngleConstraint(valPanel.getCbo1Value());
        this.getAssistentPanel();
    };
    private final ActionListener cbo2Listener = e -> {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        this.setUseLengthConstraint(valPanel.getCbo2Value());
        this.getAssistentPanel();
    };

    protected DrawPolygonTool() {
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new DrawPolygonTool(), true);
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.DrawPolygonTool.name");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_polygon.svg");
    }

    @Override
    public boolean useTooltip() {
        return true;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        try {
            ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
            currentCoordinates.add(this.getTentativeCoordinate());
            return this.getTooltipHtml(currentCoordinates);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (!this.checkPolygon()) {
            return;
        }
        FeatureDrawingUtil.drawRing(this.getPolygon(), this.isRollingBackInvalidEdits(), this, this.getPanel());
        SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setDescription("<html>" + I18N.get("ui.cursortool.editing.DrawPolygonTool.desc") + "</html>");
        valPanel.setCbo1LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.draw-constrained-angle"), this.cbo1Listener);
        valPanel.setCbo1Value(this.getUseAngleConstraint());
        valPanel.setCbo2LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.draw-constrained-length"), this.cbo2Listener);
        valPanel.setCbo2Value(this.getUseLengthConstraint());
        if (this.getUseAngleConstraint()) {
            valPanel.setValueFormat(0);
            valPanel.setValueLabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.angle"), this.valueChangedListener);
            valPanel.setValue(this.getAngle());
        }
        if (this.getUseLengthConstraint()) {
            valPanel.setValue1Format(0);
            valPanel.setValue1LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.length"), this.value1ChangedListener);
            valPanel.setValue1(this.getLength());
        }
        valPanel.setLeftButton(I18N.get("common.back"), e -> this.back());
        return valPanel;
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        super.mouseLocationChanged(e);
        try {
            List<Coordinate> lstCoord = this.getCoordinates();
            if (this.isShapeOnScreen() && lstCoord.size() > 0) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(lstCoord);
                currentCoordinates.add(this.getTentativeCoordinate());
                this.display(currentCoordinates);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private void display(List<Coordinate> coordinates) {
        double area = this.calculateArea(coordinates);
        this.display(area);
    }

    private void display(double area) {
        WorkbenchContext.getFrame().setMemoryMessage("<html><nobr>" + I18N_AREA + ": <b color='blue'>" + this.dfArea.format(area) + this.strUnit + "\u00b2</b></nobr></html>");
    }

    private String getTooltipHtml(List<Coordinate> coordinates) {
        double area = this.calculateArea(coordinates);
        return this.getTooltipHtml(area);
    }

    private String getTooltipHtml(double area) {
        return "<html>" + I18N_AREA + ": <b color='blue'>" + this.dfArea.format(area) + this.strUnit + "\u00b2</b></html>";
    }

    private double calculateArea(List<Coordinate> coordinates) {
        double area;
        if (coordinates.size() > 2) {
            ArrayList<Coordinate> lstRing = new ArrayList<Coordinate>(coordinates);
            lstRing.add(coordinates.get(0));
            LinearRing lring = GFAC.createLinearRing(lstRing.toArray(new Coordinate[0]));
            ProjectionReduction reduction = ProjectionReduction.getInstance();
            Polygon polygon = GFAC.createPolygon(lring, null);
            area = reduction.calculateRealWorldArea((Geometry)polygon);
        } else {
            area = 0.0;
        }
        return area;
    }

    @Override
    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        this.unit = panel.getLayerManager().getTask().getDrawingUnit();
        this.strUnit = this.unit.getUnitAbbreviation();
        double dblUnitInMeter = this.unit.getUnitInMeter();
        double dblUnitInCentimeter = dblUnitInMeter * 100.0;
        int intDecPlaces = ("" + (int)dblUnitInCentimeter).length() - 1;
        this.dfArea.setGroupingUsed(false);
        this.dfArea.setMaximumFractionDigits((intDecPlaces - 1) * 2);
    }

    @Override
    protected void add(Coordinate c) {
        Coordinate[] coordPoly;
        int l;
        Coordinate coordTmp = c;
        Task task = this.getTaskFrame().getTask();
        if (task.isProjectionReductionActive() && !this.getSnapManager().wasSnapCoordinateFound() && (l = (coordPoly = DrawPolygonTool.toArray(this.getCoordinates())).length) > 0) {
            Coordinate coordStart = coordPoly[l - 1];
            CRSDefinition crsDef = task.getCRSDefinition();
            double dblLastDist = ConstSupport.getLength((Coordinate)coordStart, (Coordinate)coordTmp);
            Coordinate coordCenter = CoordUtil.average(coordStart, coordTmp);
            double distanceConverted = crsDef.getProjectedDistance(dblLastDist, task.getHeightReduction(), coordCenter, this.unit);
            double t = ConstSupport.getOrientation((Coordinate)coordStart, (Coordinate)coordTmp, (int)2);
            coordTmp = ConstSupport.getPolarCoord((Coordinate)coordStart, (double)distanceConverted, (double)t);
        }
        super.add(coordTmp);
    }
}

