/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditPointPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotateSelectedItemPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotateSymbolAndTextTool;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.icons.IconLoader;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class DrawPointTool
extends NClickTool {
    private DrawPointTool() {
        super(1);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.DrawPointTool.name");
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new DrawPointTool(), true);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_point.svg");
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (EditPointPanel.instanceOf().isSetRotationSelected()) {
            this.execute(FeatureDrawingUtil.createAddCommand((Geometry)this.getPoint(), this.isRollingBackInvalidEdits(), this.getPanel(), FeatureDrawingUtil.layer(), this.getName(), true));
            EditingPanel.instanceOf().activatePanel(RotateSelectedItemPanel.instanceOf());
            RotateSelectedItemPanel.instanceOf().activateRotateSymbolAndTextTool(this.getPanel());
            if (EditPointPanel.instanceOf().isSetRotationPointSelected()) {
                java.awt.Point pt = this.getPanel().getLastClickedPoint();
                this.getPanel().dispatchEvent(new MouseEvent(this.getPanel(), 501, System.currentTimeMillis(), 0, pt.x, pt.y, 1, false, 1));
            }
            AbstractCursorTool.Listener listener = new AbstractCursorTool.Listener(){

                @Override
                public void gestureFinished() {
                    SwingUtilities.invokeLater(this::doSomething);
                }

                @Override
                public void gestureCanceled() {
                    SwingUtilities.invokeLater(this::doSomething);
                }

                private void doSomething() {
                    SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
                    RotateSymbolAndTextTool.getInstance().remove(this);
                    RotateSymbolAndTextTool.getInstance().setUndoable(true);
                    EditPointPanel.instanceOf().activateDrawPointTool(DrawPointTool.this.getPanel());
                }
            };
            RotateSymbolAndTextTool.getInstance().add(listener);
            RotateSymbolAndTextTool.getInstance().setUndoable(false);
        } else {
            this.execute(FeatureDrawingUtil.createAddCommand((Geometry)this.getPoint(), this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
            SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
        }
    }

    protected Point getPoint() {
        return new GeometryFactory().createPoint(this.getCoordinates().get(0));
    }

    @Override
    public JPanel getAssistentPanel() {
        return EditPointPanel.instanceOf();
    }
}

