/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditPointPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.icons.IconLoader;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class DrawPointAtCoordinatePlugIn
extends AbstractPlugIn {
    private static EnableCheck enableCheck = null;

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.layer() instanceof RedlineLayer;
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.DrawPointAtCoordinate.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_point_coordinates.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer ly = EditingPanel.instanceOf().getCurrentLayer();
        if (ly == null) {
            throw new Exception("No editable layer selected");
        }
        if (!ly.getFMD().isInsertAllowed()) {
            throw new Exception("Layer is not insertable");
        }
        double dblX = EditPointPanel.instanceOf().getXCoord();
        double dblY = EditPointPanel.instanceOf().getYCoord();
        Point pt2Insert = this.getPoint(dblX, dblY);
        DrawPointAtCoordinatePlugIn.execute(FeatureDrawingUtil.createAddCommand((Geometry)pt2Insert, true, context.getLayerViewPanel(), this.getName()), (LayerManagerProxy)context, false);
        SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
        return true;
    }

    protected Point getPoint(double dblX, double dblY) throws NoninvertibleTransformException {
        Coordinate coord = new Coordinate(dblX, dblY, 0.0);
        return new GeometryFactory().createPoint(coord);
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                if (enableCheck == null) {
                    enableCheck = EditingPanel.instanceOf().getGeometryTypeCheck(new Class[]{Point.class});
                }
                return enableCheck.check(component);
            }
        };
    }
}

