/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.construction.ConstSupport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.valid.IsValidOp;

public class DrawLineStringTool
extends MultiClickTool {
    private static final GeometryFactory gfac = new GeometryFactory();
    private static final String strDist = I18N.get("ui.cursortool.MeasureTool.dist");
    private static final String MESSAGE_HTML = "<html><nobr>%s: <b color='blue'>%s%s / %s%s</b></nobr></html>";
    private DrawingUnit unit = null;
    private final DecimalFormat dfLength = new DecimalFormat();
    private String strUnit = "";
    private double dblDistanceTotal;
    private double dblLastDistance;
    private final KeyListener klstEnter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10) {
                try {
                    DrawLineStringTool.this.finishGesture();
                }
                catch (Exception e1) {
                    WorkbenchContext.getFrame().handleThrowable(e1);
                }
            }
        }
    };
    private final ActionListener valueChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DrawLineStringTool.this.setAngle((Double)GetValuePanel.instanceOf().getValue());
            }
            catch (Throwable t) {
                DrawLineStringTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };
    private final ActionListener value1ChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DrawLineStringTool.this.setLength((Double)GetValuePanel.instanceOf().getValue1());
            }
            catch (Throwable t) {
                DrawLineStringTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };
    private final ActionListener cbo1Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GetValuePanel valPanel = GetValuePanel.instanceOf();
            DrawLineStringTool.this.setUseAngleConstraint(valPanel.getCbo1Value());
            DrawLineStringTool.this.getAssistentPanel();
        }
    };
    private final ActionListener cbo2Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GetValuePanel valPanel = GetValuePanel.instanceOf();
            DrawLineStringTool.this.setUseLengthConstraint(valPanel.getCbo2Value());
            DrawLineStringTool.this.getAssistentPanel();
        }
    };

    protected DrawLineStringTool() {
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new DrawLineStringTool(), true);
    }

    @Override
    public boolean useTooltip() {
        return true;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        return this.getHtmlMessage(MESSAGE_HTML, this.dblDistanceTotal, this.dblLastDistance);
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.DrawLineString.draw-linestring");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_line.svg");
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (!this.checkLineString()) {
            return;
        }
        this.execute(FeatureDrawingUtil.createAddCommand((Geometry)this.getLineString(), this.isRollingBackInvalidEdits(), this.getPanel(), (AbstractCursorTool)this));
        SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
    }

    @Override
    protected void add(Coordinate c) {
        Coordinate[] coords;
        int l;
        Coordinate coordTmp = c;
        Task task = this.getTaskFrame().getTask();
        if (task.isProjectionReductionActive() && (this.getSnapManager().wasSnapCoordinateFound() && this.getUseLengthConstraint() || !this.getSnapManager().wasSnapCoordinateFound()) && (l = (coords = DrawLineStringTool.toArray(this.getCoordinates())).length) > 0) {
            Coordinate coordStart = coords[l - 1];
            CRSDefinition crsDef = task.getCRSDefinition();
            DrawingUnit unit = task.getDrawingUnit();
            double lastDistance = ConstSupport.getLength((Coordinate)coordStart, (Coordinate)coordTmp);
            Coordinate coordCenter = CoordUtil.average(coordStart, coordTmp);
            double distanceConverted = crsDef.getProjectedDistance(lastDistance, task.getHeightReduction(), coordCenter, unit);
            double t = ConstSupport.getOrientation((Coordinate)coordStart, (Coordinate)coordTmp, (int)2);
            coordTmp = ConstSupport.getPolarCoord((Coordinate)coordStart, (double)distanceConverted, (double)t);
        }
        super.add(coordTmp);
    }

    protected LineString getLineString() throws NoninvertibleTransformException {
        return new GeometryFactory().createLineString(DrawLineStringTool.toArray(this.getCoordinates()));
    }

    protected boolean checkLineString() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.DrawLineString.the-linestring-must-have-at-least-2-points"));
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getLineString());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setDescription("<html>" + I18N.get("ui.cursortool.editing.DrawLineString.desc") + "</html>");
        valPanel.setCbo1LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.draw-constrained-angle"), this.cbo1Listener);
        valPanel.setCbo1Value(this.getUseAngleConstraint());
        valPanel.setCbo2LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.draw-constrained-length"), this.cbo2Listener);
        valPanel.setCbo2Value(this.getUseLengthConstraint());
        if (this.getUseAngleConstraint()) {
            valPanel.setValueFormat(0);
            valPanel.setValueLabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.angle"), this.valueChangedListener);
            valPanel.setValue(new Double(this.getAngle()));
        }
        if (this.getUseLengthConstraint()) {
            valPanel.setValue1Format(0);
            valPanel.setValue1LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.length"), this.value1ChangedListener);
            valPanel.setValue1(new Double(this.getLength()));
        }
        valPanel.setLeftButton(I18N.get("ui.cursortool.editing.DrawLineString.change-direction"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawLineStringTool.this.changeDirection();
            }
        });
        valPanel.setRightButton(I18N.get("common.back"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawLineStringTool.this.back();
            }
        });
        return valPanel;
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        super.mouseLocationChanged(e);
        try {
            List<Coordinate> lstCoord = this.getCoordinates();
            if (this.isShapeOnScreen() && lstCoord.size() > 0) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(lstCoord);
                currentCoordinates.add(this.getTentativeCoordinate());
                this.display(currentCoordinates);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private void display(List coordinates) throws NoninvertibleTransformException {
        ArrayList lstLastCoords = new ArrayList();
        lstLastCoords.add(coordinates.get(coordinates.size() - 2));
        lstLastCoords.add(coordinates.get(coordinates.size() - 1));
        double tmpLastDistance = ConstSupport.getLength(lstLastCoords);
        Task task = this.getTaskFrame().getTask();
        if (task.isProjectionReductionActive()) {
            double tmpDistanceTotal = 0.0;
            CRSDefinition crsDef = task.getCRSDefinition();
            double height = task.getHeightReduction();
            DrawingUnit unit = task.getDrawingUnit();
            if (this.getUseLengthConstraint()) {
                this.dblDistanceTotal = ConstSupport.getLength((List)coordinates);
                this.dblLastDistance = ConstSupport.getLength(lstLastCoords);
            } else if (this.getSnapManager().wasSnapCoordinateFound()) {
                Coordinate coordLastCenter = CoordUtil.average(lstLastCoords);
                double lastDistanceConverted = crsDef.getRealWorldDistance(tmpLastDistance, height, coordLastCenter, unit);
                for (int i = 1; i < coordinates.size(); ++i) {
                    Coordinate coord1 = (Coordinate)coordinates.get(i - 1);
                    Coordinate coord2 = (Coordinate)coordinates.get(i);
                    Coordinate coordCenter = CoordUtil.average(coord1, coord2);
                    double dist = coord1.distance(coord2);
                    double distanceConverted = crsDef.getRealWorldDistance(dist, height, coordCenter, unit);
                    tmpDistanceTotal += distanceConverted;
                }
                this.dblDistanceTotal = tmpDistanceTotal;
                this.dblLastDistance = lastDistanceConverted;
            } else {
                this.dblDistanceTotal = ConstSupport.getLength((List)coordinates);
                this.dblLastDistance = ConstSupport.getLength(lstLastCoords);
            }
        } else {
            this.dblDistanceTotal = ConstSupport.getLength((List)coordinates);
            this.dblLastDistance = ConstSupport.getLength(lstLastCoords);
        }
        WorkbenchContext.getFrame().setMemoryMessage(this.getHtmlMessage(MESSAGE_HTML, this.dblDistanceTotal, this.dblLastDistance));
    }

    @Override
    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        this.unit = panel.getLayerManager().getTask().getDrawingUnit();
        this.strUnit = this.unit.getUnitAbbreviation();
        this.dblDistanceTotal = 0.0;
        this.dblLastDistance = 0.0;
    }

    @Override
    public KeyListener getKeyListener() {
        return this.klstEnter;
    }

    private String getHtmlMessage(String msg, double distance, double lastDistance) {
        StringBuilder sb = new StringBuilder();
        try (Formatter fmt = new Formatter(sb);){
            fmt.format(msg, strDist, this.dfLength.format(distance), this.strUnit, this.dfLength.format(lastDistance), this.strUnit);
        }
        return sb.toString();
    }
}

